/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.doc;

import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDDestination;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDPageFitWidthDestination;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDDocumentOutline;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDOutlineItem;
import org.dromara.pdf.pdfbox.doc.XEasyPdfDocument;

public class XEasyPdfDocumentBookmark
implements Serializable {
    private static final long serialVersionUID = 7120771777001614541L;
    private final XEasyPdfDocument document;
    private final List<PDOutlineItem> itemList = new ArrayList<PDOutlineItem>(64);

    XEasyPdfDocumentBookmark(XEasyPdfDocument document) {
        this.document = document;
        this.initOutlineItem();
    }

    public XEasyPdfDocumentBookmark setBookMark(Integer pageIndex, String title) {
        PDPageFitWidthDestination destination = new PDPageFitWidthDestination();
        destination.setPageNumber(pageIndex.intValue());
        PDOutlineItem item = new PDOutlineItem();
        item.setDestination((PDDestination)destination);
        item.setTitle(title);
        this.itemList.add(item);
        return this;
    }

    public XEasyPdfDocumentBookmark setBookMark(BookmarkNode node) {
        this.itemList.add(node.getItem());
        return this;
    }

    public List<PDOutlineItem> getBookMark() {
        return this.itemList;
    }

    public XEasyPdfDocument finish() {
        this.document.setBookmark(this);
        return this.document;
    }

    private void initOutlineItem() {
        PDDocumentOutline documentOutline;
        PDDocument source = this.document.getParam().getSource();
        if (source != null && (documentOutline = source.getDocumentCatalog().getDocumentOutline()) != null) {
            Iterable children = documentOutline.children();
            for (PDOutlineItem outlineItem : children) {
                this.itemList.add(outlineItem);
            }
        }
    }

    public static class BookmarkNode {
        private final PDOutlineItem outlineItem;
        private final PDPageFitWidthDestination destination;

        public BookmarkNode(PDOutlineItem outlineItem) {
            this.outlineItem = outlineItem;
            this.destination = new PDPageFitWidthDestination();
            this.outlineItem.setDestination((PDDestination)this.destination);
        }

        public static BookmarkNode build() {
            return new BookmarkNode(new PDOutlineItem());
        }

        public BookmarkNode addChild(BookmarkNode childNode) {
            this.outlineItem.addLast(childNode.getItem());
            return this;
        }

        public BookmarkNode setPage(int pageIndex) {
            this.destination.setPageNumber(pageIndex);
            return this;
        }

        public BookmarkNode setTop(int pageY) {
            this.destination.setTop(pageY);
            return this;
        }

        public BookmarkNode setTitle(String title) {
            this.outlineItem.setTitle(title);
            return this;
        }

        public BookmarkNode setTitleColor(Color textColor) {
            this.outlineItem.setTextColor(textColor);
            return this;
        }

        public BookmarkNode enableTitleBold() {
            this.outlineItem.setBold(true);
            return this;
        }

        public BookmarkNode enableTitleItalic() {
            this.outlineItem.setItalic(true);
            return this;
        }

        PDOutlineItem getItem() {
            return this.outlineItem;
        }
    }
}

