/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.doc;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.util.Calendar;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.SignatureInterface;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.SignatureOptions;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.visible.PDVisibleSigProperties;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.visible.PDVisibleSignDesigner;
import org.dromara.pdf.pdfbox.doc.XEasyPdfDocument;
import org.dromara.pdf.pdfbox.doc.XEasyPdfDocumentSignAlgorithm;
import org.dromara.pdf.pdfbox.doc.XEasyPdfDocumentSignFilter;
import org.dromara.pdf.pdfbox.doc.XEasyPdfDocumentSignKeyStoreType;

class XEasyPdfDocumentSignerParam
implements Serializable {
    private static final long serialVersionUID = -444541984762721143L;
    private transient PDDocument document;
    private XEasyPdfDocument pdfDocument;
    private transient XEasyPdfDocumentSignKeyStoreType keyStoreType;
    private File certificate;
    private String certificatePassword;
    private transient PDSignature signature = new PDSignature();
    private final transient SignatureOptions signatureOptions = new SignatureOptions();
    private transient XEasyPdfDocumentSignAlgorithm signAlgorithm;
    private transient XEasyPdfDocumentSignFilter.Filter filter = XEasyPdfDocumentSignFilter.Filter.FILTER_ADOBE_PPKLITE;
    private transient XEasyPdfDocumentSignFilter.SubFilter subFilter = XEasyPdfDocumentSignFilter.SubFilter.SUBFILTER_ADBE_PKCS7_DETACHED;
    private transient SignatureInterface customSignature;
    private Integer accessPermissions = 1;
    private transient BufferedImage image;
    private Float imageMarginLeft = Float.valueOf(0.0f);
    private Float imageMarginTop = Float.valueOf(0.0f);
    private Float imageScalePercent = Float.valueOf(0.0f);
    private Integer preferredSignatureSize = 256000;
    private String tempDir = "";

    void init(int pageIndex) {
        if (this.keyStoreType == null) {
            throw new IllegalArgumentException("keyStore type can not be null");
        }
        if (this.certificate == null) {
            throw new FileNotFoundException("certificate can not be null");
        }
        if (this.certificatePassword == null) {
            throw new IllegalArgumentException("certificate password can not be null");
        }
        if (this.signAlgorithm == null) {
            throw new IllegalArgumentException("signAlgorithm can not be null");
        }
        this.signature.setFilter(this.filter.getFilter());
        this.signature.setSubFilter(this.subFilter.getFilter());
        this.signature.setSignDate(Calendar.getInstance());
        if (this.image != null) {
            PDVisibleSigProperties signatureProperty = new PDVisibleSigProperties();
            PDVisibleSignDesigner designer = new PDVisibleSignDesigner(this.document, this.image, pageIndex + 1);
            designer.zoom(this.imageScalePercent.floatValue());
            designer.xAxis(this.imageMarginLeft.floatValue());
            designer.yAxis(this.imageMarginTop.floatValue());
            designer.adjustForRotation();
            signatureProperty.signerName(this.signature.getName()).signerLocation(this.signature.getLocation()).signatureReason(this.signature.getReason()).page(pageIndex + 1).visualSignEnabled(true).setPdVisibleSignature(designer).buildSignature();
            this.signatureOptions.setVisualSignature(signatureProperty);
            this.signatureOptions.setPage(pageIndex);
        }
        this.signatureOptions.setPreferredSignatureSize(this.preferredSignatureSize.intValue());
    }

    public PDDocument getDocument() {
        return this.document;
    }

    public XEasyPdfDocument getPdfDocument() {
        return this.pdfDocument;
    }

    public XEasyPdfDocumentSignKeyStoreType getKeyStoreType() {
        return this.keyStoreType;
    }

    public File getCertificate() {
        return this.certificate;
    }

    public String getCertificatePassword() {
        return this.certificatePassword;
    }

    public PDSignature getSignature() {
        return this.signature;
    }

    public SignatureOptions getSignatureOptions() {
        return this.signatureOptions;
    }

    public XEasyPdfDocumentSignAlgorithm getSignAlgorithm() {
        return this.signAlgorithm;
    }

    public XEasyPdfDocumentSignFilter.Filter getFilter() {
        return this.filter;
    }

    public XEasyPdfDocumentSignFilter.SubFilter getSubFilter() {
        return this.subFilter;
    }

    public SignatureInterface getCustomSignature() {
        return this.customSignature;
    }

    public Integer getAccessPermissions() {
        return this.accessPermissions;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public Float getImageMarginLeft() {
        return this.imageMarginLeft;
    }

    public Float getImageMarginTop() {
        return this.imageMarginTop;
    }

    public Float getImageScalePercent() {
        return this.imageScalePercent;
    }

    public Integer getPreferredSignatureSize() {
        return this.preferredSignatureSize;
    }

    public String getTempDir() {
        return this.tempDir;
    }

    public XEasyPdfDocumentSignerParam setDocument(PDDocument document) {
        this.document = document;
        return this;
    }

    public XEasyPdfDocumentSignerParam setPdfDocument(XEasyPdfDocument pdfDocument) {
        this.pdfDocument = pdfDocument;
        return this;
    }

    public XEasyPdfDocumentSignerParam setKeyStoreType(XEasyPdfDocumentSignKeyStoreType keyStoreType) {
        this.keyStoreType = keyStoreType;
        return this;
    }

    public XEasyPdfDocumentSignerParam setCertificate(File certificate) {
        this.certificate = certificate;
        return this;
    }

    public XEasyPdfDocumentSignerParam setCertificatePassword(String certificatePassword) {
        this.certificatePassword = certificatePassword;
        return this;
    }

    public XEasyPdfDocumentSignerParam setSignature(PDSignature signature) {
        this.signature = signature;
        return this;
    }

    public XEasyPdfDocumentSignerParam setSignAlgorithm(XEasyPdfDocumentSignAlgorithm signAlgorithm) {
        this.signAlgorithm = signAlgorithm;
        return this;
    }

    public XEasyPdfDocumentSignerParam setFilter(XEasyPdfDocumentSignFilter.Filter filter) {
        this.filter = filter;
        return this;
    }

    public XEasyPdfDocumentSignerParam setSubFilter(XEasyPdfDocumentSignFilter.SubFilter subFilter) {
        this.subFilter = subFilter;
        return this;
    }

    public XEasyPdfDocumentSignerParam setCustomSignature(SignatureInterface customSignature) {
        this.customSignature = customSignature;
        return this;
    }

    public XEasyPdfDocumentSignerParam setAccessPermissions(Integer accessPermissions) {
        this.accessPermissions = accessPermissions;
        return this;
    }

    public XEasyPdfDocumentSignerParam setImage(BufferedImage image) {
        this.image = image;
        return this;
    }

    public XEasyPdfDocumentSignerParam setImageMarginLeft(Float imageMarginLeft) {
        this.imageMarginLeft = imageMarginLeft;
        return this;
    }

    public XEasyPdfDocumentSignerParam setImageMarginTop(Float imageMarginTop) {
        this.imageMarginTop = imageMarginTop;
        return this;
    }

    public XEasyPdfDocumentSignerParam setImageScalePercent(Float imageScalePercent) {
        this.imageScalePercent = imageScalePercent;
        return this;
    }

    public XEasyPdfDocumentSignerParam setPreferredSignatureSize(Integer preferredSignatureSize) {
        this.preferredSignatureSize = preferredSignatureSize;
        return this;
    }

    public XEasyPdfDocumentSignerParam setTempDir(String tempDir) {
        this.tempDir = tempDir;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof XEasyPdfDocumentSignerParam)) {
            return false;
        }
        XEasyPdfDocumentSignerParam other = (XEasyPdfDocumentSignerParam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$accessPermissions = this.getAccessPermissions();
        Integer other$accessPermissions = other.getAccessPermissions();
        if (this$accessPermissions == null ? other$accessPermissions != null : !((Object)this$accessPermissions).equals(other$accessPermissions)) {
            return false;
        }
        Float this$imageMarginLeft = this.getImageMarginLeft();
        Float other$imageMarginLeft = other.getImageMarginLeft();
        if (this$imageMarginLeft == null ? other$imageMarginLeft != null : !((Object)this$imageMarginLeft).equals(other$imageMarginLeft)) {
            return false;
        }
        Float this$imageMarginTop = this.getImageMarginTop();
        Float other$imageMarginTop = other.getImageMarginTop();
        if (this$imageMarginTop == null ? other$imageMarginTop != null : !((Object)this$imageMarginTop).equals(other$imageMarginTop)) {
            return false;
        }
        Float this$imageScalePercent = this.getImageScalePercent();
        Float other$imageScalePercent = other.getImageScalePercent();
        if (this$imageScalePercent == null ? other$imageScalePercent != null : !((Object)this$imageScalePercent).equals(other$imageScalePercent)) {
            return false;
        }
        Integer this$preferredSignatureSize = this.getPreferredSignatureSize();
        Integer other$preferredSignatureSize = other.getPreferredSignatureSize();
        if (this$preferredSignatureSize == null ? other$preferredSignatureSize != null : !((Object)this$preferredSignatureSize).equals(other$preferredSignatureSize)) {
            return false;
        }
        XEasyPdfDocument this$pdfDocument = this.getPdfDocument();
        XEasyPdfDocument other$pdfDocument = other.getPdfDocument();
        if (this$pdfDocument == null ? other$pdfDocument != null : !this$pdfDocument.equals(other$pdfDocument)) {
            return false;
        }
        File this$certificate = this.getCertificate();
        File other$certificate = other.getCertificate();
        if (this$certificate == null ? other$certificate != null : !((Object)this$certificate).equals(other$certificate)) {
            return false;
        }
        String this$certificatePassword = this.getCertificatePassword();
        String other$certificatePassword = other.getCertificatePassword();
        if (this$certificatePassword == null ? other$certificatePassword != null : !this$certificatePassword.equals(other$certificatePassword)) {
            return false;
        }
        String this$tempDir = this.getTempDir();
        String other$tempDir = other.getTempDir();
        return !(this$tempDir == null ? other$tempDir != null : !this$tempDir.equals(other$tempDir));
    }

    protected boolean canEqual(Object other) {
        return other instanceof XEasyPdfDocumentSignerParam;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $accessPermissions = this.getAccessPermissions();
        result = result * 59 + ($accessPermissions == null ? 43 : ((Object)$accessPermissions).hashCode());
        Float $imageMarginLeft = this.getImageMarginLeft();
        result = result * 59 + ($imageMarginLeft == null ? 43 : ((Object)$imageMarginLeft).hashCode());
        Float $imageMarginTop = this.getImageMarginTop();
        result = result * 59 + ($imageMarginTop == null ? 43 : ((Object)$imageMarginTop).hashCode());
        Float $imageScalePercent = this.getImageScalePercent();
        result = result * 59 + ($imageScalePercent == null ? 43 : ((Object)$imageScalePercent).hashCode());
        Integer $preferredSignatureSize = this.getPreferredSignatureSize();
        result = result * 59 + ($preferredSignatureSize == null ? 43 : ((Object)$preferredSignatureSize).hashCode());
        XEasyPdfDocument $pdfDocument = this.getPdfDocument();
        result = result * 59 + ($pdfDocument == null ? 43 : $pdfDocument.hashCode());
        File $certificate = this.getCertificate();
        result = result * 59 + ($certificate == null ? 43 : ((Object)$certificate).hashCode());
        String $certificatePassword = this.getCertificatePassword();
        result = result * 59 + ($certificatePassword == null ? 43 : $certificatePassword.hashCode());
        String $tempDir = this.getTempDir();
        result = result * 59 + ($tempDir == null ? 43 : $tempDir.hashCode());
        return result;
    }

    public String toString() {
        return "XEasyPdfDocumentSignerParam(document=" + this.getDocument() + ", pdfDocument=" + this.getPdfDocument() + ", keyStoreType=" + (Object)((Object)this.getKeyStoreType()) + ", certificate=" + this.getCertificate() + ", certificatePassword=" + this.getCertificatePassword() + ", signature=" + this.getSignature() + ", signatureOptions=" + this.getSignatureOptions() + ", signAlgorithm=" + (Object)((Object)this.getSignAlgorithm()) + ", filter=" + (Object)((Object)this.getFilter()) + ", subFilter=" + (Object)((Object)this.getSubFilter()) + ", customSignature=" + this.getCustomSignature() + ", accessPermissions=" + this.getAccessPermissions() + ", image=" + this.getImage() + ", imageMarginLeft=" + this.getImageMarginLeft() + ", imageMarginTop=" + this.getImageMarginTop() + ", imageScalePercent=" + this.getImageScalePercent() + ", preferredSignatureSize=" + this.getPreferredSignatureSize() + ", tempDir=" + this.getTempDir() + ")";
    }
}

