/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.doc;

import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.dromara.pdf.pdfbox.component.XEasyPdfComponent;
import org.dromara.pdf.pdfbox.component.image.XEasyPdfImage;
import org.dromara.pdf.pdfbox.doc.XEasyPdfDocument;
import org.dromara.pdf.pdfbox.doc.XEasyPdfDocumentParam;
import org.dromara.pdf.pdfbox.doc.XEasyPdfPage;
import org.dromara.pdf.pdfbox.doc.XEasyPdfPageRectangle;
import org.dromara.pdf.pdfbox.footer.XEasyPdfFooter;
import org.dromara.pdf.pdfbox.header.XEasyPdfHeader;
import org.dromara.pdf.pdfbox.mark.XEasyPdfWatermark;
import org.dromara.pdf.pdfbox.util.XEasyPdfFontUtil;

class XEasyPdfPageParam
implements Serializable {
    private static final long serialVersionUID = 3226308238459966086L;
    private XEasyPdfComponent.ContentMode contentMode;
    private Boolean isResetContext;
    private String fontPath;
    private PDFont font;
    private Float pageX;
    private Float pageY;
    private XEasyPdfPageRectangle originalPageSize = XEasyPdfPageRectangle.A4;
    private XEasyPdfPageRectangle currentPageSize = XEasyPdfPageRectangle.A4;
    private transient PDRectangle modifyPageSize;
    private Integer rotation;
    private List<PDPage> pageList = new ArrayList<PDPage>(64);
    private List<PDPage> newPageList = new ArrayList<PDPage>(64);
    private transient PDPage lastPage;
    private transient List<XEasyPdfComponent> componentList = new ArrayList<XEasyPdfComponent>(64);
    private Float marginLeft;
    private Float marginRight;
    private Float marginTop;
    private Float marginBottom;
    private XEasyPdfWatermark watermark;
    private XEasyPdfHeader header;
    private XEasyPdfFooter footer;
    private XEasyPdfImage backgroundImage;
    private Color backgroundColor;
    private Boolean allowWatermark = Boolean.TRUE;
    private Boolean allowBackgroundImage = Boolean.TRUE;
    private Boolean allowBackgroundColor = Boolean.TRUE;
    private Boolean allowHeader = Boolean.TRUE;
    private Boolean allowFooter = Boolean.TRUE;
    private Boolean allowResetPosition = Boolean.TRUE;
    private Boolean allowRotateInherentPage = Boolean.TRUE;

    void init(XEasyPdfDocument document, XEasyPdfPage page) {
        XEasyPdfDocumentParam documentParam = document.getParam();
        if (this.contentMode == null) {
            this.contentMode = documentParam.getContentMode();
        }
        if (this.isResetContext == null) {
            this.isResetContext = documentParam.getIsResetContext();
        }
        if (this.fontPath == null) {
            this.fontPath = documentParam.getFontPath();
        }
        if (this.marginLeft == null) {
            this.marginLeft = documentParam.getGlobalMarginLeft();
        }
        if (this.marginRight == null) {
            this.marginRight = documentParam.getGlobalMarginRight();
        }
        if (this.marginTop == null) {
            this.marginTop = documentParam.getGlobalMarginTop();
        }
        if (this.marginBottom == null) {
            this.marginBottom = documentParam.getGlobalMarginBottom();
        }
        if (this.backgroundColor == null) {
            this.backgroundColor = documentParam.getGlobalBackgroundColor();
        }
        if (this.backgroundImage == null) {
            this.backgroundImage = documentParam.getGlobalBackgroundImage();
        }
        this.font = XEasyPdfFontUtil.loadFont(document, page, this.fontPath, true);
    }

    public XEasyPdfComponent.ContentMode getContentMode() {
        return this.contentMode;
    }

    public Boolean getIsResetContext() {
        return this.isResetContext;
    }

    public String getFontPath() {
        return this.fontPath;
    }

    public PDFont getFont() {
        return this.font;
    }

    public Float getPageX() {
        return this.pageX;
    }

    public Float getPageY() {
        return this.pageY;
    }

    public XEasyPdfPageRectangle getOriginalPageSize() {
        return this.originalPageSize;
    }

    public XEasyPdfPageRectangle getCurrentPageSize() {
        return this.currentPageSize;
    }

    public PDRectangle getModifyPageSize() {
        return this.modifyPageSize;
    }

    public Integer getRotation() {
        return this.rotation;
    }

    public List<PDPage> getPageList() {
        return this.pageList;
    }

    public List<PDPage> getNewPageList() {
        return this.newPageList;
    }

    public PDPage getLastPage() {
        return this.lastPage;
    }

    public List<XEasyPdfComponent> getComponentList() {
        return this.componentList;
    }

    public Float getMarginLeft() {
        return this.marginLeft;
    }

    public Float getMarginRight() {
        return this.marginRight;
    }

    public Float getMarginTop() {
        return this.marginTop;
    }

    public Float getMarginBottom() {
        return this.marginBottom;
    }

    public XEasyPdfWatermark getWatermark() {
        return this.watermark;
    }

    public XEasyPdfHeader getHeader() {
        return this.header;
    }

    public XEasyPdfFooter getFooter() {
        return this.footer;
    }

    public XEasyPdfImage getBackgroundImage() {
        return this.backgroundImage;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public Boolean getAllowWatermark() {
        return this.allowWatermark;
    }

    public Boolean getAllowBackgroundImage() {
        return this.allowBackgroundImage;
    }

    public Boolean getAllowBackgroundColor() {
        return this.allowBackgroundColor;
    }

    public Boolean getAllowHeader() {
        return this.allowHeader;
    }

    public Boolean getAllowFooter() {
        return this.allowFooter;
    }

    public Boolean getAllowResetPosition() {
        return this.allowResetPosition;
    }

    public Boolean getAllowRotateInherentPage() {
        return this.allowRotateInherentPage;
    }

    public XEasyPdfPageParam setContentMode(XEasyPdfComponent.ContentMode contentMode) {
        this.contentMode = contentMode;
        return this;
    }

    public XEasyPdfPageParam setIsResetContext(Boolean isResetContext) {
        this.isResetContext = isResetContext;
        return this;
    }

    public XEasyPdfPageParam setFontPath(String fontPath) {
        this.fontPath = fontPath;
        return this;
    }

    public XEasyPdfPageParam setFont(PDFont font) {
        this.font = font;
        return this;
    }

    public XEasyPdfPageParam setPageX(Float pageX) {
        this.pageX = pageX;
        return this;
    }

    public XEasyPdfPageParam setPageY(Float pageY) {
        this.pageY = pageY;
        return this;
    }

    public XEasyPdfPageParam setOriginalPageSize(XEasyPdfPageRectangle originalPageSize) {
        this.originalPageSize = originalPageSize;
        return this;
    }

    public XEasyPdfPageParam setCurrentPageSize(XEasyPdfPageRectangle currentPageSize) {
        this.currentPageSize = currentPageSize;
        return this;
    }

    public XEasyPdfPageParam setModifyPageSize(PDRectangle modifyPageSize) {
        this.modifyPageSize = modifyPageSize;
        return this;
    }

    public XEasyPdfPageParam setRotation(Integer rotation) {
        this.rotation = rotation;
        return this;
    }

    public XEasyPdfPageParam setPageList(List<PDPage> pageList) {
        this.pageList = pageList;
        return this;
    }

    public XEasyPdfPageParam setNewPageList(List<PDPage> newPageList) {
        this.newPageList = newPageList;
        return this;
    }

    public XEasyPdfPageParam setLastPage(PDPage lastPage) {
        this.lastPage = lastPage;
        return this;
    }

    public XEasyPdfPageParam setComponentList(List<XEasyPdfComponent> componentList) {
        this.componentList = componentList;
        return this;
    }

    public XEasyPdfPageParam setMarginLeft(Float marginLeft) {
        this.marginLeft = marginLeft;
        return this;
    }

    public XEasyPdfPageParam setMarginRight(Float marginRight) {
        this.marginRight = marginRight;
        return this;
    }

    public XEasyPdfPageParam setMarginTop(Float marginTop) {
        this.marginTop = marginTop;
        return this;
    }

    public XEasyPdfPageParam setMarginBottom(Float marginBottom) {
        this.marginBottom = marginBottom;
        return this;
    }

    public XEasyPdfPageParam setWatermark(XEasyPdfWatermark watermark) {
        this.watermark = watermark;
        return this;
    }

    public XEasyPdfPageParam setHeader(XEasyPdfHeader header) {
        this.header = header;
        return this;
    }

    public XEasyPdfPageParam setFooter(XEasyPdfFooter footer) {
        this.footer = footer;
        return this;
    }

    public XEasyPdfPageParam setBackgroundImage(XEasyPdfImage backgroundImage) {
        this.backgroundImage = backgroundImage;
        return this;
    }

    public XEasyPdfPageParam setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    public XEasyPdfPageParam setAllowWatermark(Boolean allowWatermark) {
        this.allowWatermark = allowWatermark;
        return this;
    }

    public XEasyPdfPageParam setAllowBackgroundImage(Boolean allowBackgroundImage) {
        this.allowBackgroundImage = allowBackgroundImage;
        return this;
    }

    public XEasyPdfPageParam setAllowBackgroundColor(Boolean allowBackgroundColor) {
        this.allowBackgroundColor = allowBackgroundColor;
        return this;
    }

    public XEasyPdfPageParam setAllowHeader(Boolean allowHeader) {
        this.allowHeader = allowHeader;
        return this;
    }

    public XEasyPdfPageParam setAllowFooter(Boolean allowFooter) {
        this.allowFooter = allowFooter;
        return this;
    }

    public XEasyPdfPageParam setAllowResetPosition(Boolean allowResetPosition) {
        this.allowResetPosition = allowResetPosition;
        return this;
    }

    public XEasyPdfPageParam setAllowRotateInherentPage(Boolean allowRotateInherentPage) {
        this.allowRotateInherentPage = allowRotateInherentPage;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof XEasyPdfPageParam)) {
            return false;
        }
        XEasyPdfPageParam other = (XEasyPdfPageParam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$isResetContext = this.getIsResetContext();
        Boolean other$isResetContext = other.getIsResetContext();
        if (this$isResetContext == null ? other$isResetContext != null : !((Object)this$isResetContext).equals(other$isResetContext)) {
            return false;
        }
        Float this$pageX = this.getPageX();
        Float other$pageX = other.getPageX();
        if (this$pageX == null ? other$pageX != null : !((Object)this$pageX).equals(other$pageX)) {
            return false;
        }
        Float this$pageY = this.getPageY();
        Float other$pageY = other.getPageY();
        if (this$pageY == null ? other$pageY != null : !((Object)this$pageY).equals(other$pageY)) {
            return false;
        }
        Integer this$rotation = this.getRotation();
        Integer other$rotation = other.getRotation();
        if (this$rotation == null ? other$rotation != null : !((Object)this$rotation).equals(other$rotation)) {
            return false;
        }
        Float this$marginLeft = this.getMarginLeft();
        Float other$marginLeft = other.getMarginLeft();
        if (this$marginLeft == null ? other$marginLeft != null : !((Object)this$marginLeft).equals(other$marginLeft)) {
            return false;
        }
        Float this$marginRight = this.getMarginRight();
        Float other$marginRight = other.getMarginRight();
        if (this$marginRight == null ? other$marginRight != null : !((Object)this$marginRight).equals(other$marginRight)) {
            return false;
        }
        Float this$marginTop = this.getMarginTop();
        Float other$marginTop = other.getMarginTop();
        if (this$marginTop == null ? other$marginTop != null : !((Object)this$marginTop).equals(other$marginTop)) {
            return false;
        }
        Float this$marginBottom = this.getMarginBottom();
        Float other$marginBottom = other.getMarginBottom();
        if (this$marginBottom == null ? other$marginBottom != null : !((Object)this$marginBottom).equals(other$marginBottom)) {
            return false;
        }
        Boolean this$allowWatermark = this.getAllowWatermark();
        Boolean other$allowWatermark = other.getAllowWatermark();
        if (this$allowWatermark == null ? other$allowWatermark != null : !((Object)this$allowWatermark).equals(other$allowWatermark)) {
            return false;
        }
        Boolean this$allowBackgroundImage = this.getAllowBackgroundImage();
        Boolean other$allowBackgroundImage = other.getAllowBackgroundImage();
        if (this$allowBackgroundImage == null ? other$allowBackgroundImage != null : !((Object)this$allowBackgroundImage).equals(other$allowBackgroundImage)) {
            return false;
        }
        Boolean this$allowBackgroundColor = this.getAllowBackgroundColor();
        Boolean other$allowBackgroundColor = other.getAllowBackgroundColor();
        if (this$allowBackgroundColor == null ? other$allowBackgroundColor != null : !((Object)this$allowBackgroundColor).equals(other$allowBackgroundColor)) {
            return false;
        }
        Boolean this$allowHeader = this.getAllowHeader();
        Boolean other$allowHeader = other.getAllowHeader();
        if (this$allowHeader == null ? other$allowHeader != null : !((Object)this$allowHeader).equals(other$allowHeader)) {
            return false;
        }
        Boolean this$allowFooter = this.getAllowFooter();
        Boolean other$allowFooter = other.getAllowFooter();
        if (this$allowFooter == null ? other$allowFooter != null : !((Object)this$allowFooter).equals(other$allowFooter)) {
            return false;
        }
        Boolean this$allowResetPosition = this.getAllowResetPosition();
        Boolean other$allowResetPosition = other.getAllowResetPosition();
        if (this$allowResetPosition == null ? other$allowResetPosition != null : !((Object)this$allowResetPosition).equals(other$allowResetPosition)) {
            return false;
        }
        Boolean this$allowRotateInherentPage = this.getAllowRotateInherentPage();
        Boolean other$allowRotateInherentPage = other.getAllowRotateInherentPage();
        if (this$allowRotateInherentPage == null ? other$allowRotateInherentPage != null : !((Object)this$allowRotateInherentPage).equals(other$allowRotateInherentPage)) {
            return false;
        }
        XEasyPdfComponent.ContentMode this$contentMode = this.getContentMode();
        XEasyPdfComponent.ContentMode other$contentMode = other.getContentMode();
        if (this$contentMode == null ? other$contentMode != null : !((Object)((Object)this$contentMode)).equals((Object)other$contentMode)) {
            return false;
        }
        String this$fontPath = this.getFontPath();
        String other$fontPath = other.getFontPath();
        if (this$fontPath == null ? other$fontPath != null : !this$fontPath.equals(other$fontPath)) {
            return false;
        }
        PDFont this$font = this.getFont();
        PDFont other$font = other.getFont();
        if (this$font == null ? other$font != null : !this$font.equals(other$font)) {
            return false;
        }
        XEasyPdfPageRectangle this$originalPageSize = this.getOriginalPageSize();
        XEasyPdfPageRectangle other$originalPageSize = other.getOriginalPageSize();
        if (this$originalPageSize == null ? other$originalPageSize != null : !this$originalPageSize.equals(other$originalPageSize)) {
            return false;
        }
        XEasyPdfPageRectangle this$currentPageSize = this.getCurrentPageSize();
        XEasyPdfPageRectangle other$currentPageSize = other.getCurrentPageSize();
        if (this$currentPageSize == null ? other$currentPageSize != null : !this$currentPageSize.equals(other$currentPageSize)) {
            return false;
        }
        List<PDPage> this$pageList = this.getPageList();
        List<PDPage> other$pageList = other.getPageList();
        if (this$pageList == null ? other$pageList != null : !((Object)this$pageList).equals(other$pageList)) {
            return false;
        }
        List<PDPage> this$newPageList = this.getNewPageList();
        List<PDPage> other$newPageList = other.getNewPageList();
        if (this$newPageList == null ? other$newPageList != null : !((Object)this$newPageList).equals(other$newPageList)) {
            return false;
        }
        XEasyPdfWatermark this$watermark = this.getWatermark();
        XEasyPdfWatermark other$watermark = other.getWatermark();
        if (this$watermark == null ? other$watermark != null : !this$watermark.equals(other$watermark)) {
            return false;
        }
        XEasyPdfHeader this$header = this.getHeader();
        XEasyPdfHeader other$header = other.getHeader();
        if (this$header == null ? other$header != null : !this$header.equals(other$header)) {
            return false;
        }
        XEasyPdfFooter this$footer = this.getFooter();
        XEasyPdfFooter other$footer = other.getFooter();
        if (this$footer == null ? other$footer != null : !this$footer.equals(other$footer)) {
            return false;
        }
        XEasyPdfImage this$backgroundImage = this.getBackgroundImage();
        XEasyPdfImage other$backgroundImage = other.getBackgroundImage();
        if (this$backgroundImage == null ? other$backgroundImage != null : !((Object)this$backgroundImage).equals(other$backgroundImage)) {
            return false;
        }
        Color this$backgroundColor = this.getBackgroundColor();
        Color other$backgroundColor = other.getBackgroundColor();
        return !(this$backgroundColor == null ? other$backgroundColor != null : !((Object)this$backgroundColor).equals(other$backgroundColor));
    }

    protected boolean canEqual(Object other) {
        return other instanceof XEasyPdfPageParam;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $isResetContext = this.getIsResetContext();
        result = result * 59 + ($isResetContext == null ? 43 : ((Object)$isResetContext).hashCode());
        Float $pageX = this.getPageX();
        result = result * 59 + ($pageX == null ? 43 : ((Object)$pageX).hashCode());
        Float $pageY = this.getPageY();
        result = result * 59 + ($pageY == null ? 43 : ((Object)$pageY).hashCode());
        Integer $rotation = this.getRotation();
        result = result * 59 + ($rotation == null ? 43 : ((Object)$rotation).hashCode());
        Float $marginLeft = this.getMarginLeft();
        result = result * 59 + ($marginLeft == null ? 43 : ((Object)$marginLeft).hashCode());
        Float $marginRight = this.getMarginRight();
        result = result * 59 + ($marginRight == null ? 43 : ((Object)$marginRight).hashCode());
        Float $marginTop = this.getMarginTop();
        result = result * 59 + ($marginTop == null ? 43 : ((Object)$marginTop).hashCode());
        Float $marginBottom = this.getMarginBottom();
        result = result * 59 + ($marginBottom == null ? 43 : ((Object)$marginBottom).hashCode());
        Boolean $allowWatermark = this.getAllowWatermark();
        result = result * 59 + ($allowWatermark == null ? 43 : ((Object)$allowWatermark).hashCode());
        Boolean $allowBackgroundImage = this.getAllowBackgroundImage();
        result = result * 59 + ($allowBackgroundImage == null ? 43 : ((Object)$allowBackgroundImage).hashCode());
        Boolean $allowBackgroundColor = this.getAllowBackgroundColor();
        result = result * 59 + ($allowBackgroundColor == null ? 43 : ((Object)$allowBackgroundColor).hashCode());
        Boolean $allowHeader = this.getAllowHeader();
        result = result * 59 + ($allowHeader == null ? 43 : ((Object)$allowHeader).hashCode());
        Boolean $allowFooter = this.getAllowFooter();
        result = result * 59 + ($allowFooter == null ? 43 : ((Object)$allowFooter).hashCode());
        Boolean $allowResetPosition = this.getAllowResetPosition();
        result = result * 59 + ($allowResetPosition == null ? 43 : ((Object)$allowResetPosition).hashCode());
        Boolean $allowRotateInherentPage = this.getAllowRotateInherentPage();
        result = result * 59 + ($allowRotateInherentPage == null ? 43 : ((Object)$allowRotateInherentPage).hashCode());
        XEasyPdfComponent.ContentMode $contentMode = this.getContentMode();
        result = result * 59 + ($contentMode == null ? 43 : ((Object)((Object)$contentMode)).hashCode());
        String $fontPath = this.getFontPath();
        result = result * 59 + ($fontPath == null ? 43 : $fontPath.hashCode());
        PDFont $font = this.getFont();
        result = result * 59 + ($font == null ? 43 : $font.hashCode());
        XEasyPdfPageRectangle $originalPageSize = this.getOriginalPageSize();
        result = result * 59 + ($originalPageSize == null ? 43 : $originalPageSize.hashCode());
        XEasyPdfPageRectangle $currentPageSize = this.getCurrentPageSize();
        result = result * 59 + ($currentPageSize == null ? 43 : $currentPageSize.hashCode());
        List<PDPage> $pageList = this.getPageList();
        result = result * 59 + ($pageList == null ? 43 : ((Object)$pageList).hashCode());
        List<PDPage> $newPageList = this.getNewPageList();
        result = result * 59 + ($newPageList == null ? 43 : ((Object)$newPageList).hashCode());
        XEasyPdfWatermark $watermark = this.getWatermark();
        result = result * 59 + ($watermark == null ? 43 : $watermark.hashCode());
        XEasyPdfHeader $header = this.getHeader();
        result = result * 59 + ($header == null ? 43 : $header.hashCode());
        XEasyPdfFooter $footer = this.getFooter();
        result = result * 59 + ($footer == null ? 43 : $footer.hashCode());
        XEasyPdfImage $backgroundImage = this.getBackgroundImage();
        result = result * 59 + ($backgroundImage == null ? 43 : ((Object)$backgroundImage).hashCode());
        Color $backgroundColor = this.getBackgroundColor();
        result = result * 59 + ($backgroundColor == null ? 43 : ((Object)$backgroundColor).hashCode());
        return result;
    }

    public String toString() {
        return "XEasyPdfPageParam(contentMode=" + (Object)((Object)this.getContentMode()) + ", isResetContext=" + this.getIsResetContext() + ", fontPath=" + this.getFontPath() + ", font=" + this.getFont() + ", pageX=" + this.getPageX() + ", pageY=" + this.getPageY() + ", originalPageSize=" + this.getOriginalPageSize() + ", currentPageSize=" + this.getCurrentPageSize() + ", modifyPageSize=" + this.getModifyPageSize() + ", rotation=" + this.getRotation() + ", pageList=" + this.getPageList() + ", newPageList=" + this.getNewPageList() + ", lastPage=" + this.getLastPage() + ", componentList=" + this.getComponentList() + ", marginLeft=" + this.getMarginLeft() + ", marginRight=" + this.getMarginRight() + ", marginTop=" + this.getMarginTop() + ", marginBottom=" + this.getMarginBottom() + ", watermark=" + this.getWatermark() + ", header=" + this.getHeader() + ", footer=" + this.getFooter() + ", backgroundImage=" + this.getBackgroundImage() + ", backgroundColor=" + this.getBackgroundColor() + ", allowWatermark=" + this.getAllowWatermark() + ", allowBackgroundImage=" + this.getAllowBackgroundImage() + ", allowBackgroundColor=" + this.getAllowBackgroundColor() + ", allowHeader=" + this.getAllowHeader() + ", allowFooter=" + this.getAllowFooter() + ", allowResetPosition=" + this.getAllowResetPosition() + ", allowRotateInherentPage=" + this.getAllowRotateInherentPage() + ")";
    }
}

