/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.doc;

import java.io.Serializable;
import org.apache.fontbox.util.BoundingBox;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.dromara.pdf.pdfbox.doc.XEasyPdfConstants;

public class XEasyPdfPageRectangle
implements Serializable {
    private static final long serialVersionUID = 3832021109368673135L;
    private static final Integer POINTS_PER_INCH = XEasyPdfConstants.POINTS_PER_INCH;
    private static final Float POINTS_PER_MM = XEasyPdfConstants.POINTS_PER_MM;
    private final Float width;
    private final Float height;
    private final PDRectangle size;
    public static final XEasyPdfPageRectangle A0 = new XEasyPdfPageRectangle(841.0f * POINTS_PER_MM.floatValue(), 1189.0f * POINTS_PER_MM.floatValue());
    public static final XEasyPdfPageRectangle A1 = new XEasyPdfPageRectangle(594.0f * POINTS_PER_MM.floatValue(), 841.0f * POINTS_PER_MM.floatValue());
    public static final XEasyPdfPageRectangle A2 = new XEasyPdfPageRectangle(420.0f * POINTS_PER_MM.floatValue(), 594.0f * POINTS_PER_MM.floatValue());
    public static final XEasyPdfPageRectangle A3 = new XEasyPdfPageRectangle(297.0f * POINTS_PER_MM.floatValue(), 420.0f * POINTS_PER_MM.floatValue());
    public static final XEasyPdfPageRectangle A4 = new XEasyPdfPageRectangle(210.0f * POINTS_PER_MM.floatValue(), 297.0f * POINTS_PER_MM.floatValue());
    public static final XEasyPdfPageRectangle A5 = new XEasyPdfPageRectangle(148.0f * POINTS_PER_MM.floatValue(), 210.0f * POINTS_PER_MM.floatValue());
    public static final XEasyPdfPageRectangle A6 = new XEasyPdfPageRectangle(105.0f * POINTS_PER_MM.floatValue(), 148.0f * POINTS_PER_MM.floatValue());
    public static final XEasyPdfPageRectangle A7 = new XEasyPdfPageRectangle(74.0f * POINTS_PER_MM.floatValue(), 105.0f * POINTS_PER_MM.floatValue());
    public static final XEasyPdfPageRectangle A8 = new XEasyPdfPageRectangle(52.0f * POINTS_PER_MM.floatValue(), 74.0f * POINTS_PER_MM.floatValue());
    public static final XEasyPdfPageRectangle B0 = new XEasyPdfPageRectangle(1030.0f * POINTS_PER_MM.floatValue(), 1456.0f * POINTS_PER_MM.floatValue());
    public static final XEasyPdfPageRectangle B1 = new XEasyPdfPageRectangle(728.0f * POINTS_PER_MM.floatValue(), 1030.0f * POINTS_PER_MM.floatValue());
    public static final XEasyPdfPageRectangle B2 = new XEasyPdfPageRectangle(515.0f * POINTS_PER_MM.floatValue(), 728.0f * POINTS_PER_MM.floatValue());
    public static final XEasyPdfPageRectangle B3 = new XEasyPdfPageRectangle(364.0f * POINTS_PER_MM.floatValue(), 515.0f * POINTS_PER_MM.floatValue());
    public static final XEasyPdfPageRectangle B4 = new XEasyPdfPageRectangle(257.0f * POINTS_PER_MM.floatValue(), 364.0f * POINTS_PER_MM.floatValue());
    public static final XEasyPdfPageRectangle B5 = new XEasyPdfPageRectangle(182.0f * POINTS_PER_MM.floatValue(), 257.0f * POINTS_PER_MM.floatValue());
    public static final XEasyPdfPageRectangle B6 = new XEasyPdfPageRectangle(128.0f * POINTS_PER_MM.floatValue(), 182.0f * POINTS_PER_MM.floatValue());
    public static final XEasyPdfPageRectangle B7 = new XEasyPdfPageRectangle(91.0f * POINTS_PER_MM.floatValue(), 128.0f * POINTS_PER_MM.floatValue());
    public static final XEasyPdfPageRectangle B8 = new XEasyPdfPageRectangle(64.0f * POINTS_PER_MM.floatValue(), 91.0f * POINTS_PER_MM.floatValue());

    XEasyPdfPageRectangle(PDRectangle size) {
        this.width = Float.valueOf(size.getWidth());
        this.height = Float.valueOf(size.getHeight());
        this.size = size;
    }

    private XEasyPdfPageRectangle(float width, float height) {
        this.width = Float.valueOf(Math.abs(width));
        this.height = Float.valueOf(Math.abs(height));
        this.size = new PDRectangle(this.width.floatValue(), this.height.floatValue());
    }

    private XEasyPdfPageRectangle(float leftX, float rightX, float bottomY, float topY) {
        this.width = Float.valueOf(Math.abs(rightX - leftX));
        this.height = Float.valueOf(Math.abs(topY - bottomY));
        this.size = new PDRectangle(new BoundingBox(leftX, bottomY, rightX, topY));
    }

    public static XEasyPdfPageRectangle create(float width, float height) {
        return new XEasyPdfPageRectangle(width, height);
    }

    public static XEasyPdfPageRectangle create(float leftX, float rightX, float bottomY, float topY) {
        return new XEasyPdfPageRectangle(leftX, rightX, bottomY, topY);
    }

    public XEasyPdfPageRectangle changeLandscape() {
        return new XEasyPdfPageRectangle(this.height.floatValue(), this.width.floatValue());
    }

    public static float getUnit() {
        return POINTS_PER_MM.floatValue();
    }

    public float getWidth() {
        return this.width.floatValue();
    }

    public float getHeight() {
        return this.height.floatValue();
    }

    public float getLeftX() {
        return this.size.getLowerLeftX();
    }

    public float getRightX() {
        return this.size.getUpperRightX();
    }

    public float getBottomY() {
        return this.size.getLowerLeftY();
    }

    public float getTopY() {
        return this.size.getUpperRightY();
    }

    public PDRectangle getSize() {
        return this.size;
    }
}

