/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.handler;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.fontbox.FontBoxFont;
import org.apache.fontbox.ttf.OpenTypeFont;
import org.apache.fontbox.ttf.TTFParser;
import org.apache.fontbox.ttf.TrueTypeFont;
import org.apache.pdfbox.pdmodel.font.CIDFontMapping;
import org.apache.pdfbox.pdmodel.font.FontMapper;
import org.apache.pdfbox.pdmodel.font.FontMappers;
import org.apache.pdfbox.pdmodel.font.FontMapping;
import org.apache.pdfbox.pdmodel.font.PDCIDSystemInfo;
import org.apache.pdfbox.pdmodel.font.PDFontDescriptor;
import org.dromara.pdf.pdfbox.doc.XEasyPdfDefaultFontStyle;
import org.dromara.pdf.pdfbox.handler.XEasyPdfHandler;

public class XEasyPdfFontMapperHandler
implements FontMapper {
    private static final ConcurrentHashMap<String, FontBoxFont> FONT_NAME_MAPPING = new ConcurrentHashMap(16);
    private static final ConcurrentHashMap<String, FontBoxFont> FONT_PATH_MAPPING = new ConcurrentHashMap(16);
    private static final String DEFAULT_FONT_NAME = XEasyPdfDefaultFontStyle.NORMAL.getName();
    private static final XEasyPdfFontMapperHandler INSTANCE = new XEasyPdfFontMapperHandler();

    private XEasyPdfFontMapperHandler() {
        this.init(XEasyPdfDefaultFontStyle.LIGHT, XEasyPdfDefaultFontStyle.NORMAL, XEasyPdfDefaultFontStyle.BOLD);
    }

    public static XEasyPdfFontMapperHandler getInstance() {
        return INSTANCE;
    }

    public void addFont(String fontPath, TrueTypeFont font) {
        FONT_NAME_MAPPING.putIfAbsent(font.getName(), (FontBoxFont)font);
        Optional.ofNullable(this.getFontAliases(font.getName())).ifPresent(name -> FONT_NAME_MAPPING.putIfAbsent((String)name, (FontBoxFont)font));
        FONT_PATH_MAPPING.putIfAbsent(fontPath, (FontBoxFont)font);
    }

    public FontBoxFont getFontByPath(String fontPath) {
        return FONT_PATH_MAPPING.get(fontPath);
    }

    public FontMapping<TrueTypeFont> getTrueTypeFont(String baseFont, PDFontDescriptor fontDescriptor) {
        TrueTypeFont ttf = (TrueTypeFont)this.findFont(baseFont);
        if (ttf != null) {
            return new FontMapping((FontBoxFont)ttf, false);
        }
        return new FontMapping((FontBoxFont)((TrueTypeFont)FONT_NAME_MAPPING.get(DEFAULT_FONT_NAME)), true);
    }

    public FontMapping<FontBoxFont> getFontBoxFont(String baseFont, PDFontDescriptor fontDescriptor) {
        FontBoxFont font = this.findFont(baseFont);
        if (font != null) {
            return new FontMapping(font, false);
        }
        return new FontMapping(FONT_NAME_MAPPING.get(DEFAULT_FONT_NAME), true);
    }

    public CIDFontMapping getCIDFont(String baseFont, PDFontDescriptor fontDescriptor, PDCIDSystemInfo cidSystemInfo) {
        FontBoxFont font = this.findFont(baseFont);
        if (font instanceof OpenTypeFont) {
            return new CIDFontMapping((OpenTypeFont)font, null, false);
        }
        if (font instanceof TrueTypeFont) {
            return new CIDFontMapping(null, font, false);
        }
        return new CIDFontMapping(null, FONT_NAME_MAPPING.get(DEFAULT_FONT_NAME), true);
    }

    private void init(XEasyPdfDefaultFontStyle ... styles) {
        for (XEasyPdfDefaultFontStyle style : styles) {
            try (BufferedInputStream inputStream = new BufferedInputStream(Objects.requireNonNull(Thread.currentThread().getContextClassLoader().getResourceAsStream(style.getPath())));){
                TrueTypeFont font = new TTFParser(true, true).parse((InputStream)inputStream);
                this.addFont(style.getPath(), font);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.initFontMapper();
    }

    private void initFontMapper() {
        String fontMappingPolicy = System.getProperty(XEasyPdfHandler.FontMappingPolicy.key(), XEasyPdfHandler.FontMappingPolicy.DEFAULT.name());
        if (fontMappingPolicy.equals(XEasyPdfHandler.FontMappingPolicy.DEFAULT.name())) {
            FontMappers.set((FontMapper)this);
        }
    }

    private FontBoxFont findFont(String postScriptName) {
        if (postScriptName == null) {
            return null;
        }
        FontBoxFont info = this.getFont(postScriptName);
        if (info != null) {
            return info;
        }
        info = this.getFont(postScriptName.replace("-", ""));
        if (info != null) {
            return info;
        }
        info = this.getFont(postScriptName.replace(',', '-'));
        if (info != null) {
            return info;
        }
        info = this.getFont(postScriptName + "-Regular");
        if (info != null) {
            return info;
        }
        String finalName = postScriptName.replaceAll(" ", "");
        info = this.getFont(finalName);
        if (info != null) {
            return info;
        }
        String mappedName = Standard14Fonts.getMappedName(finalName);
        if (mappedName != null) {
            return FONT_NAME_MAPPING.get(mappedName);
        }
        return null;
    }

    private String getFontAliases(String postScriptName) {
        if (postScriptName == null) {
            return null;
        }
        return Standard14Fonts.getMappedName(postScriptName.replaceAll(" ", ""));
    }

    private FontBoxFont getFont(String postScriptName) {
        if (postScriptName.contains("+")) {
            postScriptName = postScriptName.substring(postScriptName.indexOf(43) + 1);
        }
        return FONT_NAME_MAPPING.get(postScriptName);
    }

    private static class Standard14Fonts {
        private static final Map<String, String> ALIASES = new HashMap<String, String>(100);

        private Standard14Fonts() {
        }

        private static void mapName(String baseName) {
            ALIASES.put(baseName, baseName);
        }

        private static void mapName(String alias, String baseName) {
            ALIASES.put(alias, baseName);
        }

        public static String getMappedName(String fontName) {
            return ALIASES.get(fontName);
        }

        static {
            Standard14Fonts.mapName("Courier-Bold");
            Standard14Fonts.mapName("Courier-BoldOblique");
            Standard14Fonts.mapName("Courier");
            Standard14Fonts.mapName("Courier-Oblique");
            Standard14Fonts.mapName("Helvetica");
            Standard14Fonts.mapName("Helvetica-Bold");
            Standard14Fonts.mapName("Helvetica-BoldOblique");
            Standard14Fonts.mapName("Helvetica-Oblique");
            Standard14Fonts.mapName("Symbol");
            Standard14Fonts.mapName("Times-Bold");
            Standard14Fonts.mapName("Times-BoldItalic");
            Standard14Fonts.mapName("Times-Italic");
            Standard14Fonts.mapName("Times-Roman");
            Standard14Fonts.mapName("ZapfDingbats");
            Standard14Fonts.mapName("CourierCourierNew", "Courier");
            Standard14Fonts.mapName("CourierNew", "Courier");
            Standard14Fonts.mapName("CourierNewPSMT", "Courier");
            Standard14Fonts.mapName("LiberationMono", "Courier");
            Standard14Fonts.mapName("NimbusMonL-Regu", "Courier");
            Standard14Fonts.mapName("CourierNew,Italic", "Courier-Oblique");
            Standard14Fonts.mapName("CourierNewPS-ItalicMT", "Courier-Oblique");
            Standard14Fonts.mapName("CourierNew-Italic", "Courier-Oblique");
            Standard14Fonts.mapName("LiberationMono-Italic", "Courier-Oblique");
            Standard14Fonts.mapName("NimbusMonL-ReguObli", "Courier-Oblique");
            Standard14Fonts.mapName("CourierNew,Bold", "Courier-Bold");
            Standard14Fonts.mapName("CourierNewPS-BoldMT", "Courier-Bold");
            Standard14Fonts.mapName("CourierNew-Bold", "Courier-Bold");
            Standard14Fonts.mapName("LiberationMono-Bold", "Courier-Bold");
            Standard14Fonts.mapName("NimbusMonL-Bold", "Courier-Bold");
            Standard14Fonts.mapName("CourierNew,BoldItalic", "Courier-BoldOblique");
            Standard14Fonts.mapName("CourierNewPS-BoldItalicMT", "Courier-BoldOblique");
            Standard14Fonts.mapName("LiberationMono-BoldItalic", "Courier-BoldOblique");
            Standard14Fonts.mapName("NimbusMonL-BoldObli", "Courier-BoldOblique");
            Standard14Fonts.mapName("Arial", "Helvetica");
            Standard14Fonts.mapName("ArialMT", "Helvetica");
            Standard14Fonts.mapName("LiberationSans", "Helvetica");
            Standard14Fonts.mapName("NimbusSanL-Regu", "Helvetica");
            Standard14Fonts.mapName("Arial,Italic", "Helvetica-Oblique");
            Standard14Fonts.mapName("Arial-ItalicMT", "Helvetica-Oblique");
            Standard14Fonts.mapName("Arial-Italic", "Helvetica-Oblique");
            Standard14Fonts.mapName("Helvetica-Italic", "Helvetica-Oblique");
            Standard14Fonts.mapName("LiberationSans-Italic", "Helvetica-Oblique");
            Standard14Fonts.mapName("NimbusSanL-ReguItal", "Helvetica-Oblique");
            Standard14Fonts.mapName("Arial,Bold", "Helvetica-Bold");
            Standard14Fonts.mapName("Arial-BoldMT", "Helvetica-Bold");
            Standard14Fonts.mapName("Arial-Bold", "Helvetica-Bold");
            Standard14Fonts.mapName("LiberationSans-Bold", "Helvetica-Bold");
            Standard14Fonts.mapName("NimbusSanL-Bold", "Helvetica-Bold");
            Standard14Fonts.mapName("Arial,BoldItalic", "Helvetica-BoldOblique");
            Standard14Fonts.mapName("Arial-BoldItalicMT", "Helvetica-BoldOblique");
            Standard14Fonts.mapName("Helvetica-BoldItalic", "Helvetica-BoldOblique");
            Standard14Fonts.mapName("LiberationSans-BoldItalic", "Helvetica-BoldOblique");
            Standard14Fonts.mapName("NimbusSanL-BoldItal", "Helvetica-BoldOblique");
            Standard14Fonts.mapName("TimesNewRoman", "Times-Roman");
            Standard14Fonts.mapName("TimesNewRomanPSMT", "Times-Roman");
            Standard14Fonts.mapName("TimesNewRoman", "Times-Roman");
            Standard14Fonts.mapName("TimesNewRomanPS", "Times-Roman");
            Standard14Fonts.mapName("LiberationSerif", "Times-Roman");
            Standard14Fonts.mapName("NimbusRomNo9L-Regu", "Times-Roman");
            Standard14Fonts.mapName("TimesNewRoman,Italic", "Times-Italic");
            Standard14Fonts.mapName("TimesNewRomanPS-ItalicMT", "Times-Italic");
            Standard14Fonts.mapName("TimesNewRomanPS-Italic", "Times-Italic");
            Standard14Fonts.mapName("TimesNewRoman-Italic", "Times-Italic");
            Standard14Fonts.mapName("LiberationSerif-Italic", "Times-Italic");
            Standard14Fonts.mapName("NimbusRomNo9L-ReguItal", "Times-Italic");
            Standard14Fonts.mapName("TimesNewRoman,Bold", "Times-Bold");
            Standard14Fonts.mapName("TimesNewRomanPS-BoldMT", "Times-Bold");
            Standard14Fonts.mapName("TimesNewRomanPS-Bold", "Times-Bold");
            Standard14Fonts.mapName("TimesNewRoman-Bold", "Times-Bold");
            Standard14Fonts.mapName("LiberationSerif-Bold", "Times-Bold");
            Standard14Fonts.mapName("NimbusRomNo9L-Medi", "Times-Bold");
            Standard14Fonts.mapName("TimesNewRoman,BoldItalic", "Times-BoldItalic");
            Standard14Fonts.mapName("TimesNewRomanPS-BoldItalicMT", "Times-BoldItalic");
            Standard14Fonts.mapName("TimesNewRomanPS-BoldItalic", "Times-BoldItalic");
            Standard14Fonts.mapName("TimesNewRoman-BoldItalic", "Times-BoldItalic");
            Standard14Fonts.mapName("LiberationSerif-BoldItalic", "Times-BoldItalic");
            Standard14Fonts.mapName("NimbusRomNo9L-MediItal", "Times-BoldItalic");
            Standard14Fonts.mapName("Symbol,Italic", "Symbol");
            Standard14Fonts.mapName("Symbol,Bold", "Symbol");
            Standard14Fonts.mapName("Symbol,BoldItalic", "Symbol");
            Standard14Fonts.mapName("Symbol", "Symbol");
            Standard14Fonts.mapName("SymbolMT", "Symbol");
            Standard14Fonts.mapName("StandardSymL", "Symbol");
            Standard14Fonts.mapName("ZapfDingbatsITCbyBT-Regular", "ZapfDingbats");
            Standard14Fonts.mapName("ZapfDingbatsITC", "ZapfDingbats");
            Standard14Fonts.mapName("Dingbats", "ZapfDingbats");
            Standard14Fonts.mapName("MS-Gothic", "ZapfDingbats");
            Standard14Fonts.mapName("Times", "Times-Roman");
            Standard14Fonts.mapName("Times,Italic", "Times-Italic");
            Standard14Fonts.mapName("Times,Bold", "Times-Bold");
            Standard14Fonts.mapName("Times,BoldItalic", "Times-BoldItalic");
            Standard14Fonts.mapName("ArialMT", "Helvetica");
            Standard14Fonts.mapName("Arial-ItalicMT", "Helvetica-Oblique");
            Standard14Fonts.mapName("Arial-BoldMT", "Helvetica-Bold");
            Standard14Fonts.mapName("Arial-BoldItalicMT", "Helvetica-BoldOblique");
        }
    }
}

