/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.pdfbox.pdmodel.font.PDFont;

public class XEasyPdfTextUtil {
    public static String splitText(String text, float lineWidth, PDFont font, float fontSize, float characterSpacing) {
        if (XEasyPdfTextUtil.isBlank(text) || lineWidth - fontSize < 0.0f) {
            return null;
        }
        int fontCount = Math.max(1, (int)(lineWidth / (fontSize + characterSpacing)));
        int beginIndex = 0;
        int len = text.length();
        for (int i = fontCount; i <= len; ++i) {
            String tempText = text.substring(beginIndex, i);
            float lineRealWidth = XEasyPdfTextUtil.getTextRealWidth(tempText, font, fontSize, characterSpacing);
            if (!(lineRealWidth > lineWidth)) continue;
            return text.substring(beginIndex, i - 1);
        }
        return text;
    }

    public static List<String> splitLines(String text, float lineWidth, PDFont font, float fontSize, float characterSpacing) {
        if (XEasyPdfTextUtil.isBlank(text) || lineWidth - fontSize < 0.0f) {
            return new ArrayList<String>(0);
        }
        ArrayList<String> lineList = new ArrayList<String>(200);
        int fontCount = Math.max(1, (int)(lineWidth / (fontSize + characterSpacing)));
        int beginIndex = 0;
        int len = text.length();
        for (int i = fontCount; i <= len; ++i) {
            String tempText = text.substring(beginIndex, i);
            float lineRealWidth = XEasyPdfTextUtil.getTextRealWidth(tempText, font, fontSize, characterSpacing);
            if (!(lineRealWidth > lineWidth)) continue;
            lineList.add(text.substring(beginIndex, i - 1));
            beginIndex = i - 1;
            i = i + fontCount - 1;
            if (i < len) continue;
            lineList.add(text.substring(beginIndex));
        }
        if (beginIndex + fontCount < text.length() || lineList.isEmpty()) {
            lineList.add(text.substring(beginIndex));
        }
        return lineList;
    }

    public static float getTextRealWidth(String text, PDFont font, float fontSize, float characterSpacing) {
        return fontSize * font.getStringWidth(text) / 1000.0f + (float)(text.length() - 1) * characterSpacing;
    }

    public static String escapeForRegex(String text) {
        char[] charArray;
        if (XEasyPdfTextUtil.isBlank(text)) {
            return "";
        }
        char[] escapeChars = new char[]{'$', '(', ')', '*', '+', '.', '[', ']', '?', '\\', '^', '{', '}', '|'};
        StringBuilder builder = new StringBuilder();
        for (char c : charArray = text.toCharArray()) {
            for (char escapeChar : escapeChars) {
                if (escapeChar != c) continue;
                builder.append('\\');
                break;
            }
            builder.append(c);
        }
        return builder.toString();
    }

    public static String filterAll(String text) {
        return text.replaceAll("[\n\r\t\b\f]", "");
    }

    public static String replaceAll(String text, Map<String, String> replaceMap) {
        if (XEasyPdfTextUtil.isBlank(text)) {
            return "";
        }
        if (replaceMap == null || replaceMap.isEmpty()) {
            return text;
        }
        String temp = text;
        Set<Map.Entry<String, String>> entrySet = replaceMap.entrySet();
        for (Map.Entry<String, String> entry : entrySet) {
            temp = temp.replaceAll(entry.getKey(), entry.getValue());
        }
        return temp;
    }

    public static boolean isBlank(String text) {
        return !XEasyPdfTextUtil.isNotBlank(text);
    }

    public static boolean isNotBlank(String text) {
        return text != null && text.trim().length() > 0;
    }

    public static String join(CharSequence delimiter, String ... texts) {
        if (texts == null || texts.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (String text : texts) {
            builder.append(text);
            builder.append(delimiter);
        }
        if (delimiter != null && delimiter.length() > 0) {
            return builder.substring(0, builder.length() - 1);
        }
        return builder.toString();
    }
}

