/*
 * Decompiled with CFR 0.152.
 */
package org.drools.lang.descr;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.lang.descr.AndDescr;
import org.drools.lang.descr.AttributeDescr;
import org.drools.lang.descr.BaseDescr;
import org.drools.rule.Dialectable;
import org.drools.rule.Namespaceable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleDescr
extends BaseDescr
implements Dialectable,
Namespaceable {
    private static final long serialVersionUID = 400L;
    private String namespace;
    private String name;
    private String parentName;
    private String dialect;
    private String documentation;
    private Map<String, String> metaAttributes;
    private AndDescr lhs;
    private Object consequence;
    private int consequenceLine;
    private int consequencePattern;
    private int offset;
    private List<AttributeDescr> attributes = Collections.EMPTY_LIST;
    private String salience;
    private String className;
    private String url;

    public RuleDescr() {
    }

    public RuleDescr(String name) {
        this(name, "");
    }

    public RuleDescr(String ruleName, String documentation) {
        this.name = ruleName;
        this.documentation = documentation;
        this.metaAttributes = new HashMap<String, String>();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.namespace = (String)in.readObject();
        this.name = (String)in.readObject();
        this.parentName = (String)in.readObject();
        this.dialect = (String)in.readObject();
        this.documentation = (String)in.readObject();
        this.consequence = in.readObject();
        this.lhs = (AndDescr)in.readObject();
        this.consequenceLine = in.readInt();
        this.consequencePattern = in.readInt();
        this.offset = in.readInt();
        this.attributes = (List)in.readObject();
        this.salience = (String)in.readObject();
        this.className = (String)in.readObject();
        this.url = (String)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.namespace);
        out.writeObject(this.name);
        out.writeObject(this.parentName);
        out.writeObject(this.dialect);
        out.writeObject(this.documentation);
        out.writeObject(this.consequence);
        out.writeObject(this.lhs);
        out.writeInt(this.consequenceLine);
        out.writeInt(this.consequencePattern);
        out.writeInt(this.offset);
        out.writeObject(this.attributes);
        out.writeObject(this.salience);
        out.writeObject(this.className);
        out.writeObject(this.url);
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getName() {
        return this.name;
    }

    public String getDialect() {
        return this.dialect;
    }

    public void setDialect(String dialect) {
        this.dialect = dialect;
    }

    public String getSalience() {
        return this.salience;
    }

    public void setSalience(String salience) {
        this.salience = salience;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public void addMetaAttribute(String attr, String value) {
        if (this.metaAttributes == null) {
            this.metaAttributes = new HashMap<String, String>();
        }
        this.metaAttributes.put(attr, value);
    }

    public String getMetaAttribute(String attr) {
        return this.metaAttributes != null ? this.metaAttributes.get(attr) : null;
    }

    public Map<String, String> getMetaAttributes() {
        return this.metaAttributes != null ? this.metaAttributes : Collections.EMPTY_MAP;
    }

    public List<AttributeDescr> getAttributes() {
        return this.attributes;
    }

    public void addAttribute(AttributeDescr attribute) {
        if (attribute != null) {
            if (this.attributes == Collections.EMPTY_LIST) {
                this.attributes = new ArrayList<AttributeDescr>();
            }
            if ("dialect".equals(attribute.getName())) {
                this.dialect = attribute.getValue();
            }
            this.attributes.add(attribute);
        }
    }

    public void setAttributes(List<AttributeDescr> attributes) {
        this.attributes = new ArrayList<AttributeDescr>(attributes);
    }

    public AndDescr getLhs() {
        return this.lhs;
    }

    public void setLhs(AndDescr lhs) {
        this.lhs = lhs;
    }

    public Object getConsequence() {
        return this.consequence;
    }

    public void setConsequence(Object consequence) {
        this.consequence = consequence;
    }

    public void setConsequenceLocation(int line, int pattern) {
        this.consequenceLine = line;
        this.consequencePattern = pattern;
    }

    public void setConsequenceOffset(int offset) {
        this.offset = offset;
    }

    public int getConsequenceOffset() {
        return this.offset;
    }

    public int getConsequenceLine() {
        return this.consequenceLine;
    }

    public int getConsequencePattern() {
        return this.consequencePattern;
    }

    public String getEnabled() {
        String enabled = "true";
        for (AttributeDescr attr : this.attributes) {
            if (!"enabled".equals(attr.getName())) continue;
            enabled = attr.getValue();
            break;
        }
        return enabled;
    }

    public void setParentName(String parentName) {
        this.parentName = parentName;
    }

    public String getParentName() {
        return this.parentName;
    }

    public String toString() {
        return "[Rule name='" + this.name + "']";
    }
}

