/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.builder.dialect.java;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.drools.rule.builder.dialect.java.JavaAnalysisResult;
import org.drools.rule.builder.dialect.java.parser.JavaLexer;
import org.drools.rule.builder.dialect.java.parser.JavaLocalDeclarationDescr;
import org.drools.rule.builder.dialect.java.parser.JavaParser;

public class JavaExprAnalyzer {
    public JavaAnalysisResult analyzeExpression(String expr, Set[] availableIdentifiers) throws RecognitionException {
        ANTLRStringStream charStream = new ANTLRStringStream(expr);
        JavaLexer lexer = new JavaLexer((CharStream)charStream);
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
        JavaParser parser = new JavaParser((TokenStream)tokenStream);
        parser.conditionalOrExpression();
        JavaAnalysisResult result = new JavaAnalysisResult();
        result.setIdentifiers(parser.getIdentifiers());
        return this.analyze(result, availableIdentifiers);
    }

    public JavaAnalysisResult analyzeBlock(String expr, Set[] availableIdentifiers) throws RecognitionException {
        ANTLRStringStream charStream = new ANTLRStringStream("{" + expr + "}");
        JavaLexer lexer = new JavaLexer((CharStream)charStream);
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
        JavaParser parser = new JavaParser((TokenStream)tokenStream);
        parser.block();
        JavaAnalysisResult result = new JavaAnalysisResult();
        result.setIdentifiers(parser.getIdentifiers());
        result.setLocalVariables(new HashMap());
        for (JavaLocalDeclarationDescr descr : parser.getLocalDeclarations()) {
            for (JavaLocalDeclarationDescr.IdentifierDescr ident : descr.getIdentifiers()) {
                result.addLocalVariable(ident.getIdentifier(), descr);
            }
        }
        result.setModifyBlocks(parser.getModifyBlocks());
        return this.analyze(result, availableIdentifiers);
    }

    private JavaAnalysisResult analyze(JavaAnalysisResult result, Set[] availableIdentifiers) throws RecognitionException {
        int i;
        List identifiers = result.getIdentifiers();
        HashSet notBound = new HashSet(identifiers);
        List[] used = new List[availableIdentifiers.length];
        int length = used.length;
        for (i = 0; i < length; ++i) {
            used[i] = new ArrayList();
        }
        length = availableIdentifiers.length;
        for (i = 0; i < length; ++i) {
            Set set = availableIdentifiers[i];
            for (String eachDecl : set) {
                if (!identifiers.contains(eachDecl)) continue;
                used[i].add(eachDecl);
                notBound.remove(eachDecl);
            }
        }
        result.setBoundIdentifiers(used);
        result.setNotBoundedIdentifiers(new ArrayList(notBound));
        return result;
    }
}

