/*
 * Decompiled with CFR 0.152.
 */
package org.drools.lang.descr;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.drools.lang.descr.BaseDescr;
import org.drools.lang.descr.TypeFieldDescr;
import org.drools.rule.Namespaceable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeDeclarationDescr
extends BaseDescr
implements Namespaceable {
    private static final long serialVersionUID = 510L;
    private String namespace;
    private String typeName;
    private Map<String, Map<String, String>> metaAttributes;
    private Map<String, TypeFieldDescr> fields;
    private String superTypeName;
    private Vector<String> interfaceNames;

    public TypeDeclarationDescr() {
        this(null);
    }

    public TypeDeclarationDescr(String typeName) {
        this.typeName = typeName;
        this.metaAttributes = new HashMap<String, Map<String, String>>();
        this.interfaceNames = new Vector();
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public void addMetaAttribute(String attr, Map<String, String> values) {
        if (this.metaAttributes == null) {
            this.metaAttributes = new HashMap<String, Map<String, String>>();
        }
        this.metaAttributes.put(attr, values);
    }

    public void addMetaAttribute(String attr, String value) {
        if (this.metaAttributes == null) {
            this.metaAttributes = new HashMap<String, Map<String, String>>();
        }
        Hashtable<String, String> attrMap = new Hashtable<String, String>();
        attrMap.put(value, value);
        this.metaAttributes.put(attr, attrMap);
    }

    public String getMetaAttribute(String attr) {
        if (this.metaAttributes == null) {
            return null;
        }
        Map<String, String> meta = this.metaAttributes.get(attr);
        return meta == null ? null : meta.keySet().iterator().next();
    }

    public Set<String> getMetaAttributes(String attr) {
        if (this.metaAttributes == null) {
            return null;
        }
        Map<String, String> meta = this.metaAttributes.get(attr);
        return meta == null ? null : meta.keySet();
    }

    public String getMetaAttributeValue(String attr, String key) {
        if (this.metaAttributes == null) {
            return null;
        }
        Map<String, String> meta = this.metaAttributes.get(attr);
        return meta == null ? null : meta.get(key);
    }

    public Map<String, Map<String, String>> getMetaAttributes() {
        return this.metaAttributes != null ? this.metaAttributes : Collections.EMPTY_MAP;
    }

    public Map<String, TypeFieldDescr> getFields() {
        return this.fields != null ? this.fields : Collections.EMPTY_MAP;
    }

    public void setFields(Map<String, TypeFieldDescr> fields) {
        this.fields = fields;
    }

    public void addField(TypeFieldDescr field) {
        if (this.fields == null) {
            this.fields = new LinkedHashMap<String, TypeFieldDescr>();
        }
        this.fields.put(field.getFieldName(), field);
    }

    public String toString() {
        return "TypeDeclaration[ " + this.getTypeName() + " ]";
    }

    public String getSuperTypeName() {
        return this.superTypeName;
    }

    public void setSuperTypeName(String type) {
        this.superTypeName = type;
    }

    public Collection<String> getInterfaceNames() {
        return this.interfaceNames;
    }

    public void setInterfaceNames(Collection<String> interfaces) {
        this.interfaceNames.addAll(this.interfaceNames);
    }
}

