/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.kproject.xml;

import java.io.InputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.drools.compiler.kproject.ReleaseIdImpl;
import org.drools.compiler.kproject.xml.PomModel;
import org.kie.api.builder.ReleaseId;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class MinimalPomParser
extends DefaultHandler {
    private int depth;
    private PomModel model = new PomModel();
    private StringBuilder characters;
    private String pomGroupId;
    private String pomArtifactId;
    private String pomVersion;
    private String currentGroupId;
    private String currentArtifactId;
    private String currentVersion;
    private String currentScope;

    private MinimalPomParser() {
    }

    static PomModel parse(String path, InputStream is) {
        MinimalPomParser handler = new MinimalPomParser();
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(false);
            factory.setNamespaceAware(false);
            SAXParser parser = factory.newSAXParser();
            parser.parse(is, (DefaultHandler)handler);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to parse File '" + path + "'", e);
        }
        return handler.getPomModel();
    }

    public PomModel getPomModel() {
        return this.model;
    }

    @Override
    public void startElement(String uri, String localName, String qname, Attributes attrs) throws SAXException {
        if ("groupId".equals(qname) || "artifactId".equals(qname) || "version".equals(qname)) {
            this.characters = new StringBuilder();
        }
        ++this.depth;
    }

    @Override
    public void endElement(String uri, String localName, String qname) throws SAXException {
        if ("project".equals(qname)) {
            ReleaseId parentReleaseId = this.model.getParentReleaseId();
            this.model.setReleaseId(new ReleaseIdImpl(this.pomGroupId != null ? this.pomGroupId : parentReleaseId.getGroupId(), this.pomArtifactId, this.pomVersion != null ? this.pomVersion : parentReleaseId.getVersion()));
        } else if ("parent".equals(qname)) {
            if (this.currentGroupId != null && this.currentArtifactId != null && this.currentVersion != null) {
                this.model.setParentReleaseId(new ReleaseIdImpl(this.currentGroupId, this.currentArtifactId, this.currentVersion));
            }
            this.currentGroupId = null;
            this.currentArtifactId = null;
            this.currentVersion = null;
        } else if ("dependency".equals(qname)) {
            if (!"provided".equals(this.currentScope) && !"test".equals(this.currentScope) && this.currentGroupId != null && this.currentArtifactId != null && this.currentVersion != null) {
                this.model.addDependency(new ReleaseIdImpl(this.currentGroupId, this.currentArtifactId, this.currentVersion));
            }
            this.currentGroupId = null;
            this.currentArtifactId = null;
            this.currentVersion = null;
            this.currentScope = null;
        } else {
            String text;
            String string = text = this.characters != null ? this.characters.toString() : null;
            if (text != null) {
                if ("groupId".equals(qname)) {
                    if (this.depth == 2) {
                        this.pomGroupId = text;
                    } else {
                        this.currentGroupId = text;
                    }
                } else if ("artifactId".equals(qname)) {
                    if (this.depth == 2) {
                        this.pomArtifactId = text;
                    } else {
                        this.currentArtifactId = text;
                    }
                } else if ("version".equals(qname)) {
                    if (this.depth == 2) {
                        this.pomVersion = text;
                    } else {
                        this.currentVersion = text;
                    }
                } else if ("scope".equals(qname)) {
                    this.currentScope = text;
                }
            }
        }
        this.characters = null;
        --this.depth;
    }

    @Override
    public void characters(char[] chars, int start, int len) {
        if (this.characters != null) {
            this.characters.append(chars, start, len);
        }
    }
}

