/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.lang.descr;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.drools.compiler.compiler.PackageBuilder;
import org.drools.compiler.lang.descr.AttributeDescr;
import org.drools.compiler.lang.descr.EntryPointDeclarationDescr;
import org.drools.compiler.lang.descr.FunctionDescr;
import org.drools.compiler.lang.descr.FunctionImportDescr;
import org.drools.compiler.lang.descr.GlobalDescr;
import org.drools.compiler.lang.descr.ImportDescr;
import org.drools.compiler.lang.descr.PackageDescr;
import org.drools.compiler.lang.descr.RuleDescr;
import org.drools.compiler.lang.descr.TypeDeclarationDescr;
import org.drools.compiler.lang.descr.WindowDeclarationDescr;
import org.kie.api.io.Resource;

public class CompositePackageDescr
extends PackageDescr {
    private CompositeAssetFilter filter;

    public CompositePackageDescr() {
    }

    public CompositePackageDescr(Resource resource, PackageDescr packageDescr) {
        super(packageDescr.getNamespace(), packageDescr.getDocumentation());
        this.internalAdd(resource, packageDescr);
    }

    public void addPackageDescr(Resource resource, PackageDescr packageDescr) {
        if (!this.getNamespace().equals(packageDescr.getNamespace())) {
            throw new RuntimeException("Composing PackageDescr in different namespaces");
        }
        this.internalAdd(resource, packageDescr);
    }

    private void internalAdd(Resource resource, PackageDescr packageDescr) {
        List<ImportDescr> currentImports = this.getImports();
        for (ImportDescr descr : packageDescr.getImports()) {
            if (currentImports.contains(descr)) continue;
            this.addImport(descr);
            descr.setResource(resource);
        }
        List<FunctionImportDescr> currentFunctionImports = this.getFunctionImports();
        for (FunctionImportDescr descr : packageDescr.getFunctionImports()) {
            if (currentFunctionImports.contains(descr)) continue;
            this.addFunctionImport(descr);
            descr.setResource(resource);
        }
        List<AttributeDescr> currentAttributeDescrs = this.getAttributes();
        for (AttributeDescr descr : packageDescr.getAttributes()) {
            if (currentAttributeDescrs.contains(descr)) continue;
            this.addAttribute(descr);
            descr.setResource(resource);
        }
        List<GlobalDescr> currentGlobalDescrs = this.getGlobals();
        for (GlobalDescr descr : packageDescr.getGlobals()) {
            if (currentGlobalDescrs.contains(descr)) continue;
            this.addGlobal(descr);
            descr.setResource(resource);
        }
        List<FunctionDescr> currentFunctionDescrs = this.getFunctions();
        for (FunctionDescr descr : packageDescr.getFunctions()) {
            if (currentFunctionDescrs.contains(descr)) continue;
            this.addFunction(descr);
            descr.setResource(resource);
        }
        List<RuleDescr> ruleDescrs = this.getRules();
        for (RuleDescr descr : packageDescr.getRules()) {
            if (ruleDescrs.contains(descr)) continue;
            this.addRule(descr);
            descr.setResource(resource);
        }
        List<TypeDeclarationDescr> typeDeclarationDescrs = this.getTypeDeclarations();
        for (TypeDeclarationDescr descr : packageDescr.getTypeDeclarations()) {
            if (typeDeclarationDescrs.contains(descr)) continue;
            this.addTypeDeclaration(descr);
            descr.setResource(resource);
        }
        Set<EntryPointDeclarationDescr> entryPointDeclarationDescrs = this.getEntryPointDeclarations();
        for (EntryPointDeclarationDescr descr : packageDescr.getEntryPointDeclarations()) {
            if (entryPointDeclarationDescrs.contains(descr)) continue;
            this.addEntryPointDeclaration(descr);
            descr.setResource(resource);
        }
        Set<WindowDeclarationDescr> windowDeclarationDescrs = this.getWindowDeclarations();
        for (WindowDeclarationDescr descr : packageDescr.getWindowDeclarations()) {
            if (windowDeclarationDescrs.contains(descr)) continue;
            this.addWindowDeclaration(descr);
            descr.setResource(resource);
        }
    }

    public CompositeAssetFilter getFilter() {
        return this.filter;
    }

    public void addFilter(PackageBuilder.AssetFilter f) {
        if (f != null) {
            if (this.filter == null) {
                this.filter = new CompositeAssetFilter();
            }
            this.filter.filters.add(f);
        }
    }

    public static class CompositeAssetFilter
    implements PackageBuilder.AssetFilter {
        public List<PackageBuilder.AssetFilter> filters = new ArrayList<PackageBuilder.AssetFilter>();

        @Override
        public PackageBuilder.AssetFilter.Action accept(String pkgName, String assetName) {
            for (PackageBuilder.AssetFilter filter : this.filters) {
                PackageBuilder.AssetFilter.Action result = filter.accept(pkgName, assetName);
                if (PackageBuilder.AssetFilter.Action.DO_NOTHING.equals((Object)result)) continue;
                return result;
            }
            return PackageBuilder.AssetFilter.Action.DO_NOTHING;
        }
    }
}

