/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.rule.builder.dialect.mvel;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import org.drools.compiler.compiler.AnalysisResult;
import org.drools.compiler.compiler.BoundIdentifiers;
import org.drools.compiler.compiler.DescrBuildError;
import org.drools.compiler.lang.descr.BaseDescr;
import org.drools.compiler.lang.descr.FromDescr;
import org.drools.compiler.lang.descr.MVELExprDescr;
import org.drools.compiler.rule.builder.FromBuilder;
import org.drools.compiler.rule.builder.RuleBuildContext;
import org.drools.compiler.rule.builder.dialect.DialectUtil;
import org.drools.compiler.rule.builder.dialect.mvel.MVELDialect;
import org.drools.core.base.dataproviders.MVELDataProvider;
import org.drools.core.base.mvel.MVELCompilationUnit;
import org.drools.core.base.mvel.MVELCompileable;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.From;
import org.drools.core.rule.MVELDialectRuntimeData;
import org.drools.core.rule.Pattern;
import org.drools.core.rule.RuleConditionElement;
import org.drools.core.spi.DataProvider;
import org.drools.core.spi.DeclarationScopeResolver;
import org.drools.core.spi.KnowledgeHelper;
import org.drools.core.spi.Wireable;

public class MVELFromBuilder
implements FromBuilder {
    @Override
    public RuleConditionElement build(RuleBuildContext context, BaseDescr descr) {
        return this.build(context, descr, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RuleConditionElement build(RuleBuildContext context, BaseDescr descr, Pattern prefixPattern) {
        MVELDialect dialect = (MVELDialect)context.getDialect("mvel");
        boolean typeSafe = context.isTypesafe();
        if (!dialect.isStrictMode()) {
            context.setTypesafe(false);
        }
        FromDescr fromDescr = (FromDescr)descr;
        MVELExprDescr expr = (MVELExprDescr)fromDescr.getDataSource();
        From from = null;
        try {
            Map decls = context.getDeclarationResolver().getDeclarations(context.getRule());
            String text = expr.getText();
            context.getDeclarationResolver();
            AnalysisResult analysis = dialect.analyzeExpression(context, descr, text, new BoundIdentifiers(DeclarationScopeResolver.getDeclarationClasses((Map)decls), context.getPackageBuilder().getGlobals()));
            if (analysis == null) {
                RuleConditionElement ruleConditionElement = null;
                return ruleConditionElement;
            }
            BoundIdentifiers usedIdentifiers = analysis.getBoundIdentifiers();
            Declaration[] declarations = new Declaration[usedIdentifiers.getDeclrClasses().size()];
            String[] declrStr = new String[declarations.length];
            int j = 0;
            Iterator<String> i$ = usedIdentifiers.getDeclrClasses().keySet().iterator();
            while (i$.hasNext()) {
                String str;
                declrStr[j] = str = i$.next();
                declarations[j++] = (Declaration)decls.get(str);
            }
            Arrays.sort(declarations, RuleTerminalNode.SortDeclarations.instance);
            MVELCompilationUnit unit = dialect.getMVELCompilationUnit(text, analysis, declarations, null, null, context, "drools", KnowledgeHelper.class, false);
            MVELDataProvider dataProvider = new MVELDataProvider(unit, context.getDialect().getId());
            from = new From((DataProvider)dataProvider);
            MVELDialectRuntimeData data = (MVELDialectRuntimeData)context.getPkg().getDialectRuntimeRegistry().getDialectData("mvel");
            data.addCompileable((Wireable)from, (MVELCompileable)dataProvider);
            dataProvider.compile(data);
        }
        catch (Exception e) {
            DialectUtil.copyErrorLocation(e, fromDescr);
            context.addError(new DescrBuildError(context.getParentDescr(), fromDescr, null, "Unable to build expression for 'from' : " + e.getMessage() + " '" + expr.getText() + "'"));
            RuleConditionElement ruleConditionElement = null;
            return ruleConditionElement;
        }
        finally {
            context.setTypesafe(typeSafe);
        }
        return from;
    }
}

