/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.builder.impl;

import java.io.IOException;
import java.io.StringReader;
import org.drools.compiler.builder.impl.KnowledgeBuilderConfigurationImpl;
import org.drools.compiler.builder.impl.Processor;
import org.drools.compiler.builder.impl.errors.MissingImplementationException;
import org.drools.drl.ast.descr.PackageDescr;
import org.drools.drl.extensions.GuidedRuleTemplateFactory;
import org.drools.drl.extensions.GuidedRuleTemplateProvider;
import org.drools.drl.extensions.ResourceConversionResult;
import org.drools.drl.parser.DroolsParserException;
import org.drools.drl.parser.lang.dsl.DefaultExpander;
import org.kie.api.builder.ReleaseId;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;

public class ProcessorTemplate
extends Processor {
    public ProcessorTemplate(KnowledgeBuilderConfigurationImpl configuration, ReleaseId releaseId) {
        super(configuration, releaseId);
    }

    public PackageDescr process(Resource resource, DefaultExpander expander) throws DroolsParserException, IOException {
        GuidedRuleTemplateProvider guidedRuleTemplateProvider = GuidedRuleTemplateFactory.getGuidedRuleTemplateProvider();
        if (guidedRuleTemplateProvider == null) {
            throw new MissingImplementationException(resource, "drools-workbench-models-guided-template");
        }
        ResourceConversionResult conversionResult = guidedRuleTemplateProvider.loadFromInputStream(resource.getInputStream());
        return this.conversionResultToPackageDescr(resource, conversionResult, expander);
    }

    private PackageDescr conversionResultToPackageDescr(Resource resource, ResourceConversionResult resourceConversionResult, DefaultExpander expander) throws DroolsParserException {
        ResourceType resourceType = resourceConversionResult.getType();
        if (ResourceType.DSLR.equals((Object)resourceType)) {
            return this.generatedDslrToPackageDescr(resource, resourceConversionResult.getContent(), expander);
        }
        if (ResourceType.DRL.equals((Object)resourceType)) {
            return this.generatedDrlToPackageDescr(resource, resourceConversionResult.getContent());
        }
        throw new DroolsParserException("Converting generated " + resourceType + " into PackageDescr is not supported!");
    }

    PackageDescr generatedDslrToPackageDescr(Resource resource, String dslr, DefaultExpander expander) throws DroolsParserException {
        return this.dslrReaderToPackageDescr(resource, new StringReader(dslr), expander);
    }
}

