/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.builder.impl;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.drools.compiler.builder.impl.EvaluatorRegistry;
import org.drools.compiler.compiler.Dialect;
import org.drools.compiler.compiler.DialectCompiletimeRegistry;
import org.drools.compiler.compiler.DialectConfiguration;
import org.drools.compiler.compiler.PackageRegistry;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.rule.builder.ConstraintBuilder;
import org.drools.compiler.rule.builder.EvaluatorDefinition;
import org.drools.compiler.rule.builder.util.AccumulateUtil;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.drl.parser.DrlParser;
import org.drools.util.StringUtils;
import org.drools.wiring.api.classloader.ProjectClassLoader;
import org.kie.api.runtime.rule.AccumulateFunction;
import org.kie.internal.builder.KnowledgeBuilderConfiguration;
import org.kie.internal.builder.ResultSeverity;
import org.kie.internal.builder.conf.AccumulateFunctionOption;
import org.kie.internal.builder.conf.AlphaNetworkCompilerOption;
import org.kie.internal.builder.conf.DefaultDialectOption;
import org.kie.internal.builder.conf.DefaultPackageNameOption;
import org.kie.internal.builder.conf.DumpDirOption;
import org.kie.internal.builder.conf.EvaluatorOption;
import org.kie.internal.builder.conf.ExternaliseCanonicalModelLambdaOption;
import org.kie.internal.builder.conf.GroupDRLsInKieBasesByFolderOption;
import org.kie.internal.builder.conf.KBuilderSeverityOption;
import org.kie.internal.builder.conf.KnowledgeBuilderOption;
import org.kie.internal.builder.conf.LanguageLevelOption;
import org.kie.internal.builder.conf.MultiValueKnowledgeBuilderOption;
import org.kie.internal.builder.conf.ParallelLambdaExternalizationOption;
import org.kie.internal.builder.conf.ParallelRulesBuildThresholdOption;
import org.kie.internal.builder.conf.ProcessStringEscapesOption;
import org.kie.internal.builder.conf.PropertySpecificOption;
import org.kie.internal.builder.conf.SingleValueKnowledgeBuilderOption;
import org.kie.internal.builder.conf.TrimCellsInDTableOption;
import org.kie.internal.utils.ChainedProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KnowledgeBuilderConfigurationImpl
implements KnowledgeBuilderConfiguration {
    public static final String DEFAULT_PACKAGE = "defaultpkg";
    private static final int DEFAULT_PARALLEL_RULES_BUILD_THRESHOLD = 10;
    private final Map<String, DialectConfiguration> dialectConfigurations = new HashMap<String, DialectConfiguration>();
    private DefaultDialectOption defaultDialect = DefaultDialectOption.get((String)"java");
    private ParallelRulesBuildThresholdOption parallelRulesBuildThreshold = ParallelRulesBuildThresholdOption.get((int)10);
    private ClassLoader classLoader;
    private ChainedProperties chainedProperties;
    private Map<String, AccumulateFunction> accumulateFunctions;
    private EvaluatorRegistry evaluatorRegistry;
    private File dumpDirectory;
    private boolean processStringEscapes = true;
    private boolean trimCellsInDTable = true;
    private boolean groupDRLsInKieBasesByFolder = false;
    private boolean externaliseCanonicalModelLambda = true;
    private boolean parallelLambdaExternalization = true;
    private AlphaNetworkCompilerOption alphaNetworkCompilerOption = AlphaNetworkCompilerOption.DISABLED;
    private static final PropertySpecificOption DEFAULT_PROP_SPEC_OPT = PropertySpecificOption.ALWAYS;
    private PropertySpecificOption propertySpecificOption = DEFAULT_PROP_SPEC_OPT;
    private String defaultPackageName;
    private Map<String, ResultSeverity> severityMap;
    private LanguageLevelOption languageLevel = DrlParser.DEFAULT_LANGUAGE_LEVEL;
    private InternalKieModule.CompilationCache compilationCache = null;
    private static final Logger log = LoggerFactory.getLogger(KnowledgeBuilderConfigurationImpl.class);

    public KnowledgeBuilderConfigurationImpl(ClassLoader classLoader) {
        this.init(null, classLoader);
    }

    public KnowledgeBuilderConfigurationImpl(Properties properties) {
        this.init(properties, null);
    }

    public KnowledgeBuilderConfigurationImpl(Properties properties, ClassLoader classLoader) {
        this.init(properties, classLoader);
    }

    public KnowledgeBuilderConfigurationImpl() {
        this.init(null, null);
    }

    private void init(Properties properties, ClassLoader classLoader) {
        this.classLoader = ProjectClassLoader.getClassLoader((ClassLoader)classLoader, this.getClass());
        this.init(properties);
    }

    private void init(Properties properties) {
        this.chainedProperties = ChainedProperties.getChainedProperties((ClassLoader)this.getClassLoader());
        if (this.chainedProperties.getProperty("drools.dialect.java", null) == null) {
            this.chainedProperties = ChainedProperties.getChainedProperties((ClassLoader)this.getClass().getClassLoader());
            if (this.classLoader instanceof ProjectClassLoader) {
                ((ProjectClassLoader)this.classLoader).setDroolsClassLoader(this.getClass().getClassLoader());
            }
        }
        if (properties != null) {
            this.chainedProperties.addProperties(properties);
        }
        this.setProperty("drools.trimCellsInDTable", this.chainedProperties.getProperty("drools.trimCellsInDTable", "true"));
        this.setProperty("drools.groupDRLsInKieBasesByFolder", this.chainedProperties.getProperty("drools.groupDRLsInKieBasesByFolder", "false"));
        this.setProperty("drools.propertySpecific", this.chainedProperties.getProperty("drools.propertySpecific", DEFAULT_PROP_SPEC_OPT.toString()));
        this.setProperty("drools.lang.level", this.chainedProperties.getProperty("drools.lang.level", DrlParser.DEFAULT_LANGUAGE_LEVEL.toString()));
        this.setProperty("drools.parallelRulesBuildThreshold", this.chainedProperties.getProperty("drools.parallelRulesBuildThreshold", String.valueOf(10)));
        this.buildDialectConfigurationMap();
        this.accumulateFunctions = AccumulateUtil.buildAccumulateFunctionsMap(this.chainedProperties, this.getFunctionFactoryClassLoader());
        this.buildEvaluatorRegistry();
        this.buildDumpDirectory();
        this.buildSeverityMap();
        this.setProperty("drools.parser.processStringEscapes", this.chainedProperties.getProperty("drools.parser.processStringEscapes", "true"));
        this.setProperty("drools.defaultPackageName", this.chainedProperties.getProperty("drools.defaultPackageName", DEFAULT_PACKAGE));
        this.setProperty("drools.externaliseCanonicalModelLambda", this.chainedProperties.getProperty("drools.externaliseCanonicalModelLambda", "true"));
        this.setProperty("drools.parallelLambdaExternalization", this.chainedProperties.getProperty("drools.parallelLambdaExternalization", "true"));
    }

    protected ClassLoader getFunctionFactoryClassLoader() {
        return this.getClassLoader();
    }

    private void buildSeverityMap() {
        this.severityMap = new HashMap<String, ResultSeverity>();
        HashMap temp = new HashMap();
        this.chainedProperties.mapStartsWith(temp, KBuilderSeverityOption.PROPERTY_NAME, true);
        int index = KBuilderSeverityOption.PROPERTY_NAME.length();
        for (Map.Entry entry : temp.entrySet()) {
            String identifier = ((String)entry.getKey()).trim().substring(index);
            this.severityMap.put(identifier, KBuilderSeverityOption.get((String)identifier, (String)((String)entry.getValue())).getSeverity());
        }
    }

    public void setProperty(String name, String value) {
        if (StringUtils.isEmpty((CharSequence)(name = name.trim()))) {
            return;
        }
        if (name.equals("drools.dialect.default")) {
            this.setDefaultDialect(value);
        } else if (name.startsWith("drools.accumulate.function.")) {
            this.addAccumulateFunction(name.substring("drools.accumulate.function.".length()), value);
        } else if (name.startsWith("drools.evaluator.")) {
            this.evaluatorRegistry.addEvaluatorDefinition(value);
        } else if (name.equals("drools.dump.dir")) {
            this.buildDumpDirectory(value);
        } else if (name.equals("drools.defaultPackageName")) {
            this.setDefaultPackageName(value);
        } else if (name.equals("drools.parser.processStringEscapes")) {
            this.setProcessStringEscapes(Boolean.parseBoolean(value));
        } else if (name.equals("drools.trimCellsInDTable")) {
            this.setTrimCellsInDTable(Boolean.parseBoolean(value));
        } else if (name.equals("drools.groupDRLsInKieBasesByFolder")) {
            this.setGroupDRLsInKieBasesByFolder(Boolean.parseBoolean(value));
        } else if (name.startsWith(KBuilderSeverityOption.PROPERTY_NAME)) {
            String key = name.substring(name.lastIndexOf(46) + 1);
            this.severityMap.put(key, KBuilderSeverityOption.get((String)key, (String)value).getSeverity());
        } else if (name.equals("drools.propertySpecific")) {
            try {
                this.setPropertySpecificOption(PropertySpecificOption.valueOf((String)value.toUpperCase()));
            }
            catch (IllegalArgumentException e) {
                log.warn("Invalid value " + value + " for option " + "drools.propertySpecific");
            }
        } else if (name.equals("drools.lang.level")) {
            try {
                this.setLanguageLevel(LanguageLevelOption.valueOf((String)value.toUpperCase()));
            }
            catch (IllegalArgumentException e) {
                log.warn("Invalid value " + value + " for option " + "drools.lang.level");
            }
        } else if (name.equals("drools.parallelRulesBuildThreshold")) {
            this.setParallelRulesBuildThreshold(Integer.valueOf(value));
        } else if (name.equals("drools.externaliseCanonicalModelLambda")) {
            this.setExternaliseCanonicalModelLambda(Boolean.valueOf(value));
        } else if (name.equals("drools.parallelLambdaExternalization")) {
            this.setParallelLambdaExternalization(Boolean.valueOf(value));
        } else if (name.equals("drools.alphaNetworkCompiler")) {
            try {
                this.setAlphaNetworkCompilerOption(AlphaNetworkCompilerOption.determineAlphaNetworkCompilerMode((String)value.toUpperCase()));
            }
            catch (IllegalArgumentException e) {
                log.warn("Invalid value " + value + " for option " + "drools.alphaNetworkCompiler");
            }
        } else {
            Properties additionalProperty = new Properties();
            additionalProperty.setProperty(name, value);
            this.chainedProperties.addProperties(additionalProperty);
        }
    }

    public String getProperty(String name) {
        if (StringUtils.isEmpty((CharSequence)(name = name.trim()))) {
            return null;
        }
        if (name.equals("drools.dialect.default")) {
            return this.getDefaultDialect();
        }
        if (name.equals("drools.defaultPackageName")) {
            return this.getDefaultPackageName();
        }
        if (name.startsWith("drools.accumulate.function.")) {
            int index = "drools.accumulate.function.".length();
            AccumulateFunction function = this.accumulateFunctions.get(name.substring(index));
            return function != null ? function.getClass().getName() : null;
        }
        if (name.startsWith("drools.evaluator.")) {
            String key = name.substring(name.lastIndexOf(46) + 1);
            EvaluatorDefinition evalDef = this.evaluatorRegistry.getEvaluatorDefinition(key);
            return evalDef != null ? evalDef.getClass().getName() : null;
        }
        if (name.equals("drools.dump.dir")) {
            return this.dumpDirectory != null ? this.dumpDirectory.toString() : null;
        }
        if (name.equals("drools.parser.processStringEscapes")) {
            return String.valueOf(this.isProcessStringEscapes());
        }
        if (name.equals("drools.trimCellsInDTable")) {
            return String.valueOf(this.isTrimCellsInDTable());
        }
        if (name.equals("drools.groupDRLsInKieBasesByFolder")) {
            return String.valueOf(this.isGroupDRLsInKieBasesByFolder());
        }
        if (name.startsWith(KBuilderSeverityOption.PROPERTY_NAME)) {
            String key = name.substring(name.lastIndexOf(46) + 1);
            ResultSeverity severity = this.severityMap.get(key);
            return severity.toString();
        }
        if (name.equals("drools.lang.level")) {
            return "" + this.getLanguageLevel();
        }
        if (name.equals("drools.parallelRulesBuildThreshold")) {
            return String.valueOf(this.getParallelRulesBuildThreshold());
        }
        if (name.equals("drools.externaliseCanonicalModelLambda")) {
            return String.valueOf(this.isExternaliseCanonicalModelLambda());
        }
        if (name.equals("drools.parallelLambdaExternalization")) {
            return String.valueOf(this.isParallelLambdaExternalization());
        }
        return null;
    }

    public ChainedProperties getChainedProperties() {
        return this.chainedProperties;
    }

    private void buildDialectConfigurationMap() {
        DialectConfiguration mvel = ConstraintBuilder.get().createMVELDialectConfiguration(this);
        if (mvel != null) {
            mvel.init(this);
            this.dialectConfigurations.put("mvel", mvel);
        }
        DialectConfiguration java = ConstraintBuilder.get().createJavaDialectConfiguration(this);
        java.init(this);
        this.dialectConfigurations.put("java", java);
        HashMap dialectProperties = new HashMap();
        this.chainedProperties.mapStartsWith(dialectProperties, "drools.dialect", false);
        this.setDefaultDialect((String)dialectProperties.get("drools.dialect.default"));
    }

    public void addDialect(String dialectName, DialectConfiguration dialectConf) {
        this.dialectConfigurations.put(dialectName, dialectConf);
    }

    public DialectCompiletimeRegistry buildDialectRegistry(ClassLoader rootClassLoader, KnowledgeBuilderConfigurationImpl pkgConf, PackageRegistry pkgRegistry, InternalKnowledgePackage pkg) {
        DialectCompiletimeRegistry registry = new DialectCompiletimeRegistry();
        for (DialectConfiguration conf : this.dialectConfigurations.values()) {
            Dialect dialect = conf.newDialect(rootClassLoader, pkgConf, pkgRegistry, pkg);
            registry.addDialect(dialect.getId(), dialect);
        }
        return registry;
    }

    public String getDefaultDialect() {
        return this.defaultDialect.getName();
    }

    public void setDefaultDialect(String defaultDialect) {
        this.defaultDialect = DefaultDialectOption.get((String)defaultDialect);
    }

    public DialectConfiguration getDialectConfiguration(String name) {
        return this.dialectConfigurations.get(name);
    }

    public void setDialectConfiguration(String name, DialectConfiguration configuration) {
        this.dialectConfigurations.put(name, configuration);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void addAccumulateFunction(String identifier, String className) {
        this.accumulateFunctions.put(identifier, AccumulateUtil.loadAccumulateFunction(this.getClassLoader(), identifier, className));
    }

    public void addAccumulateFunction(String identifier, Class<? extends AccumulateFunction> clazz) {
        try {
            this.accumulateFunctions.put(identifier, clazz.newInstance());
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Error loading accumulate function for identifier " + identifier + ". Instantiation failed for class " + clazz.getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Error loading accumulate function for identifier " + identifier + ". Illegal access to class " + clazz.getName(), e);
        }
    }

    public AccumulateFunction getAccumulateFunction(String identifier) {
        return this.accumulateFunctions.get(identifier);
    }

    public Collection<String> getAccumulateFunctionNames() {
        return this.accumulateFunctions.keySet();
    }

    private void buildEvaluatorRegistry() {
        this.evaluatorRegistry = new EvaluatorRegistry(this.getFunctionFactoryClassLoader());
        HashMap temp = new HashMap();
        this.chainedProperties.mapStartsWith(temp, "drools.evaluator.", true);
        for (Map.Entry e : temp.entrySet()) {
            String key = (String)e.getKey();
            if ("drools.evaluator.equality".equals(key) || "drools.evaluator.comparable".equals(key)) continue;
            this.evaluatorRegistry.addEvaluatorDefinition((String)e.getValue());
        }
    }

    public EvaluatorRegistry getEvaluatorRegistry() {
        return this.evaluatorRegistry;
    }

    public void addEvaluatorDefinition(String className) {
        this.evaluatorRegistry.addEvaluatorDefinition(className);
    }

    public void addEvaluatorDefinition(EvaluatorDefinition def) {
        this.evaluatorRegistry.addEvaluatorDefinition(def);
    }

    private void buildDumpDirectory() {
        String dumpStr = this.chainedProperties.getProperty("drools.dump.dir", null);
        this.buildDumpDirectory(dumpStr);
    }

    private void buildDumpDirectory(String dumpStr) {
        if (dumpStr != null) {
            this.setDumpDir(new File(dumpStr));
        }
    }

    public File getDumpDir() {
        return this.dumpDirectory;
    }

    public void setDumpDir(File dumpDir) {
        if (!(dumpDir.isDirectory() && dumpDir.canWrite() && dumpDir.canRead())) {
            throw new RuntimeException("Drools dump directory is not accessible: " + dumpDir.toString());
        }
        this.dumpDirectory = dumpDir;
    }

    public boolean isProcessStringEscapes() {
        return this.processStringEscapes;
    }

    public void setProcessStringEscapes(boolean processStringEscapes) {
        this.processStringEscapes = processStringEscapes;
    }

    public boolean isTrimCellsInDTable() {
        return this.trimCellsInDTable;
    }

    public void setTrimCellsInDTable(boolean trimCellsInDTable) {
        this.trimCellsInDTable = trimCellsInDTable;
    }

    public boolean isGroupDRLsInKieBasesByFolder() {
        return this.groupDRLsInKieBasesByFolder;
    }

    public void setGroupDRLsInKieBasesByFolder(boolean groupDRLsInKieBasesByFolder) {
        this.groupDRLsInKieBasesByFolder = groupDRLsInKieBasesByFolder;
    }

    public int getParallelRulesBuildThreshold() {
        return this.parallelRulesBuildThreshold.getParallelRulesBuildThreshold();
    }

    public void setParallelRulesBuildThreshold(int parallelRulesBuildThreshold) {
        this.parallelRulesBuildThreshold = ParallelRulesBuildThresholdOption.get((int)parallelRulesBuildThreshold);
    }

    public String getDefaultPackageName() {
        return this.defaultPackageName;
    }

    public void setDefaultPackageName(String defaultPackageName) {
        this.defaultPackageName = defaultPackageName;
    }

    public LanguageLevelOption getLanguageLevel() {
        return this.languageLevel;
    }

    public void setLanguageLevel(LanguageLevelOption languageLevel) {
        this.languageLevel = languageLevel;
    }

    public PropertySpecificOption getPropertySpecificOption() {
        return this.propertySpecificOption;
    }

    public void setPropertySpecificOption(PropertySpecificOption propertySpecificOption) {
        this.propertySpecificOption = propertySpecificOption;
    }

    public boolean isExternaliseCanonicalModelLambda() {
        return this.externaliseCanonicalModelLambda;
    }

    public void setExternaliseCanonicalModelLambda(boolean externaliseCanonicalModelLambda) {
        this.externaliseCanonicalModelLambda = externaliseCanonicalModelLambda;
    }

    public boolean isParallelLambdaExternalization() {
        return this.parallelLambdaExternalization;
    }

    public void setParallelLambdaExternalization(boolean parallelLambdaExternalization) {
        this.parallelLambdaExternalization = parallelLambdaExternalization;
    }

    public AlphaNetworkCompilerOption getAlphaNetworkCompilerOption() {
        return this.alphaNetworkCompilerOption;
    }

    public void setAlphaNetworkCompilerOption(AlphaNetworkCompilerOption alphaNetworkCompilerOption) {
        this.alphaNetworkCompilerOption = alphaNetworkCompilerOption;
    }

    public <T extends SingleValueKnowledgeBuilderOption> T getOption(Class<T> option) {
        if (DefaultDialectOption.class.equals(option)) {
            return (T)this.defaultDialect;
        }
        if (DumpDirOption.class.equals(option)) {
            return (T)DumpDirOption.get((File)this.dumpDirectory);
        }
        if (ProcessStringEscapesOption.class.equals(option)) {
            return (T)(this.processStringEscapes ? ProcessStringEscapesOption.YES : ProcessStringEscapesOption.NO);
        }
        if (DefaultPackageNameOption.class.equals(option)) {
            return (T)DefaultPackageNameOption.get((String)this.defaultPackageName);
        }
        if (TrimCellsInDTableOption.class.equals(option)) {
            return (T)(this.trimCellsInDTable ? TrimCellsInDTableOption.ENABLED : TrimCellsInDTableOption.DISABLED);
        }
        if (GroupDRLsInKieBasesByFolderOption.class.equals(option)) {
            return (T)(this.groupDRLsInKieBasesByFolder ? GroupDRLsInKieBasesByFolderOption.ENABLED : GroupDRLsInKieBasesByFolderOption.DISABLED);
        }
        if (PropertySpecificOption.class.equals(option)) {
            return (T)this.propertySpecificOption;
        }
        if (LanguageLevelOption.class.equals(option)) {
            return (T)this.languageLevel;
        }
        if (ExternaliseCanonicalModelLambdaOption.class.equals(option)) {
            return (T)(this.externaliseCanonicalModelLambda ? ExternaliseCanonicalModelLambdaOption.ENABLED : ExternaliseCanonicalModelLambdaOption.DISABLED);
        }
        if (ParallelLambdaExternalizationOption.class.equals(option)) {
            return (T)(this.parallelLambdaExternalization ? ParallelLambdaExternalizationOption.ENABLED : ParallelLambdaExternalizationOption.DISABLED);
        }
        if (AlphaNetworkCompilerOption.class.equals(option)) {
            return (T)this.alphaNetworkCompilerOption;
        }
        return null;
    }

    public <T extends MultiValueKnowledgeBuilderOption> T getOption(Class<T> option, String key) {
        if (AccumulateFunctionOption.class.equals(option)) {
            return (T)AccumulateFunctionOption.get((String)key, (AccumulateFunction)this.accumulateFunctions.get(key));
        }
        if (EvaluatorOption.class.equals(option)) {
            return (T)EvaluatorOption.get((String)key, (org.kie.api.runtime.rule.EvaluatorDefinition)this.evaluatorRegistry.getEvaluatorDefinition(key));
        }
        if (KBuilderSeverityOption.class.equals(option)) {
            return (T)KBuilderSeverityOption.get((String)key, (ResultSeverity)this.severityMap.get(key));
        }
        return null;
    }

    public <T extends MultiValueKnowledgeBuilderOption> Set<String> getOptionKeys(Class<T> option) {
        if (AccumulateFunctionOption.class.equals(option)) {
            return this.accumulateFunctions.keySet();
        }
        if (EvaluatorOption.class.equals(option)) {
            return this.evaluatorRegistry.keySet();
        }
        if (KBuilderSeverityOption.class.equals(option)) {
            return this.severityMap.keySet();
        }
        return null;
    }

    public <T extends KnowledgeBuilderOption> void setOption(T option) {
        if (option instanceof DefaultDialectOption) {
            this.defaultDialect = (DefaultDialectOption)option;
        } else if (option instanceof AccumulateFunctionOption) {
            this.accumulateFunctions.put(((AccumulateFunctionOption)option).getName(), ((AccumulateFunctionOption)option).getFunction());
        } else if (option instanceof DumpDirOption) {
            this.dumpDirectory = ((DumpDirOption)option).getDirectory();
        } else if (option instanceof EvaluatorOption) {
            this.evaluatorRegistry.addEvaluatorDefinition((EvaluatorDefinition)((EvaluatorOption)option).getEvaluatorDefinition());
        } else if (option instanceof ProcessStringEscapesOption) {
            this.processStringEscapes = ((ProcessStringEscapesOption)option).isProcessStringEscapes();
        } else if (option instanceof DefaultPackageNameOption) {
            this.setDefaultPackageName(((DefaultPackageNameOption)option).getPackageName());
        } else if (option instanceof TrimCellsInDTableOption) {
            this.setTrimCellsInDTable(((TrimCellsInDTableOption)option).isTrimCellsInDTable());
        } else if (option instanceof GroupDRLsInKieBasesByFolderOption) {
            this.setGroupDRLsInKieBasesByFolder(((GroupDRLsInKieBasesByFolderOption)option).isGroupDRLsInKieBasesByFolder());
        } else if (option instanceof KBuilderSeverityOption) {
            this.severityMap.put(((KBuilderSeverityOption)option).getName(), ((KBuilderSeverityOption)option).getSeverity());
        } else if (option instanceof PropertySpecificOption) {
            this.propertySpecificOption = (PropertySpecificOption)option;
        } else if (option instanceof LanguageLevelOption) {
            this.languageLevel = (LanguageLevelOption)option;
        } else if (option instanceof ExternaliseCanonicalModelLambdaOption) {
            this.externaliseCanonicalModelLambda = ((ExternaliseCanonicalModelLambdaOption)option).isCanonicalModelLambdaExternalized();
        } else if (option instanceof ParallelLambdaExternalizationOption) {
            this.parallelLambdaExternalization = ((ParallelLambdaExternalizationOption)option).isLambdaExternalizationParallel();
        } else if (option instanceof AlphaNetworkCompilerOption) {
            this.alphaNetworkCompilerOption = (AlphaNetworkCompilerOption)option;
        }
    }

    public InternalKieModule.CompilationCache getCompilationCache() {
        return this.compilationCache;
    }

    public void setCompilationCache(InternalKieModule.CompilationCache cache) {
        this.compilationCache = cache;
    }

    public boolean isPreCompiled() {
        return this.compilationCache != null;
    }
}

