/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.util;

import java.io.File;
import java.util.HashMap;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import org.apache.log4j.Logger;
import org.dspace.app.util.DCInputSet;
import org.dspace.core.ConfigurationManager;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DCInputsReader {
    public static final String DEFAULT_COLLECTION = "default";
    static final String FORM_DEF_FILE = "input-forms.xml";
    static final String PAIR_TYPE_NAME = "value-pairs-name";
    private static Logger log = Logger.getLogger(DCInputsReader.class);
    private String defsFile = ConfigurationManager.getProperty("dspace.dir") + File.separator + "config" + File.separator + "input-forms.xml";
    private HashMap whichForms = null;
    private HashMap formDefns = null;
    private HashMap formFileUploadDefns = null;
    private HashMap valuePairs = null;
    private DCInputSet lastInputSet = null;

    public DCInputsReader() throws ServletException {
        this.buildInputs(this.defsFile);
    }

    public DCInputsReader(String fileName) throws ServletException {
        this.buildInputs(fileName);
    }

    private void buildInputs(String fileName) throws ServletException {
        this.whichForms = new HashMap();
        this.formDefns = new HashMap();
        this.valuePairs = new HashMap();
        String uri = "file:" + new File(fileName).getAbsolutePath();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            factory.setIgnoringComments(true);
            factory.setIgnoringElementContentWhitespace(true);
            DocumentBuilder db = factory.newDocumentBuilder();
            Document doc = db.parse(uri);
            this.doNodes(doc);
            this.checkValues();
        }
        catch (FactoryConfigurationError fe) {
            throw new ServletException("Cannot create Submission form parser", (Throwable)fe);
        }
        catch (Exception e) {
            throw new ServletException("Error creating submission forms: " + e);
        }
    }

    public DCInputSet getInputs(String collectionHandle) throws ServletException {
        String formName = (String)this.whichForms.get(collectionHandle);
        if (formName == null) {
            formName = (String)this.whichForms.get(DEFAULT_COLLECTION);
        }
        if (formName == null) {
            throw new ServletException("No form designated as default");
        }
        if (this.lastInputSet != null && this.lastInputSet.getFormName().equals(formName)) {
            return this.lastInputSet;
        }
        Vector pages = (Vector)this.formDefns.get(formName);
        if (pages == null) {
            throw new ServletException("Missing the " + formName + " form");
        }
        this.lastInputSet = new DCInputSet(formName, pages, this.valuePairs);
        return this.lastInputSet;
    }

    public int getNumberInputPages(String collectionHandle) throws ServletException {
        return this.getInputs(collectionHandle).getNumberPages();
    }

    private void doNodes(Node n) throws SAXException, ServletException {
        if (n == null) {
            return;
        }
        Node e = this.getElement(n);
        NodeList nl = e.getChildNodes();
        int len = nl.getLength();
        boolean foundMap = false;
        boolean foundDefs = false;
        for (int i = 0; i < len; ++i) {
            Node nd = nl.item(i);
            if (nd == null || this.isEmptyTextNode(nd)) continue;
            String tagName = nd.getNodeName();
            if (tagName.equals("form-map")) {
                this.processMap(nd);
                foundMap = true;
                continue;
            }
            if (tagName.equals("form-definitions")) {
                this.processDefinition(nd);
                foundDefs = true;
                continue;
            }
            if (!tagName.equals("form-value-pairs")) continue;
            this.processValuePairs(nd);
        }
        if (!foundMap) {
            throw new ServletException("No collection to form map found");
        }
        if (!foundDefs) {
            throw new ServletException("No form definition found");
        }
    }

    private void processMap(Node e) throws SAXException {
        NodeList nl = e.getChildNodes();
        int len = nl.getLength();
        for (int i = 0; i < len; ++i) {
            Node nd = nl.item(i);
            if (!nd.getNodeName().equals("name-map")) continue;
            String id = this.getAttribute(nd, "collection-handle");
            String value = this.getAttribute(nd, "form-name");
            String content = this.getValue(nd);
            if (id == null) {
                throw new SAXException("name-map element is missing collection-handle attribute");
            }
            if (value == null) {
                throw new SAXException("name-map element is missing form-name attribute");
            }
            if (content != null && content.length() > 0) {
                throw new SAXException("name-map element has content, it should be empty.");
            }
            this.whichForms.put(id, value);
        }
    }

    private void processDefinition(Node e) throws SAXException, ServletException {
        int numForms = 0;
        NodeList nl = e.getChildNodes();
        int len = nl.getLength();
        for (int i = 0; i < len; ++i) {
            Node nd = nl.item(i);
            if (!nd.getNodeName().equals("form")) continue;
            ++numForms;
            String formName = this.getAttribute(nd, "name");
            if (formName == null) {
                throw new SAXException("form element has no name attribute");
            }
            Vector pages = new Vector();
            this.formDefns.put(formName, pages);
            NodeList pl = nd.getChildNodes();
            int lenpg = pl.getLength();
            for (int j = 0; j < lenpg; ++j) {
                Node npg = pl.item(j);
                if (!npg.getNodeName().equals("page")) continue;
                String pgNum = this.getAttribute(npg, "number");
                if (pgNum == null) {
                    throw new SAXException("Form " + formName + " has no identified pages");
                }
                Vector page = new Vector();
                pages.add(page);
                NodeList flds = npg.getChildNodes();
                int lenflds = flds.getLength();
                for (int k = 0; k < lenflds; ++k) {
                    Node nfld = flds.item(k);
                    if (!nfld.getNodeName().equals("field")) continue;
                    HashMap field = new HashMap();
                    page.add(field);
                    this.processPageParts(formName, pgNum, nfld, field);
                    String error = this.checkForDups(formName, field, pages);
                    if (error == null) continue;
                    throw new SAXException(error);
                }
            }
            if (pages.size() >= 1) continue;
            throw new ServletException("Form " + formName + " has no pages");
        }
        if (numForms == 0) {
            throw new ServletException("No form definition found");
        }
    }

    private void processPageParts(String formName, String page, Node n, HashMap field) throws SAXException {
        String rpt;
        NodeList nl = n.getChildNodes();
        int len = nl.getLength();
        for (int i = 0; i < len; ++i) {
            Node nd = nl.item(i);
            if (this.isEmptyTextNode(nd)) continue;
            String tagName = nd.getNodeName();
            String value = this.getValue(nd);
            field.put(tagName, value);
            if (tagName.equals("input-type")) {
                if (!value.equals("dropdown") && !value.equals("qualdrop_value") && !value.equals("list")) continue;
                String pairTypeName = this.getAttribute(nd, PAIR_TYPE_NAME);
                if (pairTypeName == null) {
                    throw new SAXException("Form " + formName + ", field " + field.get("dc-element") + "." + field.get("dc-qualifier") + " has no name attribute");
                }
                field.put(PAIR_TYPE_NAME, pairTypeName);
                continue;
            }
            if (!tagName.equals("vocabulary")) continue;
            String closedVocabularyString = this.getAttribute(nd, "closed");
            field.put("closedVocabulary", closedVocabularyString);
        }
        String missing = null;
        if (field.get("dc-element") == null) {
            missing = "dc-element";
        }
        if (field.get("label") == null) {
            missing = "label";
        }
        if (field.get("input-type") == null) {
            missing = "input-type";
        }
        if (missing != null) {
            String msg = "Required field " + missing + " missing on page " + page + " of form " + formName;
            throw new SAXException(msg);
        }
        String type = (String)field.get("input-type");
        if ((type.equals("twobox") || type.equals("qualdrop_value")) && ((rpt = (String)field.get("repeatable")) == null || !rpt.equalsIgnoreCase("yes") && !rpt.equalsIgnoreCase("true"))) {
            String msg = "The field '" + field.get("label") + "' must be repeatable";
            throw new SAXException(msg);
        }
    }

    private String checkForDups(String formName, HashMap field, Vector pages) {
        int matches = 0;
        String err = null;
        String schema = (String)field.get("dc-schema");
        String elem = (String)field.get("dc-element");
        String qual = (String)field.get("dc-qualifier");
        if (schema == null || schema.equals("")) {
            schema = "dc";
        }
        for (int i = 0; i < pages.size(); ++i) {
            Vector pg = (Vector)pages.get(i);
            for (int j = 0; j < pg.size(); ++j) {
                HashMap fld = (HashMap)pg.get(j);
                String schemaTest = fld.get("dc-schema") == null || ((String)fld.get("dc-schema")).equals("") ? "dc" : (String)fld.get("dc-schema");
                if (!((String)fld.get("dc-element")).equals(elem) || !schemaTest.equals(schema)) continue;
                String ql = (String)fld.get("dc-qualifier");
                if (qual != null) {
                    if (ql == null || !ql.equals(qual)) continue;
                    ++matches;
                    continue;
                }
                if (ql != null) continue;
                ++matches;
            }
        }
        if (matches > 1) {
            err = "Duplicate field " + schema + "." + elem + "." + qual + " detected in form " + formName;
        }
        return err;
    }

    private void processValuePairs(Node e) throws SAXException {
        NodeList nl = e.getChildNodes();
        int len = nl.getLength();
        for (int i = 0; i < len; ++i) {
            Node nd = nl.item(i);
            String tagName = nd.getNodeName();
            if (!tagName.equals("value-pairs")) continue;
            String pairsName = this.getAttribute(nd, PAIR_TYPE_NAME);
            String dcTerm = this.getAttribute(nd, "dc-term");
            if (pairsName == null) {
                String errString = "Missing name attribute for value-pairs for DC term " + dcTerm;
                throw new SAXException(errString);
            }
            Vector<String> pairs = new Vector<String>();
            this.valuePairs.put(pairsName, pairs);
            NodeList cl = nd.getChildNodes();
            int lench = cl.getLength();
            for (int j = 0; j < lench; ++j) {
                Node nch = cl.item(j);
                String display = null;
                String storage = null;
                if (!nch.getNodeName().equals("pair")) continue;
                NodeList pl = nch.getChildNodes();
                int plen = pl.getLength();
                for (int k = 0; k < plen; ++k) {
                    Node vn = pl.item(k);
                    String vName = vn.getNodeName();
                    if (vName.equals("displayed-value")) {
                        display = this.getValue(vn);
                        continue;
                    }
                    if (!vName.equals("stored-value") || (storage = this.getValue(vn)) != null) continue;
                    storage = "";
                }
                pairs.add(display);
                pairs.add(storage);
            }
        }
    }

    private void checkValues() throws ServletException {
        for (String idName : this.formDefns.keySet()) {
            Vector pages = (Vector)this.formDefns.get(idName);
            for (int i = 0; i < pages.size(); ++i) {
                Vector page = (Vector)pages.get(i);
                for (int j = 0; j < page.size(); ++j) {
                    String required;
                    String pairsName;
                    Vector v;
                    HashMap fld = (HashMap)page.get(j);
                    String type = (String)fld.get("input-type");
                    if ((type.equals("dropdown") || type.equals("qualdrop_value") || type.equals("list")) && (v = (Vector)this.valuePairs.get(pairsName = (String)fld.get(PAIR_TYPE_NAME))) == null) {
                        String errString = "Cannot find value pairs for " + pairsName;
                        throw new ServletException(errString);
                    }
                    String visibility = (String)fld.get("visibility");
                    if (visibility == null || visibility.length() <= 0 || (required = (String)fld.get("required")) == null || required.length() <= 0) continue;
                    String errString = "Field '" + (String)fld.get("label") + "' is required but invisible";
                    throw new ServletException(errString);
                }
            }
        }
    }

    private Node getElement(Node nd) {
        NodeList nl = nd.getChildNodes();
        int len = nl.getLength();
        for (int i = 0; i < len; ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            return n;
        }
        return null;
    }

    private boolean isEmptyTextNode(Node nd) {
        String text;
        boolean isEmpty = false;
        if (nd.getNodeType() == 3 && (text = nd.getNodeValue().trim()).length() == 0) {
            isEmpty = true;
        }
        return isEmpty;
    }

    private String getAttribute(Node e, String name) {
        NamedNodeMap attrs = e.getAttributes();
        int len = attrs.getLength();
        if (len > 0) {
            for (int i = 0; i < len; ++i) {
                Node attr = attrs.item(i);
                if (!name.equals(attr.getNodeName())) continue;
                return attr.getNodeValue().trim();
            }
        }
        return null;
    }

    private String getValue(Node nd) {
        NodeList nl = nd.getChildNodes();
        int len = nl.getLength();
        for (int i = 0; i < len; ++i) {
            Node n = nl.item(i);
            short type = n.getNodeType();
            if (type != 3) continue;
            return n.getNodeValue().trim();
        }
        return null;
    }
}

