/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.content.Bitstream;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.event.Event;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.TableRow;
import org.dspace.storage.rdbms.TableRowIterator;

public class Bundle
extends DSpaceObject {
    private static Logger log = Logger.getLogger(Bundle.class);
    private Context ourContext;
    private TableRow bundleRow;
    private List<Bitstream> bitstreams;
    private boolean modified;
    private boolean modifiedMetadata;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Bundle(Context context, TableRow row) throws SQLException {
        this.ourContext = context;
        this.bundleRow = row;
        this.bitstreams = new ArrayList<Bitstream>();
        TableRowIterator tri = DatabaseManager.queryTable(this.ourContext, "bitstream", "SELECT bitstream.* FROM bitstream, bundle2bitstream WHERE bundle2bitstream.bitstream_id=bitstream.bitstream_id AND bundle2bitstream.bundle_id= ? ", this.bundleRow.getIntColumn("bundle_id"));
        try {
            while (tri.hasNext()) {
                TableRow r = tri.next();
                Bitstream fromCache = (Bitstream)context.fromCache(Bitstream.class, r.getIntColumn("bitstream_id"));
                if (fromCache != null) {
                    this.bitstreams.add(fromCache);
                    continue;
                }
                this.bitstreams.add(new Bitstream(this.ourContext, r));
            }
        }
        finally {
            if (tri != null) {
                tri.close();
            }
        }
        context.cache(this, row.getIntColumn("bundle_id"));
        this.modifiedMetadata = false;
        this.modified = false;
    }

    public static Bundle find(Context context, int id) throws SQLException {
        Bundle fromCache = (Bundle)context.fromCache(Bundle.class, id);
        if (fromCache != null) {
            return fromCache;
        }
        TableRow row = DatabaseManager.find(context, "bundle", id);
        if (row == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)LogManager.getHeader(context, "find_bundle", "not_found,bundle_id=" + id));
            }
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)LogManager.getHeader(context, "find_bundle", "bundle_id=" + id));
        }
        return new Bundle(context, row);
    }

    static Bundle create(Context context) throws SQLException {
        TableRow row = DatabaseManager.create(context, "bundle");
        log.info((Object)LogManager.getHeader(context, "create_bundle", "bundle_id=" + row.getIntColumn("bundle_id")));
        context.addEvent(new Event(1, 1, row.getIntColumn("bundle_id"), null));
        return new Bundle(context, row);
    }

    public int getID() {
        return this.bundleRow.getIntColumn("bundle_id");
    }

    public String getName() {
        return this.bundleRow.getStringColumn("name");
    }

    public void setName(String name) {
        this.bundleRow.setColumn("name", name);
        this.modifiedMetadata = true;
    }

    public int getPrimaryBitstreamID() {
        return this.bundleRow.getIntColumn("primary_bitstream_id");
    }

    public void setPrimaryBitstreamID(int bitstreamID) {
        this.bundleRow.setColumn("primary_bitstream_id", bitstreamID);
        this.modified = true;
    }

    public void unsetPrimaryBitstreamID() {
        this.bundleRow.setColumnNull("primary_bitstream_id");
    }

    public String getHandle() {
        return null;
    }

    public Bitstream getBitstreamByName(String name) {
        Bitstream target = null;
        for (Bitstream b : this.bitstreams) {
            if (!name.equals(b.getName())) continue;
            target = b;
            break;
        }
        return target;
    }

    public Bitstream[] getBitstreams() {
        Bitstream[] bitstreamArray = new Bitstream[this.bitstreams.size()];
        bitstreamArray = this.bitstreams.toArray(bitstreamArray);
        return bitstreamArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Item[] getItems() throws SQLException {
        ArrayList<Item> items = new ArrayList<Item>();
        TableRowIterator tri = DatabaseManager.queryTable(this.ourContext, "item", "SELECT item.* FROM item, item2bundle WHERE item2bundle.item_id=item.item_id AND item2bundle.bundle_id= ? ", this.bundleRow.getIntColumn("bundle_id"));
        try {
            while (tri.hasNext()) {
                TableRow r = tri.next();
                Item fromCache = (Item)this.ourContext.fromCache(Item.class, r.getIntColumn("item_id"));
                if (fromCache != null) {
                    items.add(fromCache);
                    continue;
                }
                items.add(new Item(this.ourContext, r));
            }
        }
        finally {
            if (tri != null) {
                tri.close();
            }
        }
        Item[] itemArray = new Item[items.size()];
        itemArray = items.toArray(itemArray);
        return itemArray;
    }

    public Bitstream createBitstream(InputStream is) throws AuthorizeException, IOException, SQLException {
        AuthorizeManager.authorizeAction(this.ourContext, this, 3);
        Bitstream b = Bitstream.create(this.ourContext, is);
        this.addBitstream(b);
        return b;
    }

    public Bitstream registerBitstream(int assetstore, String bitstreamPath) throws AuthorizeException, IOException, SQLException {
        AuthorizeManager.authorizeAction(this.ourContext, this, 3);
        Bitstream b = Bitstream.register(this.ourContext, assetstore, bitstreamPath);
        this.addBitstream(b);
        return b;
    }

    public void addBitstream(Bitstream b) throws SQLException, AuthorizeException {
        AuthorizeManager.authorizeAction(this.ourContext, this, 3);
        log.info((Object)LogManager.getHeader(this.ourContext, "add_bitstream", "bundle_id=" + this.getID() + ",bitstream_id=" + b.getID()));
        for (int i = 0; i < this.bitstreams.size(); ++i) {
            Bitstream existing = this.bitstreams.get(i);
            if (b.getID() != existing.getID()) continue;
            return;
        }
        this.bitstreams.add(b);
        this.ourContext.addEvent(new Event(8, 1, this.getID(), 0, b.getID(), String.valueOf(b.getSequenceID())));
        AuthorizeManager.inheritPolicies(this.ourContext, this, b);
        TableRow mappingRow = DatabaseManager.create(this.ourContext, "bundle2bitstream");
        mappingRow.setColumn("bundle_id", this.getID());
        mappingRow.setColumn("bitstream_id", b.getID());
        DatabaseManager.update(this.ourContext, mappingRow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBitstream(Bitstream b) throws AuthorizeException, SQLException, IOException {
        AuthorizeManager.authorizeAction(this.ourContext, this, 4);
        log.info((Object)LogManager.getHeader(this.ourContext, "remove_bitstream", "bundle_id=" + this.getID() + ",bitstream_id=" + b.getID()));
        ListIterator<Bitstream> li = this.bitstreams.listIterator();
        while (li.hasNext()) {
            Bitstream existing = li.next();
            if (b.getID() != existing.getID()) continue;
            li.remove();
            if (b.getID() != this.getPrimaryBitstreamID()) continue;
            this.unsetPrimaryBitstreamID();
        }
        this.ourContext.addEvent(new Event(16, 1, this.getID(), 0, b.getID(), String.valueOf(b.getSequenceID())));
        DatabaseManager.updateQuery(this.ourContext, "DELETE FROM bundle2bitstream WHERE bundle_id= ? AND bitstream_id= ? ", this.getID(), b.getID());
        TableRowIterator tri = DatabaseManager.query(this.ourContext, "SELECT * FROM bundle2bitstream WHERE bitstream_id= ? ", b.getID());
        try {
            if (!tri.hasNext()) {
                b.delete();
            }
        }
        finally {
            if (tri != null) {
                tri.close();
            }
        }
    }

    public void update() throws SQLException, AuthorizeException {
        log.info((Object)LogManager.getHeader(this.ourContext, "update_bundle", "bundle_id=" + this.getID()));
        if (this.modified) {
            this.ourContext.addEvent(new Event(2, 1, this.getID(), null));
            this.modified = false;
        }
        if (this.modifiedMetadata) {
            this.ourContext.addEvent(new Event(4, 1, this.getID(), null));
            this.modifiedMetadata = false;
        }
        DatabaseManager.update(this.ourContext, this.bundleRow);
    }

    void delete() throws SQLException, AuthorizeException, IOException {
        log.info((Object)LogManager.getHeader(this.ourContext, "delete_bundle", "bundle_id=" + this.getID()));
        this.ourContext.addEvent(new Event(32, 1, this.getID(), this.getName()));
        this.ourContext.removeCached(this, this.getID());
        Bitstream[] bs = this.getBitstreams();
        for (int i = 0; i < bs.length; ++i) {
            this.removeBitstream(bs[i]);
        }
        AuthorizeManager.removeAllPolicies(this.ourContext, this);
        DatabaseManager.delete(this.ourContext, this.bundleRow);
    }

    public int getType() {
        return 1;
    }
}

