/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.bulkedit;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dspace.app.bulkedit.DSpaceCSV;

public class DSpaceCSVLine {
    private int id;
    private Map<String, ArrayList> items;

    public DSpaceCSVLine(int id) {
        this.id = id;
        this.items = new HashMap<String, ArrayList>();
    }

    public DSpaceCSVLine() {
        this.id = -1;
        this.items = new HashMap<String, ArrayList>();
    }

    public int getID() {
        return this.id;
    }

    public void add(String key, String value) {
        if (this.items.get(key) == null) {
            this.items.put(key, new ArrayList());
        }
        if (value != null) {
            this.items.get(key).add(value);
        }
    }

    public List<String> get(String key) {
        return this.items.get(key);
    }

    public Set<String> keys() {
        return this.items.keySet();
    }

    protected String toCSV(List<String> headings) {
        StringBuilder bits = new StringBuilder();
        bits.append("\"").append(this.id).append("\"").append(DSpaceCSV.fieldSeparator);
        bits.append(this.valueToCSV(this.items.get("collection"))).append(DSpaceCSV.fieldSeparator);
        Iterator<String> i = headings.iterator();
        while (i.hasNext()) {
            String key = i.next();
            if (this.items.get(key) != null && !"collection".equals(key)) {
                bits.append(this.valueToCSV(this.items.get(key)));
            }
            if (!i.hasNext()) continue;
            bits.append(DSpaceCSV.fieldSeparator);
        }
        return bits.toString();
    }

    private String valueToCSV(List<String> values) {
        if (values == null) {
            return "";
        }
        if (values.size() == 1) {
            return values.get(0);
        }
        StringBuilder str = new StringBuilder();
        Iterator<String> i = values.iterator();
        while (i.hasNext()) {
            str.append((Object)i.next());
            if (!i.hasNext()) continue;
            str.append(DSpaceCSV.valueSeparator);
        }
        return "\"" + str.toString().replaceAll("\"", "\"\"") + "\"";
    }
}

