/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.crosswalk;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.content.DSpaceObject;
import org.dspace.content.crosswalk.CrosswalkException;
import org.dspace.content.crosswalk.CrosswalkInternalException;
import org.dspace.content.crosswalk.CrosswalkObjectNotSupported;
import org.dspace.content.crosswalk.DisseminationCrosswalk;
import org.dspace.content.crosswalk.IngestionCrosswalk;
import org.dspace.content.crosswalk.MetadataValidationException;
import org.dspace.content.packager.PackageException;
import org.dspace.content.packager.PackageUtils;
import org.dspace.core.Constants;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;

public class METSRightsCrosswalk
implements IngestionCrosswalk,
DisseminationCrosswalk {
    private static Logger log = Logger.getLogger(METSRightsCrosswalk.class);
    private static final Namespace METSRights_NS = Namespace.getNamespace((String)"rights", (String)"http://cosimo.stanford.edu/sdr/metsrights/");
    private String schemaLocation = METSRights_NS.getURI() + " http://cosimo.stanford.edu/sdr/metsrights.xsd";
    private static final Namespace[] namespaces = new Namespace[]{METSRights_NS};
    private static final Map<Integer, String> otherTypesMapping = new HashMap<Integer, String>();
    private static final String GROUP_CONTEXTCLASS = "MANAGED GRP";
    private static final String PERSON_CONTEXTCLASS = "ACADEMIC USER";
    private static final String ANONYMOUS_CONTEXTCLASS = "GENERAL PUBLIC";
    private static final String ADMIN_CONTEXTCLASS = "REPOSITORY MGR";
    private static final String GROUP_USERTYPE = "GROUP";
    private static final String PERSON_USERTYPE = "INDIVIDUAL";

    @Override
    public Namespace[] getNamespaces() {
        return (Namespace[])ArrayUtils.clone((Object[])namespaces);
    }

    @Override
    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    @Override
    public boolean canDisseminate(DSpaceObject dso) {
        return dso.getType() != 5;
    }

    @Override
    public Element disseminateElement(DSpaceObject dso) throws CrosswalkException, IOException, SQLException, AuthorizeException {
        if (dso == null) {
            return null;
        }
        if (dso.getType() == 5) {
            throw new CrosswalkObjectNotSupported("The METSRightsCrosswalk cannot crosswalk a SITE object");
        }
        Element rightsMD = new Element("RightsDeclarationMD", METSRights_NS);
        rightsMD.setAttribute("RIGHTSCATEGORY", "LICENSED");
        Context context = new Context();
        List<ResourcePolicy> policies = AuthorizeManager.getPolicies(context, dso);
        for (ResourcePolicy policy : policies) {
            Group group = policy.getGroup();
            EPerson person = policy.getEPerson();
            Element rightsContext = new Element("Context", METSRights_NS);
            rightsMD.addContent((Content)rightsContext);
            if (group != null) {
                String contextClass = GROUP_CONTEXTCLASS;
                if (group.getID() == 0) {
                    contextClass = ANONYMOUS_CONTEXTCLASS;
                } else if (group.getID() == 1) {
                    contextClass = ADMIN_CONTEXTCLASS;
                }
                rightsContext.setAttribute("CONTEXTCLASS", contextClass);
                if (contextClass.equals(GROUP_CONTEXTCLASS)) {
                    try {
                        Element rightsUser = new Element("UserName", METSRights_NS);
                        rightsUser.setAttribute("USERTYPE", GROUP_USERTYPE);
                        rightsUser.addContent(PackageUtils.translateGroupNameForExport(context, group.getName()));
                        rightsContext.addContent((Content)rightsUser);
                    }
                    catch (PackageException pe) {
                        throw new CrosswalkException(pe);
                    }
                }
            } else if (person != null) {
                rightsContext.setAttribute("CONTEXTCLASS", PERSON_CONTEXTCLASS);
                Element rightsUser = new Element("UserName", METSRights_NS);
                rightsUser.setAttribute("USERTYPE", PERSON_USERTYPE);
                rightsUser.addContent(person.getEmail());
                rightsContext.addContent((Content)rightsUser);
            }
            Element rightsPerm = this.translatePermissions(policy);
            rightsContext.addContent((Content)rightsPerm);
        }
        context.complete();
        return rightsMD;
    }

    @Override
    public List<Element> disseminateList(DSpaceObject dso) throws CrosswalkException, IOException, SQLException, AuthorizeException {
        ArrayList<Element> result = new ArrayList<Element>(1);
        result.add(this.disseminateElement(dso));
        return result;
    }

    @Override
    public boolean preferList() {
        return false;
    }

    private Element translatePermissions(ResourcePolicy policy) {
        Element rightsPerm = new Element("Permissions", METSRights_NS);
        int action = policy.getAction();
        if (action == 0 || action == 9 || action == 10) {
            rightsPerm.setAttribute("DISCOVER", "true");
            rightsPerm.setAttribute("DISPLAY", "true");
            rightsPerm.setAttribute("MODIFY", "false");
            rightsPerm.setAttribute("DELETE", "false");
        } else if (action == 1 || action == 3) {
            rightsPerm.setAttribute("DISCOVER", "true");
            rightsPerm.setAttribute("DISPLAY", "true");
            rightsPerm.setAttribute("MODIFY", "true");
            rightsPerm.setAttribute("DELETE", "false");
        } else if (action == 2 || action == 4) {
            rightsPerm.setAttribute("DISCOVER", "true");
            rightsPerm.setAttribute("DISPLAY", "true");
            rightsPerm.setAttribute("MODIFY", "true");
            rightsPerm.setAttribute("DELETE", "true");
        } else if (action == 11) {
            rightsPerm.setAttribute("DISCOVER", "true");
            rightsPerm.setAttribute("DISPLAY", "true");
            rightsPerm.setAttribute("COPY", "true");
            rightsPerm.setAttribute("DUPLICATE", "true");
            rightsPerm.setAttribute("MODIFY", "true");
            rightsPerm.setAttribute("DELETE", "true");
            rightsPerm.setAttribute("PRINT", "true");
        }
        if (otherTypesMapping.containsKey(action)) {
            rightsPerm.setAttribute("OTHER", "true");
            rightsPerm.setAttribute("OTHERPERMITTYPE", otherTypesMapping.get(action));
        }
        return rightsPerm;
    }

    @Override
    public void ingest(Context context, DSpaceObject dso, Element root) throws CrosswalkException, IOException, SQLException, AuthorizeException {
        if (!root.getName().equals("RightsDeclarationMD")) {
            throw new MetadataValidationException("Wrong root element for METSRights: " + root.toString());
        }
        this.ingest(context, dso, root.getChildren());
    }

    @Override
    public void ingest(Context context, DSpaceObject dso, List<Element> ml) throws CrosswalkException, IOException, SQLException, AuthorizeException {
        if (dso.getType() == 5) {
            throw new CrosswalkObjectNotSupported("Wrong target object type, METSRightsCrosswalk cannot crosswalk a SITE object.");
        }
        if (!ml.isEmpty()) {
            AuthorizeManager.removeAllPolicies(context, dso);
        }
        for (Element element : ml) {
            if (element.getName().equals("RightsDeclarationMD")) {
                this.ingest(context, dso, element.getChildren());
                continue;
            }
            if (!element.getName().equals("Context")) continue;
            String contextClass = element.getAttributeValue("CONTEXTCLASS");
            Element permsElement = element.getChild("Permissions", METSRights_NS);
            if (contextClass.equals(ANONYMOUS_CONTEXTCLASS)) {
                Group anonGroup = Group.find(context, 0);
                if (anonGroup == null) {
                    throw new CrosswalkInternalException("The DSpace database has not been properly initialized.  The Anonymous Group is missing from the database.");
                }
                this.assignPermissions(context, dso, anonGroup, permsElement);
                continue;
            }
            if (contextClass.equals(ADMIN_CONTEXTCLASS)) {
                Group adminGroup = Group.find(context, 1);
                if (adminGroup == null) {
                    throw new CrosswalkInternalException("The DSpace database has not been properly initialized.  The Administrator Group is missing from the database.");
                }
                this.assignPermissions(context, dso, adminGroup, permsElement);
                continue;
            }
            if (contextClass.equals(GROUP_CONTEXTCLASS)) {
                try {
                    String groupName = element.getChildTextTrim("UserName", METSRights_NS);
                    groupName = PackageUtils.translateGroupNameForImport(context, groupName);
                    Group group = Group.findByName(context, groupName);
                    if (group == null) {
                        throw new CrosswalkInternalException("Cannot restore Group permissions on object (type=" + Constants.typeText[dso.getType()] + ", " + "handle=" + dso.getHandle() + ", " + "ID=" + dso.getID() + "). The Group named '" + groupName + "' is missing from DSpace. " + "Please restore this group using the SITE AIP, or recreate it.");
                    }
                    this.assignPermissions(context, dso, group, permsElement);
                    continue;
                }
                catch (PackageException pe) {
                    throw new CrosswalkException(pe);
                }
            }
            if (!contextClass.equals(PERSON_CONTEXTCLASS)) continue;
            String personEmail = element.getChildTextTrim("UserName", METSRights_NS);
            EPerson person = EPerson.findByEmail(context, personEmail);
            if (person == null) {
                person = EPerson.findByNetid(context, personEmail);
            }
            if (person == null) {
                throw new CrosswalkInternalException("Cannot restore Person permissions on object (type=" + Constants.typeText[dso.getType()] + ", " + "handle=" + dso.getHandle() + ", " + "ID=" + dso.getID() + "). The Person with email/netid '" + personEmail + "' is missing from DSpace. " + "Please restore this Person object using the SITE AIP, or recreate it.");
            }
            this.assignPermissions(context, dso, person, permsElement);
        }
    }

    private void assignPermissions(Context context, DSpaceObject dso, Group group, Element permsElement) throws SQLException, AuthorizeException {
        int actionID = this.parsePermissions(permsElement);
        if (actionID < 0) {
            log.warn((Object)("Unable to properly restore all access permissions on object (type=" + Constants.typeText[dso.getType()] + ", " + "handle=" + dso.getHandle() + ", " + "ID=" + dso.getID() + ") for group '" + group.getName() + "'."));
        }
        AuthorizeManager.addPolicy(context, dso, actionID, group);
    }

    private void assignPermissions(Context context, DSpaceObject dso, EPerson person, Element permsElement) throws SQLException, AuthorizeException {
        int actionID = this.parsePermissions(permsElement);
        if (actionID < 0) {
            log.warn((Object)("Unable to properly restore all access permissions on object (type=" + Constants.typeText[dso.getType()] + ", " + "handle=" + dso.getHandle() + ", " + "ID=" + dso.getID() + ") for person '" + person.getEmail() + "'."));
        }
        AuthorizeManager.addPolicy(context, dso, actionID, person);
    }

    private int parsePermissions(Element permsElement) {
        String otherPermitType = permsElement.getAttributeValue("OTHERPERMITTYPE");
        if (otherPermitType != null && !otherPermitType.isEmpty()) {
            if (otherTypesMapping.containsValue(otherPermitType)) {
                for (int actionType : otherTypesMapping.keySet()) {
                    if (!otherTypesMapping.get(actionType).equals(otherPermitType)) continue;
                    return actionType;
                }
            } else {
                log.warn((Object)("Unrecognized @OTHERPERMITTYPE attribute value (" + otherPermitType + ") found in METSRights section of METS Manifest."));
            }
        } else {
            boolean discoverPermit = Boolean.parseBoolean(permsElement.getAttributeValue("DISCOVER"));
            boolean displayPermit = Boolean.parseBoolean(permsElement.getAttributeValue("DISPLAY"));
            boolean modifyPermit = Boolean.parseBoolean(permsElement.getAttributeValue("MODIFY"));
            boolean deletePermit = Boolean.parseBoolean(permsElement.getAttributeValue("DELETE"));
            boolean otherPermit = Boolean.parseBoolean(permsElement.getAttributeValue("OTHER"));
            if (deletePermit && !otherPermit) {
                return 2;
            }
            if (modifyPermit && !otherPermit) {
                return 1;
            }
            if (discoverPermit && displayPermit && !otherPermit) {
                return 0;
            }
        }
        return -1;
    }

    static {
        otherTypesMapping.put(3, "ADD CONTENTS");
        otherTypesMapping.put(4, "REMOVE CONTENTS");
        otherTypesMapping.put(11, "ADMIN");
        otherTypesMapping.put(9, "READ FILE CONTENTS");
        otherTypesMapping.put(10, "READ ITEM CONTENTS");
    }
}

