/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.packager;

import edu.harvard.hul.ois.mets.AmdSec;
import edu.harvard.hul.ois.mets.BinData;
import edu.harvard.hul.ois.mets.Checksumtype;
import edu.harvard.hul.ois.mets.DigiprovMD;
import edu.harvard.hul.ois.mets.Div;
import edu.harvard.hul.ois.mets.DmdSec;
import edu.harvard.hul.ois.mets.FLocat;
import edu.harvard.hul.ois.mets.FileGrp;
import edu.harvard.hul.ois.mets.FileSec;
import edu.harvard.hul.ois.mets.Fptr;
import edu.harvard.hul.ois.mets.Loctype;
import edu.harvard.hul.ois.mets.MdRef;
import edu.harvard.hul.ois.mets.MdWrap;
import edu.harvard.hul.ois.mets.Mdtype;
import edu.harvard.hul.ois.mets.Mets;
import edu.harvard.hul.ois.mets.MetsHdr;
import edu.harvard.hul.ois.mets.Mptr;
import edu.harvard.hul.ois.mets.RightsMD;
import edu.harvard.hul.ois.mets.SourceMD;
import edu.harvard.hul.ois.mets.StructMap;
import edu.harvard.hul.ois.mets.TechMD;
import edu.harvard.hul.ois.mets.XmlData;
import edu.harvard.hul.ois.mets.helper.Base64;
import edu.harvard.hul.ois.mets.helper.MdSec;
import edu.harvard.hul.ois.mets.helper.MetsElement;
import edu.harvard.hul.ois.mets.helper.MetsException;
import edu.harvard.hul.ois.mets.helper.MetsValidator;
import edu.harvard.hul.ois.mets.helper.MetsWriter;
import edu.harvard.hul.ois.mets.helper.PreformedXML;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.log4j.Logger;
import org.dspace.app.util.Util;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.ItemIterator;
import org.dspace.content.crosswalk.AbstractPackagerWrappingCrosswalk;
import org.dspace.content.crosswalk.CrosswalkException;
import org.dspace.content.crosswalk.CrosswalkObjectNotSupported;
import org.dspace.content.crosswalk.DisseminationCrosswalk;
import org.dspace.content.crosswalk.StreamDisseminationCrosswalk;
import org.dspace.content.packager.AbstractPackageDisseminator;
import org.dspace.content.packager.PackageParameters;
import org.dspace.content.packager.PackageUtils;
import org.dspace.content.packager.PackageValidationException;
import org.dspace.core.Constants;
import org.dspace.core.Context;
import org.dspace.core.PluginManager;
import org.dspace.core.Utils;
import org.dspace.license.CreativeCommons;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public abstract class AbstractMETSDisseminator
extends AbstractPackageDisseminator {
    private static Logger log = Logger.getLogger(AbstractMETSDisseminator.class);
    private static XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
    private int idCounter = 1;
    private static final int DEFAULT_MODIFIED_DATE = 1280881664;

    protected synchronized String gensym(String prefix) {
        return prefix + "_" + String.valueOf(this.idCounter++);
    }

    @Override
    public String getMIMEType(PackageParameters params) {
        return params != null && params.getBooleanProperty("manifestOnly", false) ? "text/xml" : "application/zip";
    }

    @Override
    public void disseminate(Context context, DSpaceObject dso, PackageParameters params, File pkgFile) throws PackageValidationException, CrosswalkException, AuthorizeException, SQLException, IOException {
        FileOutputStream outStream = null;
        try {
            if (!pkgFile.exists()) {
                PackageUtils.createFile(pkgFile);
            }
            outStream = new FileOutputStream(pkgFile);
            if (params != null && params.getBooleanProperty("manifestOnly", false)) {
                Mets manifest = this.makeManifest(context, dso, params, null);
                manifest.validate(new MetsValidator());
                manifest.write(new MetsWriter((OutputStream)outStream));
            } else {
                this.writeZipPackage(context, dso, params, outStream);
            }
        }
        catch (MetsException e) {
            log.error((Object)"METS error: ", (Throwable)e);
            throw new PackageValidationException((Exception)((Object)e));
        }
        finally {
            if (outStream != null) {
                outStream.close();
            }
        }
    }

    protected void writeZipPackage(Context context, DSpaceObject dso, PackageParameters params, OutputStream pkg) throws PackageValidationException, CrosswalkException, MetsException, AuthorizeException, SQLException, IOException {
        long lmTime = 0L;
        if (dso.getType() == 2) {
            lmTime = ((Item)dso).getLastModified().getTime();
        }
        MdStreamCache extraStreams = new MdStreamCache();
        ZipOutputStream zip = new ZipOutputStream(pkg);
        zip.setComment("METS archive created by DSpace " + Util.getSourceVersion());
        Mets manifest = this.makeManifest(context, dso, params, extraStreams);
        if (extraStreams != null) {
            for (Map.Entry<MdRef, InputStream> ment : extraStreams.getMap().entrySet()) {
                MdRef ref = ment.getKey();
                this.linkLicenseRefsToBitstreams(context, params, dso, ref);
                if (ref.getXlinkHref() != null && !ref.getXlinkHref().isEmpty()) continue;
                InputStream is = ment.getValue();
                String fname = this.gensym("metadata");
                ref.setXlinkHref(fname);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Writing EXTRA stream to Zip: " + fname));
                }
                ZipEntry ze = new ZipEntry(fname);
                if (lmTime != 0L) {
                    ze.setTime(lmTime);
                } else {
                    ze.setTime(1280881664L);
                }
                zip.putNextEntry(ze);
                Utils.copy(is, zip);
                zip.closeEntry();
                is.close();
            }
        }
        ZipEntry me = new ZipEntry("mets.xml");
        if (lmTime != 0L) {
            me.setTime(lmTime);
        } else {
            me.setTime(1280881664L);
        }
        zip.putNextEntry(me);
        manifest.validate(new MetsValidator());
        manifest.write(new MetsWriter((OutputStream)zip));
        zip.closeEntry();
        this.addBitstreamsToZip(context, dso, params, zip);
        zip.close();
    }

    protected void addBitstreamsToZip(Context context, DSpaceObject dso, PackageParameters params, ZipOutputStream zip) throws PackageValidationException, AuthorizeException, SQLException, IOException {
        String unauth;
        String string = unauth = params == null ? null : params.getProperty("unauthorized");
        if (dso.getType() == 2) {
            Item item = (Item)dso;
            long lmTime = ((Item)dso).getLastModified().getTime();
            Bundle[] bundles = item.getBundles();
            for (int i = 0; i < bundles.length; ++i) {
                if (!this.includeBundle(bundles[i])) continue;
                if (!AuthorizeManager.authorizeActionBoolean(context, bundles[i], 0)) {
                    if (unauth != null && unauth.equalsIgnoreCase("skip")) {
                        log.warn((Object)("Skipping Bundle[\"" + bundles[i].getName() + "\"] because you are not authorized to read it."));
                        continue;
                    }
                    throw new AuthorizeException("Not authorized to read Bundle named \"" + bundles[i].getName() + "\"");
                }
                Bitstream[] bitstreams = bundles[i].getBitstreams();
                for (int k = 0; k < bitstreams.length; ++k) {
                    boolean auth = AuthorizeManager.authorizeActionBoolean(context, bitstreams[k], 0);
                    if (auth || unauth != null && unauth.equalsIgnoreCase("zero")) {
                        String zname = this.makeBitstreamURL(bitstreams[k], params);
                        ZipEntry ze = new ZipEntry(zname);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Writing CONTENT stream of bitstream(" + bitstreams[k].getID() + ") to Zip: " + zname + ", size=" + bitstreams[k].getSize()));
                        }
                        if (lmTime != 0L) {
                            ze.setTime(lmTime);
                        } else {
                            ze.setTime(1280881664L);
                        }
                        ze.setSize(auth ? bitstreams[k].getSize() : 0L);
                        zip.putNextEntry(ze);
                        if (auth) {
                            Utils.copy(bitstreams[k].retrieve(), zip);
                        } else {
                            log.warn((Object)("Adding zero-length file for Bitstream, SID=" + String.valueOf(bitstreams[k].getSequenceID()) + ", not authorized for READ."));
                        }
                        zip.closeEntry();
                        continue;
                    }
                    if (unauth != null && unauth.equalsIgnoreCase("skip")) {
                        log.warn((Object)("Skipping Bitstream, SID=" + String.valueOf(bitstreams[k].getSequenceID()) + ", not authorized for READ."));
                        continue;
                    }
                    throw new AuthorizeException("Not authorized to read Bitstream, SID=" + String.valueOf(bitstreams[k].getSequenceID()));
                }
            }
        } else if (dso.getType() == 3 || dso.getType() == 4) {
            Bitstream logoBs;
            Bitstream bitstream = logoBs = dso.getType() == 3 ? ((Collection)dso).getLogo() : ((Community)dso).getLogo();
            if (logoBs != null) {
                String zname = this.makeBitstreamURL(logoBs, params);
                ZipEntry ze = new ZipEntry(zname);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Writing CONTENT stream of bitstream(" + String.valueOf(logoBs.getID()) + ") to Zip: " + zname + ", size=" + String.valueOf(logoBs.getSize())));
                }
                ze.setSize(logoBs.getSize());
                ze.setTime(1280881664L);
                zip.putNextEntry(ze);
                Utils.copy(logoBs.retrieve(), zip);
                zip.closeEntry();
            }
        }
    }

    protected void setMdType(MdWrap mdWrap, String mdtype) {
        try {
            mdWrap.setMDTYPE(Mdtype.parse((String)mdtype));
        }
        catch (MetsException e) {
            mdWrap.setMDTYPE(Mdtype.OTHER);
            mdWrap.setOTHERMDTYPE(mdtype);
        }
    }

    protected void setMdType(MdRef mdRef, String mdtype) {
        try {
            mdRef.setMDTYPE(Mdtype.parse((String)mdtype));
        }
        catch (MetsException e) {
            mdRef.setMDTYPE(Mdtype.OTHER);
            mdRef.setOTHERMDTYPE(mdtype);
        }
    }

    protected MdSec makeMdSec(Context context, DSpaceObject dso, Class mdSecClass, String typeSpec, PackageParameters params, MdStreamCache extraStreams) throws SQLException, PackageValidationException, CrosswalkException, IOException, AuthorizeException {
        try {
            String xwalkName;
            String metsName;
            MdSec mdSec = (MdSec)mdSecClass.newInstance();
            mdSec.setID(this.gensym(mdSec.getLocalName()));
            String[] parts = typeSpec.split(":", 2);
            if (parts.length > 1) {
                metsName = parts[0];
                xwalkName = parts[1];
            } else {
                metsName = typeSpec;
                xwalkName = typeSpec;
            }
            boolean xwalkFound = PluginManager.hasNamedPlugin(DisseminationCrosswalk.class, xwalkName);
            if (xwalkFound) {
                DisseminationCrosswalk xwalk = (DisseminationCrosswalk)PluginManager.getNamedPlugin(DisseminationCrosswalk.class, xwalkName);
                if (xwalk.canDisseminate(dso)) {
                    if (xwalk instanceof AbstractPackagerWrappingCrosswalk) {
                        AbstractPackagerWrappingCrosswalk wrapper = (AbstractPackagerWrappingCrosswalk)((Object)xwalk);
                        wrapper.setPackagingParameters(params);
                    }
                    MdWrap mdWrap = new MdWrap();
                    this.setMdType(mdWrap, metsName);
                    XmlData xmlData = new XmlData();
                    if (this.crosswalkToMetsElement(xwalk, dso, (MetsElement)xmlData) != null) {
                        mdWrap.getContent().add(xmlData);
                        mdSec.getContent().add(mdWrap);
                        return mdSec;
                    }
                    return null;
                }
                return null;
            }
            StreamDisseminationCrosswalk sxwalk = (StreamDisseminationCrosswalk)PluginManager.getNamedPlugin(StreamDisseminationCrosswalk.class, xwalkName);
            if (sxwalk != null) {
                if (sxwalk.canDisseminate(context, dso)) {
                    if (sxwalk instanceof AbstractPackagerWrappingCrosswalk) {
                        AbstractPackagerWrappingCrosswalk wrapper = (AbstractPackagerWrappingCrosswalk)((Object)sxwalk);
                        wrapper.setPackagingParameters(params);
                    }
                    ByteArrayOutputStream disseminateOutput = new ByteArrayOutputStream();
                    sxwalk.disseminate(context, dso, disseminateOutput);
                    ByteArrayInputStream crosswalkedStream = new ByteArrayInputStream(disseminateOutput.toByteArray());
                    if (extraStreams != null) {
                        MdRef mdRef = new MdRef();
                        extraStreams.addStream(mdRef, crosswalkedStream);
                        mdRef.setMIMETYPE(sxwalk.getMIMEType());
                        this.setMdType(mdRef, metsName);
                        mdRef.setLOCTYPE(Loctype.URL);
                        mdSec.getContent().add(mdRef);
                    } else {
                        MdWrap mdWrap = new MdWrap();
                        mdWrap.setMIMETYPE(sxwalk.getMIMEType());
                        this.setMdType(mdWrap, metsName);
                        BinData binData = new BinData();
                        Base64 base64 = new Base64((InputStream)crosswalkedStream);
                        binData.getContent().add(base64);
                        mdWrap.getContent().add(binData);
                        mdSec.getContent().add(mdWrap);
                    }
                    return mdSec;
                }
                return null;
            }
            throw new PackageValidationException("Cannot find " + xwalkName + " crosswalk plugin, either DisseminationCrosswalk or StreamDisseminationCrosswalk");
        }
        catch (InstantiationException e) {
            throw new PackageValidationException("Error instantiating Mdsec object: " + e.toString(), e);
        }
        catch (IllegalAccessException e) {
            throw new PackageValidationException("Error instantiating Mdsec object: " + e.toString(), e);
        }
    }

    protected void addToAmdSec(AmdSec fAmdSec, String[] mdTypes, Class mdSecClass, Context context, DSpaceObject dso, PackageParameters params, MdStreamCache extraStreams) throws SQLException, PackageValidationException, CrosswalkException, IOException, AuthorizeException {
        for (int i = 0; i < mdTypes.length; ++i) {
            MdSec md = this.makeMdSec(context, dso, mdSecClass, mdTypes[i], params, extraStreams);
            if (md == null) continue;
            fAmdSec.getContent().add(md);
        }
    }

    protected String addAmdSec(Context context, DSpaceObject dso, PackageParameters params, Mets mets, MdStreamCache extraStreams) throws SQLException, PackageValidationException, CrosswalkException, IOException, AuthorizeException {
        String[] digiprovMdTypes;
        String[] techMdTypes = this.getTechMdTypes(context, dso, params);
        String[] rightsMdTypes = this.getRightsMdTypes(context, dso, params);
        String[] sourceMdTypes = this.getSourceMdTypes(context, dso, params);
        if (techMdTypes.length + sourceMdTypes.length + (digiprovMdTypes = this.getDigiprovMdTypes(context, dso, params)).length + rightsMdTypes.length > 0) {
            String result = this.gensym("amd");
            AmdSec fAmdSec = new AmdSec();
            fAmdSec.setID(result);
            this.addToAmdSec(fAmdSec, techMdTypes, TechMD.class, context, dso, params, extraStreams);
            this.addToAmdSec(fAmdSec, rightsMdTypes, RightsMD.class, context, dso, params, extraStreams);
            this.addToAmdSec(fAmdSec, sourceMdTypes, SourceMD.class, context, dso, params, extraStreams);
            this.addToAmdSec(fAmdSec, digiprovMdTypes, DigiprovMD.class, context, dso, params, extraStreams);
            mets.getContent().add(fAmdSec);
            return result;
        }
        return null;
    }

    protected String makePersistentID(DSpaceObject dso) {
        String handle = dso.getHandle();
        if (handle == null) {
            return "DSpace_DB_" + Constants.typeText[dso.getType()] + "_" + String.valueOf(dso.getID());
        }
        return this.getHandleURN(handle);
    }

    protected Mets makeManifest(Context context, DSpaceObject dso, PackageParameters params, MdStreamCache extraStreams) throws MetsException, PackageValidationException, CrosswalkException, AuthorizeException, SQLException, IOException {
        Div childDiv;
        Mets mets = new Mets();
        String identifier = "DB-ID-" + dso.getID();
        if (dso.getHandle() != null) {
            identifier = dso.getHandle().replace('/', '-');
        }
        mets.setID("DSpace_" + Constants.typeText[dso.getType()] + "_" + identifier);
        mets.setOBJID(this.makePersistentID(dso));
        mets.setTYPE(this.getObjectTypeString(dso));
        mets.setPROFILE(this.getProfile());
        MetsHdr metsHdr = this.makeMetsHdr(context, dso, params);
        if (metsHdr != null) {
            mets.getContent().add(metsHdr);
        }
        String[] dmdTypes = this.getDmdTypes(context, dso, params);
        String[] dmdId = new String[dmdTypes.length];
        for (int i = 0; i < dmdTypes.length; ++i) {
            MdSec dmdSec = this.makeMdSec(context, dso, DmdSec.class, dmdTypes[i], params, extraStreams);
            if (dmdSec == null) continue;
            mets.getContent().add(dmdSec);
            dmdId[i] = dmdSec.getID();
        }
        String objectAMDID = this.addAmdSec(context, dso, params, mets, extraStreams);
        StructMap structMap = new StructMap();
        structMap.setID(this.gensym("struct"));
        structMap.setTYPE("LOGICAL");
        structMap.setLABEL("DSpace Object");
        Div div0 = new Div();
        div0.setID(this.gensym("div"));
        div0.setTYPE("DSpace Object Contents");
        structMap.getContent().add(div0);
        FileSec fileSec = null;
        if (dso.getType() == 2) {
            String bitstreamIDstart = "bitstream_";
            Item item = (Item)dso;
            String unauth = params == null ? null : params.getProperty("unauthorized");
            fileSec = new FileSec();
            Bundle[] bundles = item.getBundles();
            for (int i = 0; i < bundles.length; ++i) {
                String techBundID;
                if (!this.includeBundle(bundles[i])) continue;
                if (!AuthorizeManager.authorizeActionBoolean(context, bundles[i], 0)) {
                    if (unauth != null && unauth.equalsIgnoreCase("skip")) continue;
                    throw new AuthorizeException("Not authorized to read Bundle named \"" + bundles[i].getName() + "\"");
                }
                Bitstream[] bitstreams = bundles[i].getBitstreams();
                FileGrp fileGrp = new FileGrp();
                String bName = bundles[i].getName();
                if (bName != null && !bName.equals("")) {
                    fileGrp.setUSE(this.bundleToFileGrp(bName));
                }
                if ((techBundID = this.addAmdSec(context, bundles[i], params, mets, extraStreams)) != null) {
                    fileGrp.setADMID(techBundID);
                }
                int primaryBitstreamID = -1;
                boolean isContentBundle = false;
                if (bName != null && bName.equals("ORIGINAL")) {
                    isContentBundle = true;
                    primaryBitstreamID = bundles[i].getPrimaryBitstreamID();
                }
                for (int bits = 0; bits < bitstreams.length; ++bits) {
                    Bitstream original;
                    boolean auth = AuthorizeManager.authorizeActionBoolean(context, bitstreams[bits], 0);
                    if (!auth) {
                        if (unauth != null && unauth.equalsIgnoreCase("skip")) continue;
                        if (unauth == null || !unauth.equalsIgnoreCase("zero")) {
                            throw new AuthorizeException("Not authorized to read Bitstream, SID=" + String.valueOf(bitstreams[bits].getSequenceID()));
                        }
                    }
                    String sid = String.valueOf(bitstreams[bits].getSequenceID());
                    String fileID = bitstreamIDstart + sid;
                    edu.harvard.hul.ois.mets.File file = new edu.harvard.hul.ois.mets.File();
                    file.setID(fileID);
                    file.setSEQ(bitstreams[bits].getSequenceID());
                    fileGrp.getContent().add(file);
                    if (bitstreams[bits].getID() == primaryBitstreamID) {
                        Fptr fptr = new Fptr();
                        fptr.setFILEID(fileID);
                        div0.getContent().add(0, fptr);
                    }
                    if (isContentBundle) {
                        div0.getContent().add(this.makeFileDiv(fileID, this.getObjectTypeString(bitstreams[bits])));
                    }
                    String groupID = "GROUP_" + bitstreamIDstart + sid;
                    if (bundles[i].getName() != null && (bundles[i].getName().equals("THUMBNAIL") || bundles[i].getName().startsWith("TEXT")) && (original = AbstractMETSDisseminator.findOriginalBitstream(item, bitstreams[bits])) != null) {
                        groupID = "GROUP_" + bitstreamIDstart + original.getSequenceID();
                    }
                    file.setGROUPID(groupID);
                    file.setMIMETYPE(bitstreams[bits].getFormat().getMIMEType());
                    file.setSIZE(auth ? bitstreams[bits].getSize() : 0L);
                    String csType = bitstreams[bits].getChecksumAlgorithm();
                    String cs = bitstreams[bits].getChecksum();
                    if (auth && cs != null && csType != null) {
                        try {
                            file.setCHECKSUMTYPE(Checksumtype.parse((String)csType));
                            file.setCHECKSUM(cs);
                        }
                        catch (MetsException e) {
                            log.warn((Object)("Cannot set bitstream checksum type=" + csType + " in METS."));
                        }
                    }
                    FLocat flocat = new FLocat();
                    flocat.setLOCTYPE(Loctype.URL);
                    flocat.setXlinkHref(this.makeBitstreamURL(bitstreams[bits], params));
                    file.getContent().add(flocat);
                    String techID = this.addAmdSec(context, bitstreams[bits], params, mets, extraStreams);
                    if (techID == null) continue;
                    file.setADMID(techID);
                }
                fileSec.getContent().add(fileGrp);
            }
        } else if (dso.getType() == 3) {
            ItemIterator ii = ((Collection)dso).getItems();
            while (ii.hasNext()) {
                Item item = ii.next();
                childDiv = this.makeChildDiv(this.getObjectTypeString(item), item, params);
                if (childDiv == null) continue;
                div0.getContent().add(childDiv);
            }
            Bitstream logoBs = ((Collection)dso).getLogo();
            if (logoBs != null) {
                fileSec = new FileSec();
                this.addLogoBitstream(logoBs, fileSec, div0, params);
            }
        } else if (dso.getType() == 4) {
            Community[] subcomms = ((Community)dso).getSubcommunities();
            for (int i = 0; i < subcomms.length; ++i) {
                Div childDiv2 = this.makeChildDiv(this.getObjectTypeString(subcomms[i]), subcomms[i], params);
                if (childDiv2 == null) continue;
                div0.getContent().add(childDiv2);
            }
            Collection[] colls = ((Community)dso).getCollections();
            for (int i = 0; i < colls.length; ++i) {
                Div childDiv3 = this.makeChildDiv(this.getObjectTypeString(colls[i]), colls[i], params);
                if (childDiv3 == null) continue;
                div0.getContent().add(childDiv3);
            }
            Bitstream logoBs = ((Community)dso).getLogo();
            if (logoBs != null) {
                fileSec = new FileSec();
                this.addLogoBitstream(logoBs, fileSec, div0, params);
            }
        } else if (dso.getType() == 5) {
            Community[] comms = Community.findAllTop(context);
            for (int i = 0; i < comms.length; ++i) {
                childDiv = this.makeChildDiv(this.getObjectTypeString(comms[i]), comms[i], params);
                if (childDiv == null) continue;
                div0.getContent().add(childDiv);
            }
        }
        if (fileSec != null) {
            mets.getContent().add(fileSec);
        }
        mets.getContent().add(structMap);
        StringBuilder dmdIds = new StringBuilder();
        for (String currdmdId : dmdId) {
            dmdIds.append(" ").append(currdmdId);
        }
        div0.setDMDID(dmdIds.substring(1));
        if (objectAMDID != null) {
            div0.setADMID(objectAMDID);
        }
        this.addStructMap(context, dso, params, mets);
        return mets;
    }

    protected void addLogoBitstream(Bitstream logoBs, FileSec fileSec, Div div0, PackageParameters params) {
        edu.harvard.hul.ois.mets.File file = new edu.harvard.hul.ois.mets.File();
        String fileID = this.gensym("logo");
        file.setID(fileID);
        file.setMIMETYPE(logoBs.getFormat().getMIMEType());
        file.setSIZE(logoBs.getSize());
        String csType = logoBs.getChecksumAlgorithm();
        String cs = logoBs.getChecksum();
        if (cs != null && csType != null) {
            try {
                file.setCHECKSUMTYPE(Checksumtype.parse((String)csType));
                file.setCHECKSUM(cs);
            }
            catch (MetsException e) {
                log.warn((Object)("Cannot set bitstream checksum type=" + csType + " in METS."));
            }
        }
        FLocat flocat = new FLocat();
        flocat.setLOCTYPE(Loctype.URL);
        flocat.setXlinkHref(this.makeBitstreamURL(logoBs, params));
        file.getContent().add(flocat);
        FileGrp fileGrp = new FileGrp();
        fileGrp.setUSE("LOGO");
        fileGrp.getContent().add(file);
        fileSec.getContent().add(fileGrp);
        Fptr fptr = new Fptr();
        fptr.setFILEID(fileID);
        div0.getContent().add(0, fptr);
    }

    protected Div makeFileDiv(String fileID, String type) {
        Div div = new Div();
        div.setID(this.gensym("div"));
        div.setTYPE(type);
        Fptr fptr = new Fptr();
        fptr.setFILEID(fileID);
        div.getContent().add(fptr);
        return div;
    }

    protected Div makeChildDiv(String type, DSpaceObject dso, PackageParameters params) {
        String handle = dso.getHandle();
        Div div = new Div();
        div.setID(this.gensym("div"));
        div.setTYPE(type);
        boolean emptyDiv = true;
        if (handle == null || handle.length() == 0) {
            log.warn((Object)("METS Disseminator is skipping " + type + " without handle: " + dso.toString()));
        } else {
            Mptr mptr = new Mptr();
            mptr.setID(this.gensym("mptr"));
            mptr.setLOCTYPE(Loctype.HANDLE);
            mptr.setXlinkHref(handle);
            div.getContent().add(mptr);
            emptyDiv = false;
        }
        if (params.recursiveModeEnabled()) {
            String childFileExtension = params.getBooleanProperty("manifestOnly", false) ? "xml" : "zip";
            Mptr mptr2 = new Mptr();
            mptr2.setID(this.gensym("mptr"));
            mptr2.setLOCTYPE(Loctype.URL);
            mptr2.setXlinkHref(PackageUtils.getPackageName(dso, childFileExtension));
            div.getContent().add(mptr2);
            emptyDiv = false;
        }
        if (emptyDiv) {
            return null;
        }
        return div;
    }

    protected String getHandleURN(String handle) {
        if (handle.startsWith("hdl:")) {
            return handle;
        }
        return "hdl:" + handle;
    }

    protected static Bitstream findOriginalBitstream(Item item, Bitstream derived) throws SQLException {
        Bundle[] bundles = item.getBundles();
        String originalFilename = derived.getName().substring(0, derived.getName().length() - 4);
        for (int i = 0; i < bundles.length; ++i) {
            if (bundles[i].getName() == null || !bundles[i].getName().equals("ORIGINAL")) continue;
            Bitstream[] bitstreams = bundles[i].getBitstreams();
            for (int bsnum = 0; bsnum < bitstreams.length; ++bsnum) {
                if (!bitstreams[bsnum].getName().equals(originalFilename)) continue;
                return bitstreams[bsnum];
            }
        }
        return null;
    }

    private MetsElement crosswalkToMetsElement(DisseminationCrosswalk xwalk, DSpaceObject dso, MetsElement me) throws CrosswalkException, IOException, SQLException, AuthorizeException {
        try {
            Element res;
            String raw = xwalk.getSchemaLocation();
            String[] sloc = raw == null ? null : raw.split("\\s+");
            Namespace[] ns = xwalk.getNamespaces();
            for (int i = 0; i < ns.length; ++i) {
                String uri = ns[i].getURI();
                if (sloc != null && sloc.length > 1 && uri.equals(sloc[0])) {
                    me.setSchema(ns[i].getPrefix(), uri, sloc[1]);
                    continue;
                }
                me.setSchema(ns[i].getPrefix(), uri);
            }
            PreformedXML pXML = null;
            if (xwalk.preferList()) {
                res = xwalk.disseminateList(dso);
                if (res != null && !res.isEmpty()) {
                    pXML = new PreformedXML(outputter.outputString((List)res));
                }
            } else {
                res = xwalk.disseminateElement(dso);
                if (res != null) {
                    pXML = new PreformedXML(outputter.outputString(res));
                }
            }
            if (pXML != null) {
                me.getContent().add(pXML);
                return me;
            }
            return null;
        }
        catch (CrosswalkObjectNotSupported e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Skipping MDsec because of CrosswalkObjectNotSupported: dso=" + dso.toString() + ", xwalk=" + xwalk.getClass().getName()));
            }
            return null;
        }
    }

    protected void linkLicenseRefsToBitstreams(Context context, PackageParameters params, DSpaceObject dso, MdRef mdRef) throws SQLException, IOException, AuthorizeException {
        Item i;
        Bundle[] license;
        if (mdRef.getMDTYPE() != null && mdRef.getMDTYPE() == Mdtype.OTHER && mdRef.getOTHERMDTYPE() != null && mdRef.getOTHERMDTYPE().equals("DSpaceDepositLicense")) {
            Item i2 = (Item)dso;
            Bundle[] license2 = i2.getBundles("LICENSE");
            if (license2 != null && license2.length > 0 && this.includeBundle(license2[0])) {
                Bitstream licenseBs = PackageUtils.findDepositLicense(context, (Item)dso);
                mdRef.setXlinkHref(this.makeBitstreamURL(licenseBs, params));
            }
        } else if (mdRef.getMDTYPE() != null && mdRef.getMDTYPE() == Mdtype.OTHER && mdRef.getOTHERMDTYPE() != null && mdRef.getOTHERMDTYPE().equals("CreativeCommonsText")) {
            Item i3 = (Item)dso;
            Bundle[] license3 = i3.getBundles("CC-LICENSE");
            if (license3 != null && license3.length > 0 && this.includeBundle(license3[0])) {
                Bitstream ccText = CreativeCommons.getLicenseTextBitstream(i3);
                mdRef.setXlinkHref(this.makeBitstreamURL(ccText, params));
            }
        } else if (mdRef.getMDTYPE() != null && mdRef.getMDTYPE() == Mdtype.OTHER && mdRef.getOTHERMDTYPE() != null && mdRef.getOTHERMDTYPE().equals("CreativeCommonsRDF") && (license = (i = (Item)dso).getBundles("CC-LICENSE")) != null && license.length > 0 && this.includeBundle(license[0])) {
            Bitstream ccRdf = CreativeCommons.getLicenseRdfBitstream(i);
            mdRef.setXlinkHref(this.makeBitstreamURL(ccRdf, params));
        }
    }

    public String getObjectTypeString(DSpaceObject dso) {
        return "DSpace " + Constants.typeText[dso.getType()];
    }

    @Override
    public String getParameterHelp() {
        return "* manifestOnly=[boolean]      If true, only export the METS manifest (mets.xml) and don't export content files (defaults to false).\n\n* unauthorized=[value]      If 'skip', skip over any files which the user doesn't have authorization to read. If 'zero', create a zero-length file for any files the user doesn't have authorization to read. By default, an AuthorizationException will be thrown for any files the user cannot read.";
    }

    public abstract String makeBitstreamURL(Bitstream var1, PackageParameters var2);

    public abstract MetsHdr makeMetsHdr(Context var1, DSpaceObject var2, PackageParameters var3);

    public abstract String getProfile();

    public abstract String bundleToFileGrp(String var1);

    public abstract String[] getDmdTypes(Context var1, DSpaceObject var2, PackageParameters var3) throws SQLException, IOException, AuthorizeException;

    public abstract String[] getTechMdTypes(Context var1, DSpaceObject var2, PackageParameters var3) throws SQLException, IOException, AuthorizeException;

    public abstract String[] getSourceMdTypes(Context var1, DSpaceObject var2, PackageParameters var3) throws SQLException, IOException, AuthorizeException;

    public abstract String[] getDigiprovMdTypes(Context var1, DSpaceObject var2, PackageParameters var3) throws SQLException, IOException, AuthorizeException;

    public abstract String[] getRightsMdTypes(Context var1, DSpaceObject var2, PackageParameters var3) throws SQLException, IOException, AuthorizeException;

    public abstract void addStructMap(Context var1, DSpaceObject var2, PackageParameters var3, Mets var4) throws SQLException, IOException, AuthorizeException, MetsException;

    public abstract boolean includeBundle(Bundle var1);

    protected static class MdStreamCache {
        private Map<MdRef, InputStream> extraFiles = new HashMap<MdRef, InputStream>();

        protected MdStreamCache() {
        }

        public void addStream(MdRef key, InputStream md) {
            this.extraFiles.put(key, md);
        }

        public Map<MdRef, InputStream> getMap() {
            return this.extraFiles;
        }

        public void close() throws IOException {
            for (InputStream is : this.extraFiles.values()) {
                is.close();
            }
        }
    }
}

