/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.embargo;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Date;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DCDate;
import org.dspace.content.DCValue;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.ItemIterator;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.PluginManager;
import org.dspace.embargo.EmbargoLifter;
import org.dspace.embargo.EmbargoSetter;
import org.dspace.handle.HandleManager;

public class EmbargoManager {
    public static final DCDate FOREVER = new DCDate("10000-01-01");
    private static Logger log = Logger.getLogger(EmbargoManager.class);
    private static String terms_schema = null;
    private static String terms_element = null;
    private static String terms_qualifier = null;
    private static String lift_schema = null;
    private static String lift_element = null;
    private static String lift_qualifier = null;
    private static EmbargoSetter setter = null;
    private static EmbargoLifter lifter = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setEmbargo(Context context, Item item, DCDate lift) throws SQLException, AuthorizeException, IOException {
        EmbargoManager.init();
        String slift = lift.toString();
        boolean ignoreAuth = context.ignoreAuthorization();
        try {
            context.setIgnoreAuthorization(true);
            item.clearMetadata(lift_schema, lift_element, lift_qualifier, "*");
            item.addMetadata(lift_schema, lift_element, lift_qualifier, null, slift);
            log.info((Object)("Set embargo on Item " + item.getHandle() + ", expires on: " + slift));
            setter.setEmbargo(context, item);
            item.update();
        }
        finally {
            context.setIgnoreAuthorization(ignoreAuth);
        }
    }

    public static DCDate getEmbargoDate(Context context, Item item) throws SQLException, AuthorizeException, IOException {
        EmbargoManager.init();
        DCValue[] terms = item.getMetadata(terms_schema, terms_element, terms_qualifier, "*");
        DCDate result = null;
        if (terms != null && terms.length > 0) {
            result = setter.parseTerms(context, item, terms.length > 0 ? terms[0].value : null);
        }
        if (result != null && result.toDate().before(new Date())) {
            throw new IllegalArgumentException("Embargo lift date must be in the future, but this is in the past: " + result.toString());
        }
        return result;
    }

    public static void liftEmbargo(Context context, Item item) throws SQLException, AuthorizeException, IOException {
        EmbargoManager.init();
        lifter.liftEmbargo(context, item);
        item.clearMetadata(lift_schema, lift_element, lift_qualifier, "*");
        item.clearMetadata("dc", "date", "available", "*");
        item.addMetadata("dc", "date", "available", null, DCDate.getCurrent().toString());
        log.info((Object)("Lifting embargo on Item " + item.getHandle()));
        item.update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) {
        EmbargoManager.init();
        int status = 0;
        Options options = new Options();
        options.addOption("v", "verbose", false, "Print a line describing action taken for each embargoed Item found.");
        options.addOption("q", "quiet", false, "Do not print anything except for errors.");
        options.addOption("n", "dryrun", false, "Do not change anything in the data model, print message instead.");
        options.addOption("i", "identifier", true, "Process ONLY this Handle identifier(s), which must be an Item.  Can be repeated.");
        options.addOption("c", "check", false, "Function: ONLY check the state of embargoed Items, do NOT lift any embargoes.");
        options.addOption("l", "lift", false, "Function: ONLY lift embargoes, do NOT check the state of any embargoed Items.");
        options.addOption("h", "help", false, "help");
        CommandLine line = null;
        try {
            line = new PosixParser().parse(options, argv);
        }
        catch (ParseException e) {
            System.err.println("Command error: " + e.getMessage());
            new HelpFormatter().printHelp(EmbargoManager.class.getName(), options);
            System.exit(1);
        }
        if (line.hasOption('h')) {
            new HelpFormatter().printHelp(EmbargoManager.class.getName(), options);
            System.exit(0);
        }
        if (line.hasOption('l') && line.hasOption('c')) {
            System.err.println("Command error: --lift and --check are mutually exclusive, try --help for assistance.");
            System.exit(1);
        }
        Context context = null;
        try {
            context = new Context();
            context.setIgnoreAuthorization(true);
            Date now = new Date();
            if (line.hasOption('i')) {
                for (String handle : line.getOptionValues('i')) {
                    DSpaceObject dso = HandleManager.resolveToObject(context, handle);
                    if (dso == null) {
                        System.err.println("Error, cannot resolve handle=" + handle + " to a DSpace Item.");
                        status = 1;
                        continue;
                    }
                    if (dso.getType() != 2) {
                        System.err.println("Error, the handle=" + handle + " is not a DSpace Item.");
                        status = 1;
                        continue;
                    }
                    if (!EmbargoManager.processOneItem(context, (Item)dso, line, now)) continue;
                    status = 1;
                }
            } else {
                ItemIterator ii = Item.findByMetadataField(context, lift_schema, lift_element, lift_qualifier, "*");
                while (ii.hasNext()) {
                    if (!EmbargoManager.processOneItem(context, ii.next(), line, now)) continue;
                    status = 1;
                }
            }
            log.debug((Object)("Cache size at end = " + context.getCacheSize()));
            context.complete();
            context = null;
        }
        catch (Exception e) {
            System.err.println("ERROR, got exception: " + e);
            e.printStackTrace();
            status = 1;
        }
        finally {
            if (context != null) {
                try {
                    context.abort();
                }
                catch (Exception e) {}
            }
        }
        System.exit(status);
    }

    private static boolean processOneItem(Context context, Item item, CommandLine line, Date now) throws Exception {
        boolean status = false;
        DCValue[] lift = item.getMetadata(lift_schema, lift_element, lift_qualifier, "*");
        if (lift.length > 0) {
            try {
                DCDate liftDate = new DCDate(lift[0].value);
                log.debug((Object)("Testing embargo on item=" + item.getHandle() + ", date=" + liftDate.toString()));
                if (liftDate.toDate().before(now)) {
                    if (line.hasOption('v')) {
                        System.err.println("Lifting embargo from Item handle=" + item.getHandle() + ", lift date=" + lift[0].value);
                    }
                    if (line.hasOption('n')) {
                        if (!line.hasOption('q')) {
                            System.err.println("DRY RUN: would have lifted embargo from Item handle=" + item.getHandle() + ", lift date=" + lift[0].value);
                        }
                    } else if (!line.hasOption('c')) {
                        EmbargoManager.liftEmbargo(context, item);
                    }
                } else if (!line.hasOption('l')) {
                    if (line.hasOption('v')) {
                        System.err.println("Checking current embargo on Item handle=" + item.getHandle() + ", lift date=" + lift[0].value);
                    }
                    setter.checkEmbargo(context, item);
                }
            }
            catch (Exception e) {
                log.error((Object)("Failed attempting to lift embargo, item=" + item.getHandle() + ": "), (Throwable)e);
                System.err.println("Failed attempting to lift embargo, item=" + item.getHandle() + ": " + e);
                status = true;
            }
        }
        context.removeCached(item, item.getID());
        return status;
    }

    private static void init() {
        if (terms_schema == null) {
            String terms = ConfigurationManager.getProperty("embargo.field.terms");
            String lift = ConfigurationManager.getProperty("embargo.field.lift");
            if (terms == null || lift == null) {
                throw new IllegalStateException("Missing one or more of the required DSpace configuration properties for EmbargoManager, check your configuration file.");
            }
            terms_schema = EmbargoManager.getSchemaOf(terms);
            terms_element = EmbargoManager.getElementOf(terms);
            terms_qualifier = EmbargoManager.getQualifierOf(terms);
            lift_schema = EmbargoManager.getSchemaOf(lift);
            lift_element = EmbargoManager.getElementOf(lift);
            lift_qualifier = EmbargoManager.getQualifierOf(lift);
            setter = (EmbargoSetter)PluginManager.getSinglePlugin(EmbargoSetter.class);
            if (setter == null) {
                throw new IllegalStateException("The EmbargoSetter plugin was not defined in DSpace configuration.");
            }
            lifter = (EmbargoLifter)PluginManager.getSinglePlugin(EmbargoLifter.class);
            if (lifter == null) {
                throw new IllegalStateException("The EmbargoLifter plugin was not defined in DSpace configuration.");
            }
        }
    }

    private static String getSchemaOf(String field) {
        String[] sa = field.split("\\.", 3);
        return sa[0];
    }

    private static String getElementOf(String field) {
        String[] sa = field.split("\\.", 3);
        return sa.length > 1 ? sa[1] : null;
    }

    private static String getQualifierOf(String field) {
        String[] sa = field.split("\\.", 3);
        return sa.length > 2 ? sa[2] : null;
    }
}

