/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.storage.rdbms;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.TableRow;

public class TableRowIterator {
    private static final Logger log = Logger.getLogger(TableRowIterator.class);
    private ResultSet results;
    private Statement statemt = null;
    private String table;
    private boolean hasNext = true;
    private boolean hasAdvanced = false;
    List<String> columnNames = null;

    TableRowIterator(ResultSet results) {
        this(results, null);
        this.statemt = null;
    }

    TableRowIterator(ResultSet results, String table) {
        this(results, table, null);
        this.statemt = null;
    }

    TableRowIterator(ResultSet results, String table, List<String> columnNames) {
        this.results = results;
        this.table = table;
        if (columnNames == null) {
            try {
                this.columnNames = table == null ? DatabaseManager.getColumnNames(results.getMetaData()) : DatabaseManager.getColumnNames(table);
            }
            catch (SQLException e) {
                this.columnNames = null;
            }
        } else {
            this.columnNames = Collections.unmodifiableList(columnNames);
        }
        this.statemt = null;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public void setStatement(Statement st) {
        this.statemt = st;
    }

    public TableRow next() throws SQLException {
        if (this.results == null) {
            return null;
        }
        if (!this.hasNext()) {
            return null;
        }
        this.hasAdvanced = false;
        return DatabaseManager.process(this.results, this.table, this.columnNames);
    }

    public boolean hasNext() throws SQLException {
        if (this.results == null) {
            this.close();
            return false;
        }
        if (this.hasAdvanced) {
            return this.hasNext;
        }
        this.hasAdvanced = true;
        this.hasNext = this.results.next();
        if (!this.hasNext) {
            this.close();
        }
        return this.hasNext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TableRow> toList() throws SQLException {
        ArrayList<TableRow> resultsList = new ArrayList<TableRow>();
        try {
            while (this.hasNext()) {
                resultsList.add(this.next());
            }
        }
        finally {
            this.close();
        }
        return resultsList;
    }

    public void close() {
        try {
            if (this.results != null) {
                this.results.close();
                this.results = null;
            }
        }
        catch (SQLException sqle) {
            // empty catch block
        }
        try {
            if (this.statemt != null) {
                this.statemt.close();
                this.statemt = null;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

