/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.submit.step;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.dspace.app.util.SubmissionInfo;
import org.dspace.app.util.Util;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DCValue;
import org.dspace.content.Item;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.license.CCLookup;
import org.dspace.license.CreativeCommons;
import org.dspace.submit.AbstractProcessingStep;

public class CCLicenseStep
extends AbstractProcessingStep {
    public static final int STATUS_LICENSE_REJECTED = 1;
    private static Logger log = Logger.getLogger(CCLicenseStep.class);
    private CCLookup cclookup = null;
    ArrayList<String> licenseNames = new ArrayList();

    @Override
    public int doProcessing(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo) throws ServletException, IOException, SQLException, AuthorizeException, IOException {
        String buttonPressed = Util.getSubmitButton(request, "submit_next");
        Enumeration e = request.getParameterNames();
        HttpSession session = request.getSession();
        String isFieldRequired = "FALSE";
        while (e.hasMoreElements()) {
            String parameterName = (String)e.nextElement();
            if (!parameterName.equals("button_required")) continue;
            isFieldRequired = "TRUE";
            break;
        }
        session.setAttribute("isFieldRequired", (Object)isFieldRequired);
        if (buttonPressed.startsWith("submit_jump_") || buttonPressed.equals("submit_prev")) {
            this.removeRequiredAttributes(session);
        }
        if (buttonPressed.equals("submit_next") || buttonPressed.equals("submit_cancel")) {
            return this.processCC(context, request, response, subInfo);
        }
        return 0;
    }

    protected int processCC(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo) throws ServletException, IOException, SQLException, AuthorizeException {
        String jurisdiction;
        String ccLicenseUrl = request.getParameter("cc_license_url");
        HttpSession session = request.getSession();
        HashMap<String, String> map = new HashMap<String, String>();
        String licenseclass = request.getParameter("licenseclass_chooser") != null ? request.getParameter("licenseclass_chooser") : "";
        String string = jurisdiction = ConfigurationManager.getProperty("webui.submit.cc-jurisdiction") != null ? ConfigurationManager.getProperty("webui.submit.cc-jurisdiction") : "";
        if (licenseclass.equals("standard")) {
            map.put("commercial", request.getParameter("commercial_chooser"));
            map.put("derivatives", request.getParameter("derivatives_chooser"));
        } else if (licenseclass.equals("recombo")) {
            map.put("sampling", request.getParameter("sampling_chooser"));
        }
        map.put("jurisdiction", jurisdiction);
        this.cclookup = new CCLookup();
        this.cclookup.issue(licenseclass, map, ConfigurationManager.getProperty("default.locale"));
        Item item = subInfo.getSubmissionItem().getItem();
        if (licenseclass.equals("xmlui.Submission.submit.CCLicenseStep.no_license")) {
            if (CreativeCommons.hasLicense(item, "dc", "rights", "uri", "*")) {
                CreativeCommons.removeLicenseMetadata(item, "dc", "rights", "uri", "*");
                item.update();
                context.commit();
                this.removeRequiredAttributes(session);
            }
            return 0;
        }
        if (licenseclass.equals("xmlui.Submission.submit.CCLicenseStep.select_change")) {
            this.removeRequiredAttributes(session);
            return 0;
        }
        if (this.cclookup.isSuccess()) {
            this.setItemMetadata(item, this.cclookup.getLicenseUrl(), "dc", "rights", "uri", ConfigurationManager.getProperty("default.locale"));
            if (ConfigurationManager.getBooleanProperty("webui.submit.include.cc-name")) {
                this.setItemMetadata(item, this.cclookup.getLicenseName(), "dc", "rights", null, ConfigurationManager.getProperty("default.locale"));
            }
        } else {
            request.getSession().setAttribute("ccError", (Object)this.cclookup.getErrorMessage());
            if (CreativeCommons.hasLicense(item, "dc", "rights", "uri", "*")) {
                CreativeCommons.removeLicenseMetadata(item, "dc", "rights", "uri", "*");
            }
            return 1;
        }
        item.update();
        context.commit();
        this.removeRequiredAttributes(session);
        return 0;
    }

    private void removeRequiredAttributes(HttpSession session) {
        session.removeAttribute("ccError");
        session.removeAttribute("isFieldRequired");
    }

    private void setItemMetadata(Item item, String license, String schema, String element, String qualifier, String lang) throws SQLException, IOException, AuthorizeException {
        DCValue[] dcvalues = item.getMetadata(schema, element, qualifier, lang);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (DCValue dcvalue : dcvalues) {
            boolean isUri;
            boolean bl = isUri = qualifier != null;
            if (!this.addDCValue(dcvalue.value, isUri)) continue;
            arrayList.add(dcvalue.value);
        }
        String[] licenses = arrayList.toArray(new String[arrayList.size()]);
        CreativeCommons.removeLicenseMetadata(item, schema, element, qualifier, "*");
        item.addMetadata(schema, element, qualifier, lang, licenses);
        item.addMetadata(schema, element, qualifier, lang, license);
    }

    private boolean addDCValue(String metavalue, boolean isUri) throws IOException {
        if (isUri) {
            if (metavalue.indexOf("creativecommons") != -1) {
                CCLookup cclookup = new CCLookup();
                cclookup.issue(metavalue);
                this.licenseNames.add(cclookup.getLicenseName());
                return false;
            }
        } else if (this.licenseNames.contains(metavalue)) {
            return false;
        }
        return true;
    }

    @Override
    public int getNumberOfPages(HttpServletRequest request, SubmissionInfo subInfo) throws ServletException {
        return 1;
    }
}

