/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.itemupdate;

import java.text.ParseException;
import org.dspace.app.itemupdate.MetadataUtilities;

class DtoMetadata {
    final String schema;
    final String element;
    final String qualifier;
    final String language;
    final String value;

    private DtoMetadata(String schema, String element, String qualifier, String language, String value) {
        this.schema = schema;
        this.element = element;
        this.qualifier = qualifier;
        this.language = language;
        this.value = value;
    }

    public static DtoMetadata create(String schema, String element, String qualifier, String language, String value) throws IllegalArgumentException {
        if (qualifier != null && (qualifier.equals("*") || qualifier.equals(""))) {
            throw new IllegalArgumentException("Invalid qualifier: " + qualifier);
        }
        return new DtoMetadata(schema, element, qualifier, language, value);
    }

    public static DtoMetadata create(String compoundForm, String language, String value) throws ParseException, IllegalArgumentException {
        String[] ar = MetadataUtilities.parseCompoundForm(compoundForm);
        String qual = null;
        if (ar.length > 2) {
            qual = ar[2];
        }
        return DtoMetadata.create(ar[0], ar[1], qual, language, value);
    }

    public boolean matches(String compoundForm, boolean wildcard) {
        String[] ar = compoundForm.split("\\s*\\.\\s*");
        if (ar.length < 2 || ar.length > 3) {
            return false;
        }
        if (!this.schema.equals(ar[0]) || !this.element.equals(ar[1])) {
            return false;
        }
        if (ar.length == 2 && this.qualifier != null) {
            return false;
        }
        if (ar.length == 3) {
            if (this.qualifier == null) {
                return false;
            }
            if (wildcard && ar[2].equals("*")) {
                return true;
            }
            if (!this.qualifier.equals(ar[2])) {
                return false;
            }
        }
        return true;
    }

    public String toString() {
        String s = "\tSchema: " + this.schema + " Element: " + this.element;
        if (this.qualifier != null) {
            s = s + " Qualifier: " + this.qualifier;
        }
        s = s + " Language: " + (this.language == null ? "[null]" : this.language);
        s = s + " Value: " + this.value;
        return s;
    }

    public String getValue() {
        return this.value;
    }
}

