/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.dspace.app.util.DCInput;

public class DCInputSet {
    private String formName = null;
    private DCInput[][] inputPages = null;

    public DCInputSet(String formName, List<List<Map<String, String>>> pages, Map<String, List<String>> listMap) {
        this.formName = formName;
        this.inputPages = new DCInput[pages.size()][];
        for (int i = 0; i < this.inputPages.length; ++i) {
            List<Map<String, String>> page = pages.get(i);
            this.inputPages[i] = new DCInput[page.size()];
            for (int j = 0; j < this.inputPages[i].length; ++j) {
                this.inputPages[i][j] = new DCInput(page.get(j), listMap);
            }
        }
    }

    public String getFormName() {
        return this.formName;
    }

    public int getNumberPages() {
        return this.inputPages.length;
    }

    public DCInput[] getPageRows(int pageNum, boolean addTitleAlternative, boolean addPublishedBefore) {
        ArrayList<DCInput> filteredInputs = new ArrayList<DCInput>();
        if (pageNum < this.inputPages.length) {
            for (int i = 0; i < this.inputPages[pageNum].length; ++i) {
                DCInput input = this.inputPages[pageNum][i];
                if (!DCInputSet.doField(input, addTitleAlternative, addPublishedBefore)) continue;
                filteredInputs.add(input);
            }
        }
        DCInput[] inputArray = new DCInput[filteredInputs.size()];
        return filteredInputs.toArray(inputArray);
    }

    public boolean isDefinedMultTitles() {
        return this.isFieldPresent("title.alternative");
    }

    public boolean isDefinedPubBefore() {
        return this.isFieldPresent("date.issued") && this.isFieldPresent("identifier.citation") && this.isFieldPresent("publisher.null");
    }

    public boolean isFieldPresent(String fieldName) {
        for (int i = 0; i < this.inputPages.length; ++i) {
            DCInput[] pageInputs = this.inputPages[i];
            for (int row = 0; row < pageInputs.length; ++row) {
                String fullName = pageInputs[row].getElement() + "." + pageInputs[row].getQualifier();
                if (!fullName.equals(fieldName)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean doField(DCInput dcf, boolean addTitleAlternative, boolean addPublishedBefore) {
        String rowName = dcf.getElement() + "." + dcf.getQualifier();
        if (rowName.equals("title.alternative") && !addTitleAlternative) {
            return false;
        }
        if (rowName.equals("date.issued") && !addPublishedBefore) {
            return false;
        }
        if (rowName.equals("publisher.null") && !addPublishedBefore) {
            return false;
        }
        return !rowName.equals("identifier.citation") || addPublishedBefore;
    }
}

