/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.util;

import java.io.Serializable;
import java.util.Map;

public class SubmissionStepConfig
implements Serializable {
    public static final String SELECT_COLLECTION_STEP = "collection";
    public static final String COMPLETE_STEP = "complete";
    private String id = null;
    private String heading = null;
    private String processingClassName = null;
    private boolean workflowEditable = true;
    private String jspBindingClassName = null;
    private String xmlBindingClassName = null;
    private int number = -1;

    public SubmissionStepConfig() {
    }

    public SubmissionStepConfig(Map<String, String> stepMap) {
        this.id = stepMap.get("id");
        this.heading = stepMap.get("heading");
        this.processingClassName = stepMap.get("processing-class");
        this.jspBindingClassName = stepMap.get("jspui-binding");
        this.xmlBindingClassName = stepMap.get("xmlui-binding");
        String wfEditString = stepMap.get("workflow-editable");
        if (wfEditString != null && wfEditString.length() > 0) {
            this.workflowEditable = Boolean.parseBoolean(wfEditString);
        }
    }

    public String getId() {
        return this.id;
    }

    public String getHeading() {
        return this.heading;
    }

    public String getProcessingClassName() {
        return this.processingClassName;
    }

    public String getXMLUIClassName() {
        return this.xmlBindingClassName;
    }

    public String getJSPUIClassName() {
        return this.jspBindingClassName;
    }

    public int getStepNumber() {
        return this.number;
    }

    protected void setStepNumber(int stepNum) {
        this.number = stepNum;
    }

    public boolean isWorkflowEditable() {
        return this.workflowEditable;
    }

    public boolean isVisible() {
        return this.heading != null && this.heading.length() > 0;
    }
}

