/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.browse;

import org.dspace.browse.ItemCountDAO;
import org.dspace.browse.ItemCountDAOOracle;
import org.dspace.browse.ItemCountDAOPostgres;
import org.dspace.browse.ItemCountException;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;

public class ItemCountDAOFactory {
    public static ItemCountDAO getInstance(Context context) throws ItemCountException {
        ItemCountDAO dao;
        String db = ConfigurationManager.getProperty("db.name");
        if ("postgres".equals(db)) {
            dao = new ItemCountDAOPostgres();
        } else if ("oracle".equals(db)) {
            dao = new ItemCountDAOOracle();
        } else {
            throw new ItemCountException("Database type: " + db + " is not currently supported");
        }
        dao.setContext(context);
        return dao;
    }
}

