/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.browse;

import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.dspace.browse.ItemCountDAO;
import org.dspace.browse.ItemCountDAOFactory;
import org.dspace.browse.ItemCountException;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;

public class ItemCounter {
    private static Logger log = Logger.getLogger(ItemCounter.class);
    private ItemCountDAO dao;
    private Context context;

    public static void main(String[] args) throws ItemCountException, SQLException {
        Context context = new Context();
        ItemCounter ic = new ItemCounter(context);
        ic.buildItemCounts();
        context.complete();
    }

    public ItemCounter(Context context) throws ItemCountException {
        this.context = context;
        this.dao = ItemCountDAOFactory.getInstance(this.context);
    }

    public void buildItemCounts() throws ItemCountException {
        try {
            Community[] tlc = Community.findAllTop(this.context);
            for (int i = 0; i < tlc.length; ++i) {
                this.count(tlc[i]);
            }
        }
        catch (SQLException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new ItemCountException(e);
        }
    }

    public int getCount(DSpaceObject dso) throws ItemCountException {
        boolean useCache = ConfigurationManager.getBooleanProperty("webui.strengths.cache");
        if (useCache) {
            return this.dao.getCount(dso);
        }
        if (dso instanceof Collection) {
            try {
                return ((Collection)dso).countItems();
            }
            catch (SQLException e) {
                log.error((Object)"caught exception: ", (Throwable)e);
                throw new ItemCountException(e);
            }
        }
        if (dso instanceof Community) {
            try {
                return ((Community)dso).countItems();
            }
            catch (SQLException e) {
                log.error((Object)"caught exception: ", (Throwable)e);
                throw new ItemCountException(e);
            }
        }
        return 0;
    }

    public void remove(DSpaceObject dso) throws ItemCountException {
        this.dao.remove(dso);
    }

    private void count(Community community) throws ItemCountException {
        try {
            int count = community.countItems();
            this.dao.communityCount(community, count);
            Community[] scs = community.getSubcommunities();
            for (int i = 0; i < scs.length; ++i) {
                this.count(scs[i]);
            }
            Collection[] cols = community.getCollections();
            for (int i = 0; i < cols.length; ++i) {
                this.count(cols[i]);
            }
        }
        catch (SQLException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new ItemCountException(e);
        }
    }

    private void count(Collection collection) throws ItemCountException {
        try {
            int ccount = collection.countItems();
            this.dao.collectionCount(collection, ccount);
        }
        catch (SQLException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new ItemCountException(e);
        }
    }
}

