/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.log4j.Logger;

public class DCDate {
    private static Logger log = Logger.getLogger(DCDate.class);
    private static final TimeZone utcZone = TimeZone.getTimeZone("UTC");
    private GregorianCalendar calendar = null;
    private GregorianCalendar localCalendar = null;
    DateGran granularity = null;
    private final SimpleDateFormat fullIso = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private final SimpleDateFormat fullIso2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private final SimpleDateFormat fullIso3 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm");
    private final SimpleDateFormat fullIso4 = new SimpleDateFormat("yyyy-MM-dd'T'HH");
    private final SimpleDateFormat dateIso = new SimpleDateFormat("yyyy-MM-dd");
    private final SimpleDateFormat yearMonthIso = new SimpleDateFormat("yyyy-MM");
    private final SimpleDateFormat yearIso = new SimpleDateFormat("yyyy");
    private static Map<Locale, DateFormatSymbols> dfsLocaleMap = new HashMap<Locale, DateFormatSymbols>();

    public DCDate(Date date) {
        this.setUTCForFormatting();
        if (date == null) {
            return;
        }
        this.granularity = DateGran.TIME;
        this.localCalendar = new GregorianCalendar();
        this.localCalendar.setTime(date);
        this.calendar = new GregorianCalendar(utcZone);
        this.calendar.setTime(date);
    }

    public DCDate(int yyyy, int mm, int dd, int hh, int mn, int ss) {
        this.setUTCForFormatting();
        int lyear = 0;
        int lhours = 0;
        int lminutes = 0;
        int lseconds = 0;
        int lmonth = 1;
        int lday = 1;
        if (yyyy > 0) {
            lyear = yyyy;
            this.granularity = DateGran.YEAR;
        }
        if (mm > 0) {
            lmonth = mm;
            this.granularity = DateGran.MONTH;
        }
        if (dd > 0) {
            lday = dd;
            this.granularity = DateGran.DAY;
        }
        if (hh >= 0) {
            lhours = hh;
            this.granularity = DateGran.TIME;
        }
        if (mn >= 0) {
            lminutes = mn;
            this.granularity = DateGran.TIME;
        }
        if (ss >= 0) {
            lseconds = ss;
            this.granularity = DateGran.TIME;
        }
        this.localCalendar = new GregorianCalendar(lyear, lmonth - 1, lday, lhours, lminutes, lseconds);
        if (this.granularity == DateGran.TIME) {
            this.calendar = new GregorianCalendar(utcZone);
            this.calendar.setTime(this.localCalendar.getTime());
        } else {
            this.calendar = new GregorianCalendar(this.localCalendar.get(1), this.localCalendar.get(2), this.localCalendar.get(5));
        }
    }

    public DCDate(String fromDC) {
        this.setUTCForFormatting();
        if (fromDC == null || fromDC.equals("")) {
            return;
        }
        this.granularity = DateGran.TIME;
        Date date = this.tryParse(this.fullIso, fromDC);
        if (date == null) {
            date = this.tryParse(this.fullIso2, fromDC);
        }
        if (date == null) {
            date = this.tryParse(this.fullIso3, fromDC);
        }
        if (date == null) {
            date = this.tryParse(this.fullIso4, fromDC);
        }
        if (date == null && (date = this.tryParse(this.dateIso, fromDC)) != null) {
            this.granularity = DateGran.DAY;
        }
        if (date == null && (date = this.tryParse(this.yearMonthIso, fromDC)) != null) {
            this.granularity = DateGran.MONTH;
        }
        if (date == null && (date = this.tryParse(this.yearIso, fromDC)) != null) {
            this.granularity = DateGran.YEAR;
        }
        if (date == null) {
            log.warn((Object)("Mangled date: " + fromDC + "  ..failed all attempts to parse as date."));
        } else {
            this.calendar = new GregorianCalendar(utcZone);
            this.calendar.setTime(date);
            if (this.granularity == DateGran.TIME) {
                this.localCalendar = new GregorianCalendar();
                this.localCalendar.setTime(date);
            } else {
                this.localCalendar = new GregorianCalendar(this.calendar.get(1), this.calendar.get(2), this.calendar.get(5));
            }
        }
    }

    private void setUTCForFormatting() {
        this.fullIso.setTimeZone(utcZone);
        this.fullIso2.setTimeZone(utcZone);
        this.fullIso3.setTimeZone(utcZone);
        this.fullIso4.setTimeZone(utcZone);
        this.dateIso.setTimeZone(utcZone);
        this.yearMonthIso.setTimeZone(utcZone);
        this.yearIso.setTimeZone(utcZone);
    }

    private synchronized Date tryParse(SimpleDateFormat sdf, String source) {
        try {
            return sdf.parse(source);
        }
        catch (ParseException pe) {
            return null;
        }
    }

    public int getYear() {
        return !this.withinGranularity(DateGran.YEAR) ? -1 : this.localCalendar.get(1);
    }

    public int getMonth() {
        return !this.withinGranularity(DateGran.MONTH) ? -1 : this.localCalendar.get(2) + 1;
    }

    public int getDay() {
        return !this.withinGranularity(DateGran.DAY) ? -1 : this.localCalendar.get(5);
    }

    public int getHour() {
        return !this.withinGranularity(DateGran.TIME) ? -1 : this.localCalendar.get(11);
    }

    public int getMinute() {
        return !this.withinGranularity(DateGran.TIME) ? -1 : this.localCalendar.get(12);
    }

    public int getSecond() {
        return !this.withinGranularity(DateGran.TIME) ? -1 : this.localCalendar.get(13);
    }

    public int getYearUTC() {
        return !this.withinGranularity(DateGran.YEAR) ? -1 : this.calendar.get(1);
    }

    public int getMonthUTC() {
        return !this.withinGranularity(DateGran.MONTH) ? -1 : this.calendar.get(2) + 1;
    }

    public int getDayUTC() {
        return !this.withinGranularity(DateGran.DAY) ? -1 : this.calendar.get(5);
    }

    public int getHourUTC() {
        return !this.withinGranularity(DateGran.TIME) ? -1 : this.calendar.get(11);
    }

    public int getMinuteUTC() {
        return !this.withinGranularity(DateGran.TIME) ? -1 : this.calendar.get(12);
    }

    public int getSecondUTC() {
        return !this.withinGranularity(DateGran.TIME) ? -1 : this.calendar.get(13);
    }

    public String toString() {
        if (this.calendar == null) {
            return "null";
        }
        return this.toStringInternal();
    }

    private synchronized String toStringInternal() {
        if (this.granularity == DateGran.YEAR) {
            return String.format("%4d", this.getYearUTC());
        }
        if (this.granularity == DateGran.MONTH) {
            return String.format("%4d-%02d", this.getYearUTC(), this.getMonthUTC());
        }
        if (this.granularity == DateGran.DAY) {
            return String.format("%4d-%02d-%02d", this.getYearUTC(), this.getMonthUTC(), this.getDayUTC());
        }
        return this.fullIso.format(this.calendar.getTime());
    }

    public Date toDate() {
        if (this.calendar == null) {
            return null;
        }
        return this.calendar.getTime();
    }

    public String displayDate(boolean showTime, boolean isLocalTime, Locale locale) {
        if (isLocalTime) {
            return this.displayLocalDate(showTime, locale);
        }
        return this.displayUTCDate(showTime, locale);
    }

    public String displayLocalDate(boolean showTime, Locale locale) {
        String monthName = DCDate.getMonthName(this.getMonth(), locale);
        if (monthName.length() > 2) {
            monthName = monthName.substring(0, 3);
        }
        if (showTime && this.granularity == DateGran.TIME) {
            return String.format("%d-%s-%4d %02d:%02d:%02d", this.getDay(), monthName, this.getYear(), this.getHour(), this.getMinute(), this.getSecond());
        }
        if (this.granularity == DateGran.YEAR) {
            return String.format("%4d", this.getYear());
        }
        if (this.granularity == DateGran.MONTH) {
            return String.format("%s-%4d", monthName, this.getYear());
        }
        return String.format("%d-%s-%4d", this.getDay(), monthName, this.getYear());
    }

    public String displayUTCDate(boolean showTime, Locale locale) {
        String monthName = DCDate.getMonthName(this.getMonthUTC(), locale);
        if (monthName.length() > 2) {
            monthName = monthName.substring(0, 3);
        }
        if (showTime && this.granularity == DateGran.TIME) {
            return String.format("%d-%s-%4d %02d:%02d:%02d", this.getDayUTC(), monthName, this.getYearUTC(), this.getHourUTC(), this.getMinuteUTC(), this.getSecondUTC());
        }
        if (this.granularity == DateGran.YEAR) {
            return String.format("%4d", this.getYearUTC());
        }
        if (this.granularity == DateGran.MONTH) {
            return String.format("%s-%4d", monthName, this.getYearUTC());
        }
        return String.format("%d-%s-%4d", this.getDayUTC(), monthName, this.getYearUTC());
    }

    private boolean withinGranularity(DateGran dg) {
        if (this.granularity == DateGran.TIME && (dg == DateGran.TIME || dg == DateGran.DAY || dg == DateGran.MONTH || dg == DateGran.YEAR)) {
            return true;
        }
        if (this.granularity == DateGran.DAY && (dg == DateGran.DAY || dg == DateGran.MONTH || dg == DateGran.YEAR)) {
            return true;
        }
        if (this.granularity == DateGran.MONTH && (dg == DateGran.MONTH || dg == DateGran.YEAR)) {
            return true;
        }
        return this.granularity == DateGran.YEAR && dg == DateGran.YEAR;
    }

    public static DCDate getCurrent() {
        return new DCDate(new Date());
    }

    public static String getMonthName(int m, Locale locale) {
        if (m > 0 && m < 13) {
            DateFormatSymbols dfs = dfsLocaleMap.get(locale);
            if (dfs == null) {
                dfs = new DateFormatSymbols(locale);
                dfsLocaleMap.put(locale, dfs);
            }
            return dfs.getMonths()[m - 1];
        }
        return "Unspecified";
    }

    private static enum DateGran {
        YEAR,
        MONTH,
        DAY,
        TIME;

    }
}

