/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.storage.rdbms.TableRow;
import org.dspace.storage.rdbms.TableRowIterator;

public class ItemIterator {
    private Context ourContext;
    private TableRowIterator itemRows;
    private Iterator<Integer> iditr;

    public ItemIterator(Context context, TableRowIterator rows) {
        this.ourContext = context;
        this.itemRows = rows;
    }

    public ItemIterator(Context context, List<Integer> iids) {
        this.ourContext = context;
        this.iditr = iids.iterator();
    }

    public boolean hasNext() throws SQLException {
        if (this.iditr != null) {
            return this.iditr.hasNext();
        }
        if (this.itemRows != null) {
            return this.itemRows.hasNext();
        }
        return false;
    }

    public Item next() throws SQLException {
        if (this.iditr != null) {
            return this.nextByID();
        }
        if (this.itemRows != null) {
            return this.nextByRow();
        }
        return null;
    }

    private Item nextByID() throws SQLException {
        if (this.iditr.hasNext()) {
            int id = this.iditr.next();
            Item fromCache = (Item)this.ourContext.fromCache(Item.class, id);
            if (fromCache != null) {
                return fromCache;
            }
            return Item.find(this.ourContext, id);
        }
        return null;
    }

    public int nextID() throws SQLException {
        if (this.iditr != null) {
            return this.nextByIDID();
        }
        if (this.itemRows != null) {
            return this.nextByRowID();
        }
        return -1;
    }

    private int nextByIDID() {
        if (this.iditr.hasNext()) {
            int id = this.iditr.next();
            return id;
        }
        return -1;
    }

    private int nextByRowID() throws SQLException {
        if (this.itemRows.hasNext()) {
            TableRow row = this.itemRows.next();
            return row.getIntColumn("item_id");
        }
        return -1;
    }

    private Item nextByRow() throws SQLException {
        if (this.itemRows.hasNext()) {
            TableRow row = this.itemRows.next();
            Item fromCache = (Item)this.ourContext.fromCache(Item.class, row.getIntColumn("item_id"));
            if (fromCache != null) {
                return fromCache;
            }
            return new Item(this.ourContext, row);
        }
        return null;
    }

    public void close() {
        if (this.itemRows != null) {
            this.itemRows.close();
        }
    }
}

