/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.crosswalk;

import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import org.apache.log4j.Logger;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.SelfNamedPlugin;
import org.jdom.Namespace;
import org.jdom.transform.XSLTransformException;
import org.jdom.transform.XSLTransformer;

public abstract class XSLTCrosswalk
extends SelfNamedPlugin {
    private static Logger log = Logger.getLogger(XSLTCrosswalk.class);
    public static final Namespace DIM_NS = Namespace.getNamespace((String)"dim", (String)"http://www.dspace.org/xmlns/dspace/dim");
    protected static final String CONFIG_PREFIX = "crosswalk.";
    private static final String CONFIG_STYLESHEET = ".stylesheet";
    private XSLTransformer transformer = null;
    private File transformerFile = null;
    private long transformerLastModified = 0L;

    protected static String[] makeAliases(String direction) {
        String prefix = CONFIG_PREFIX + direction + ".";
        String suffix = CONFIG_STYLESHEET;
        ArrayList<String> aliasList = new ArrayList<String>();
        Enumeration<?> pe = ConfigurationManager.propertyNames();
        log.debug((Object)("XSLTCrosswalk: Looking for config prefix = " + prefix));
        while (pe.hasMoreElements()) {
            String key = (String)pe.nextElement();
            if (!key.startsWith(prefix) || !key.endsWith(suffix)) continue;
            log.debug((Object)("Getting XSLT plugin name from config line: " + key));
            aliasList.add(key.substring(prefix.length(), key.length() - suffix.length()));
        }
        return aliasList.toArray(new String[aliasList.size()]);
    }

    protected XSLTransformer getTransformer(String direction) {
        if (this.transformerFile == null) {
            String myAlias = this.getPluginInstanceName();
            if (myAlias == null) {
                log.error((Object)"Must use PluginManager to instantiate XSLTCrosswalk so the class knows its name.");
                return null;
            }
            String cmPropName = CONFIG_PREFIX + direction + "." + myAlias + CONFIG_STYLESHEET;
            String fname = ConfigurationManager.getProperty(cmPropName);
            if (fname == null) {
                log.error((Object)("Missing configuration filename for XSLT-based crosswalk: no value for property = " + cmPropName));
                return null;
            }
            String parent = ConfigurationManager.getProperty("dspace.dir") + File.separator + "config" + File.separator;
            this.transformerFile = new File(parent, fname);
        }
        if (this.transformer == null || this.transformerFile.lastModified() > this.transformerLastModified) {
            try {
                log.debug((Object)((this.transformer == null ? "Loading " : "Reloading") + this.getPluginInstanceName() + " XSLT stylesheet from " + this.transformerFile.toString()));
                this.transformer = new XSLTransformer(this.transformerFile);
                this.transformerLastModified = this.transformerFile.lastModified();
            }
            catch (XSLTransformException e) {
                log.error((Object)("Failed to initialize XSLTCrosswalk(" + this.getPluginInstanceName() + "):" + e.toString()));
            }
        }
        return this.transformer;
    }
}

