/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.curate;

import java.io.IOException;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.curate.CurationTask;
import org.dspace.curate.Curator;
import org.dspace.curate.Distributive;
import org.dspace.curate.Mutative;
import org.dspace.curate.ScriptedTask;
import org.dspace.curate.Suspendable;

public class ResolvedTask {
    private CurationTask cTask;
    private ScriptedTask sTask;
    private String taskName;
    private boolean distributive = false;
    private boolean mutative = false;
    private Curator.Invoked mode = null;
    private int[] codes = null;

    protected ResolvedTask(String taskName, CurationTask cTask) {
        this.taskName = taskName;
        this.cTask = cTask;
        Class<?> ctClass = cTask.getClass();
        this.distributive = ctClass.isAnnotationPresent(Distributive.class);
        this.mutative = ctClass.isAnnotationPresent(Mutative.class);
        Suspendable suspendAnno = ctClass.getAnnotation(Suspendable.class);
        if (suspendAnno != null) {
            this.mode = suspendAnno.invoked();
            this.codes = suspendAnno.statusCodes();
        }
    }

    protected ResolvedTask(String taskName, ScriptedTask sTask) {
        this.taskName = taskName;
        this.sTask = sTask;
    }

    public void init(Curator curator) throws IOException {
        if (this.unscripted()) {
            this.cTask.init(curator, this.taskName);
        } else {
            this.sTask.init(curator, this.taskName);
        }
    }

    public int perform(DSpaceObject dso) throws IOException {
        return this.unscripted() ? this.cTask.perform(dso) : this.sTask.performDso(dso);
    }

    public int perform(Context ctx, String id) throws IOException {
        return this.unscripted() ? this.cTask.perform(ctx, id) : this.sTask.performId(ctx, id);
    }

    public String getName() {
        return this.taskName;
    }

    public boolean isDistributive() {
        return this.distributive;
    }

    public boolean isMutative() {
        return this.mutative;
    }

    public Curator.Invoked getMode() {
        return this.mode;
    }

    public int[] getCodes() {
        return this.codes;
    }

    private boolean unscripted() {
        return this.sTask == null;
    }
}

