/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.discovery;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.discovery.SearchService;
import org.dspace.discovery.configuration.DiscoveryConfiguration;
import org.dspace.discovery.configuration.DiscoveryConfigurationService;
import org.dspace.kernel.ServiceManager;
import org.dspace.utils.DSpace;

public class SearchUtils {
    private static SearchService searchService;

    public static SearchService getSearchService() {
        if (searchService == null) {
            DSpace dspace = new DSpace();
            ServiceManager manager = dspace.getServiceManager();
            searchService = (SearchService)manager.getServiceByName(SearchService.class.getName(), SearchService.class);
        }
        return searchService;
    }

    public static DiscoveryConfiguration getDiscoveryConfiguration() {
        return SearchUtils.getDiscoveryConfiguration(null);
    }

    public static DiscoveryConfiguration getDiscoveryConfiguration(DSpaceObject dso) {
        DiscoveryConfigurationService configurationService = SearchUtils.getConfigurationService();
        DiscoveryConfiguration result = null;
        result = dso == null ? configurationService.getMap().get("site") : configurationService.getMap().get(dso.getHandle());
        if (result == null) {
            result = configurationService.getMap().get("default");
        }
        return result;
    }

    public static DiscoveryConfigurationService getConfigurationService() {
        DSpace dspace = new DSpace();
        ServiceManager manager = dspace.getServiceManager();
        return (DiscoveryConfigurationService)manager.getServiceByName(DiscoveryConfigurationService.class.getName(), DiscoveryConfigurationService.class);
    }

    public static List<DiscoveryConfiguration> getAllDiscoveryConfigurations(Item item) throws SQLException {
        Collection[] collections;
        HashMap<String, DiscoveryConfiguration> result = new HashMap<String, DiscoveryConfiguration>();
        for (Collection collection : collections = item.getCollections()) {
            DiscoveryConfiguration configuration = SearchUtils.getDiscoveryConfiguration(collection);
            if (result.containsKey(configuration.getId())) continue;
            result.put(configuration.getId(), configuration);
        }
        DiscoveryConfiguration configuration = SearchUtils.getDiscoveryConfiguration(null);
        if (!result.containsKey(configuration.getId())) {
            result.put(configuration.getId(), configuration);
        }
        return Arrays.asList(result.values().toArray(new DiscoveryConfiguration[result.size()]));
    }
}

