/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.eperson;

import java.sql.SQLException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.dspace.core.Context;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.TableRow;
import org.dspace.storage.rdbms.TableRowIterator;

public class Groomer {
    public static void main(String[] argv) throws SQLException {
        String USAGE = "EPerson -verb [option...]";
        OptionGroup verbs = new OptionGroup();
        verbs.setRequired(true);
        verbs.addOption(new Option("h", "help", false, "explain this tool"));
        verbs.addOption(new Option("u", "unsalted", false, "list accounts with unsalted password hashes"));
        Options options = new Options();
        options.addOptionGroup(verbs);
        PosixParser parser = new PosixParser();
        CommandLine command = null;
        try {
            command = parser.parse(options, argv);
        }
        catch (ParseException ex) {
            System.err.println(ex.getMessage());
            if (!(ex instanceof MissingOptionException)) {
                new HelpFormatter().printHelp("EPerson -verb [option...]", options);
            }
            System.exit(1);
        }
        if (command.hasOption('h') || command.hasOption('?')) {
            new HelpFormatter().printHelp("EPerson -verb [option...]", options);
        } else if (command.hasOption('u')) {
            Context myContext = new Context();
            TableRowIterator tri = DatabaseManager.query(myContext, "SELECT email FROM EPerson WHERE password IS NOT NULL AND digest_algorithm IS NULL", new Object[0]);
            TableRow row = tri.next();
            while (tri.hasNext()) {
                System.out.println(row.getStringColumn("email"));
                row = tri.next();
            }
            myContext.abort();
        } else {
            System.err.println("Unimplemented verb:  " + verbs.getSelected());
        }
    }
}

