/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.statistics;

import com.Ostermiller.util.CSVParser;
import com.Ostermiller.util.CSVPrinter;
import com.maxmind.geoip.Location;
import com.maxmind.geoip.LookupService;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.CommonsHttpSolrServer;
import org.apache.solr.client.solrj.request.AbstractUpdateRequest;
import org.apache.solr.client.solrj.request.ContentStreamUpdateRequest;
import org.apache.solr.client.solrj.request.CoreAdminRequest;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.response.RangeFacet;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.MapSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Community;
import org.dspace.content.DCDate;
import org.dspace.content.DCValue;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.statistics.ObjectCount;
import org.dspace.statistics.util.DnsLookup;
import org.dspace.statistics.util.LocationUtils;
import org.dspace.statistics.util.SpiderDetector;
import org.dspace.usage.UsageWorkflowEvent;

public class SolrLogger {
    private static final Logger log;
    private static final CommonsHttpSolrServer solr;
    public static final String DATE_FORMAT_8601 = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    public static final String DATE_FORMAT_DCDATE = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private static final LookupService locationService;
    private static final boolean useProxies;
    private static Map<String, String> metadataStorageInfo;
    private static List<String> statisticYearCores;
    private static String filterQuery;

    public static void post(DSpaceObject dspaceObject, HttpServletRequest request, EPerson currentUser) {
        SolrLogger.postView(dspaceObject, request, currentUser);
    }

    public static void postView(DSpaceObject dspaceObject, HttpServletRequest request, EPerson currentUser) {
        if (solr == null || locationService == null) {
            return;
        }
        try {
            SolrInputDocument doc1 = SolrLogger.getCommonSolrDoc(dspaceObject, request, currentUser);
            if (doc1 == null) {
                return;
            }
            if (dspaceObject instanceof Item) {
                Item item = (Item)dspaceObject;
                for (String storedField : metadataStorageInfo.keySet()) {
                    DCValue[] vals;
                    String dcField = metadataStorageInfo.get(storedField);
                    for (DCValue val1 : vals = item.getMetadata(dcField.split("\\.")[0], dcField.split("\\.")[1], dcField.split("\\.")[2], "*")) {
                        String val = val1.value;
                        doc1.addField(String.valueOf(storedField), (Object)val);
                        doc1.addField(storedField + "_search", (Object)val.toLowerCase());
                    }
                }
            }
            if (dspaceObject instanceof Bitstream) {
                Bundle[] bundles;
                Bitstream bit = (Bitstream)dspaceObject;
                for (Bundle bundle : bundles = bit.getBundles()) {
                    doc1.addField("bundleName", (Object)bundle.getName());
                }
            }
            doc1.addField("statistics_type", (Object)StatisticsType.VIEW.text());
            solr.add(doc1);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private static SolrInputDocument getCommonSolrDoc(DSpaceObject dspaceObject, HttpServletRequest request, EPerson currentUser) throws SQLException {
        boolean isSpiderBot;
        boolean bl = isSpiderBot = request != null && SpiderDetector.isSpider(request);
        if (isSpiderBot && !ConfigurationManager.getBooleanProperty("usage-statistics", "logBots", true)) {
            return null;
        }
        SolrInputDocument doc1 = new SolrInputDocument();
        if (request != null) {
            String ip = request.getRemoteAddr();
            if (SolrLogger.isUseProxies() && request.getHeader("X-Forwarded-For") != null) {
                for (String xfip : request.getHeader("X-Forwarded-For").split(",")) {
                    if (request.getHeader("X-Forwarded-For").contains(ip)) continue;
                    ip = xfip.trim();
                }
            }
            doc1.addField("ip", (Object)ip);
            if (request.getHeader("referer") != null) {
                doc1.addField("referrer", (Object)request.getHeader("referer"));
            }
            try {
                String dns = DnsLookup.reverseDns(ip);
                doc1.addField("dns", (Object)dns.toLowerCase());
            }
            catch (Exception e) {
                log.error((Object)("Failed DNS Lookup for IP:" + ip));
                log.debug((Object)e.getMessage(), (Throwable)e);
            }
            Location location = locationService.getLocation(ip);
            if (!(location == null || "--".equals(location.countryCode) && location.latitude == -180.0f && location.longitude == -180.0f)) {
                try {
                    doc1.addField("continent", (Object)LocationUtils.getContinentCode(location.countryCode));
                }
                catch (Exception e) {
                    System.out.println("COUNTRY ERROR: " + location.countryCode);
                }
                doc1.addField("countryCode", (Object)location.countryCode);
                doc1.addField("city", (Object)location.city);
                doc1.addField("latitude", (Object)Float.valueOf(location.latitude));
                doc1.addField("longitude", (Object)Float.valueOf(location.longitude));
                doc1.addField("isBot", (Object)isSpiderBot);
                if (request.getHeader("User-Agent") != null) {
                    doc1.addField("userAgent", (Object)request.getHeader("User-Agent"));
                }
            }
        }
        if (dspaceObject != null) {
            doc1.addField("id", (Object)dspaceObject.getID());
            doc1.addField("type", (Object)dspaceObject.getType());
            SolrLogger.storeParents(doc1, dspaceObject);
        }
        doc1.addField("time", (Object)DateFormatUtils.format((Date)new Date(), (String)DATE_FORMAT_8601));
        if (currentUser != null) {
            doc1.addField("epersonid", (Object)currentUser.getID());
        }
        return doc1;
    }

    public static void postSearch(DSpaceObject resultObject, HttpServletRequest request, EPerson currentUser, List<String> queries, int rpp, String sortBy, String order, int page, DSpaceObject scope) {
        try {
            SolrInputDocument solrDoc = SolrLogger.getCommonSolrDoc(resultObject, request, currentUser);
            if (solrDoc == null) {
                return;
            }
            for (String query : queries) {
                solrDoc.addField("query", (Object)query);
            }
            if (resultObject != null) {
                solrDoc.addField("statistics_type", (Object)StatisticsType.SEARCH_RESULT.text());
            } else {
                solrDoc.addField("statistics_type", (Object)StatisticsType.SEARCH.text());
            }
            if (scope != null) {
                solrDoc.addField("scopeId", (Object)scope.getType());
                solrDoc.addField("scopeType", (Object)scope.getID());
            }
            if (rpp != -1) {
                solrDoc.addField("rpp", (Object)rpp);
            }
            if (sortBy != null) {
                solrDoc.addField("sortBy", (Object)sortBy);
                if (order != null) {
                    solrDoc.addField("sortOrder", (Object)order);
                }
            }
            if (page != -1) {
                solrDoc.addField("page", (Object)page);
            }
            solr.add(solrDoc);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static void postWorkflow(UsageWorkflowEvent usageWorkflowEvent) throws SQLException {
        try {
            int i;
            SolrInputDocument solrDoc = SolrLogger.getCommonSolrDoc(usageWorkflowEvent.getObject(), null, null);
            solrDoc.addField("owningColl", (Object)usageWorkflowEvent.getScope().getID());
            SolrLogger.storeParents(solrDoc, usageWorkflowEvent.getScope());
            if (usageWorkflowEvent.getWorkflowStep() != null) {
                solrDoc.addField("workflowStep", (Object)usageWorkflowEvent.getWorkflowStep());
            }
            if (usageWorkflowEvent.getOldState() != null) {
                solrDoc.addField("previousWorkflowStep", (Object)usageWorkflowEvent.getOldState());
            }
            if (usageWorkflowEvent.getGroupOwners() != null) {
                for (i = 0; i < usageWorkflowEvent.getGroupOwners().length; ++i) {
                    Group group = usageWorkflowEvent.getGroupOwners()[i];
                    solrDoc.addField("owner", (Object)("g" + group.getID()));
                }
            }
            if (usageWorkflowEvent.getEpersonOwners() != null) {
                for (i = 0; i < usageWorkflowEvent.getEpersonOwners().length; ++i) {
                    EPerson ePerson = usageWorkflowEvent.getEpersonOwners()[i];
                    solrDoc.addField("owner", (Object)("e" + ePerson.getID()));
                }
            }
            solrDoc.addField("workflowItemId", (Object)usageWorkflowEvent.getWorkflowItem().getID());
            EPerson submitter = ((Item)usageWorkflowEvent.getObject()).getSubmitter();
            if (submitter != null) {
                solrDoc.addField("submitter", (Object)submitter.getID());
            }
            solrDoc.addField("statistics_type", (Object)StatisticsType.WORKFLOW.text());
            if (usageWorkflowEvent.getActor() != null) {
                solrDoc.addField("actor", (Object)usageWorkflowEvent.getActor().getID());
            }
            solr.add(solrDoc);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static Map<String, String> getMetadataStorageInfo() {
        return metadataStorageInfo;
    }

    public static void storeParents(SolrInputDocument doc1, DSpaceObject dso) throws SQLException {
        block6: {
            block8: {
                block7: {
                    block5: {
                        if (!(dso instanceof Community)) break block5;
                        for (Community comm = (Community)dso; comm != null && comm.getParentCommunity() != null; comm = comm.getParentCommunity()) {
                            doc1.addField("owningComm", (Object)comm.getID());
                        }
                        break block6;
                    }
                    if (!(dso instanceof org.dspace.content.Collection)) break block7;
                    org.dspace.content.Collection coll = (org.dspace.content.Collection)dso;
                    for (int i = 0; i < coll.getCommunities().length; ++i) {
                        Community community = coll.getCommunities()[i];
                        doc1.addField("owningComm", (Object)community.getID());
                        SolrLogger.storeParents(doc1, community);
                    }
                    break block6;
                }
                if (!(dso instanceof Item)) break block8;
                Item item = (Item)dso;
                for (int i = 0; i < item.getCollections().length; ++i) {
                    org.dspace.content.Collection collection = item.getCollections()[i];
                    doc1.addField("owningColl", (Object)collection.getID());
                    SolrLogger.storeParents(doc1, collection);
                }
                break block6;
            }
            if (!(dso instanceof Bitstream)) break block6;
            Bitstream bitstream = (Bitstream)dso;
            for (int i = 0; i < bitstream.getBundles().length; ++i) {
                Bundle bundle = bitstream.getBundles()[i];
                for (int j = 0; j < bundle.getItems().length; ++j) {
                    Item item = bundle.getItems()[j];
                    doc1.addField("owningItem", (Object)item.getID());
                    SolrLogger.storeParents(doc1, item);
                }
            }
        }
    }

    public static boolean isUseProxies() {
        return useProxies;
    }

    public static void removeIndex(String query) throws IOException, SolrServerException {
        solr.deleteByQuery(query);
        solr.commit();
    }

    public static Map<String, List<String>> queryField(String query, List oldFieldVals, String field) {
        HashMap<String, List<String>> currentValsStored = new HashMap<String, List<String>>();
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("q", query);
            params.put("rows", "1");
            MapSolrParams solrParams = new MapSolrParams(params);
            QueryResponse response = solr.query((SolrParams)solrParams);
            if (response.getResults().getNumFound() == 0L) {
                return currentValsStored;
            }
            SolrDocument document = (SolrDocument)response.getResults().get(0);
            for (String storedField : metadataStorageInfo.keySet()) {
                Collection collection = document.getFieldValues(storedField);
                ArrayList storedVals = new ArrayList();
                storedVals.addAll(collection);
                currentValsStored.put(storedField, storedVals);
            }
        }
        catch (SolrServerException e) {
            e.printStackTrace();
        }
        return currentValsStored;
    }

    public static void markRobotsByIP() {
        for (String ip : SpiderDetector.getSpiderIpAddresses()) {
            try {
                ResultProcessor processor = new ResultProcessor(){

                    @Override
                    public void process(SolrDocument doc) throws IOException, SolrServerException {
                        doc.removeFields("isBot");
                        doc.addField("isBot", (Object)true);
                        SolrInputDocument newInput = ClientUtils.toSolrInputDocument((SolrDocument)doc);
                        solr.add(newInput);
                        log.info((Object)("Marked " + doc.getFieldValue("ip") + " as bot"));
                    }
                };
                processor.execute("ip:" + ip + "* AND -isBot:true");
                solr.commit();
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void markRobotByUserAgent(String agent) {
        try {
            ResultProcessor processor = new ResultProcessor(){

                @Override
                public void process(SolrDocument doc) throws IOException, SolrServerException {
                    doc.removeFields("isBot");
                    doc.addField("isBot", (Object)true);
                    SolrInputDocument newInput = ClientUtils.toSolrInputDocument((SolrDocument)doc);
                    solr.add(newInput);
                }
            };
            processor.execute("userAgent:" + agent + " AND -isBot:true");
            solr.commit();
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static void deleteRobotsByIsBotFlag() {
        try {
            solr.deleteByQuery("isBot:true");
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static void deleteIP(String ip) {
        try {
            solr.deleteByQuery("ip:" + ip + "*");
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static void deleteRobotsByIP() {
        for (String ip : SpiderDetector.getSpiderIpAddresses()) {
            SolrLogger.deleteIP(ip);
        }
    }

    public static void update(String query, String action, List<String> fieldNames, List<List<Object>> fieldValuesList) throws SolrServerException, IOException {
        final ArrayList docsToUpdate = new ArrayList();
        ResultProcessor processor = new ResultProcessor(){

            @Override
            public void process(List<SolrDocument> docs) throws IOException, SolrServerException {
                docsToUpdate.addAll(docs);
            }
        };
        processor.execute(query);
        solr.deleteByQuery(query);
        for (int i = 0; i < docsToUpdate.size(); ++i) {
            SolrDocument solrDocument = (SolrDocument)docsToUpdate.get(i);
            for (int j = 0; j < fieldNames.size(); ++j) {
                String fieldName = fieldNames.get(j);
                List<Object> fieldValues = fieldValuesList.get(j);
                if (action.equals("addOne") || action.equals("replace")) {
                    if (action.equals("replace")) {
                        solrDocument.removeFields(fieldName);
                    }
                    for (Object fieldValue : fieldValues) {
                        solrDocument.addField(fieldName, fieldValue);
                    }
                    continue;
                }
                if (!action.equals("remOne")) continue;
                Collection values = solrDocument.getFieldValues(fieldName);
                solrDocument.removeFields(fieldName);
                for (Object value : values) {
                    if (fieldValues.contains(value)) continue;
                    solrDocument.addField(fieldName, value);
                }
            }
            SolrInputDocument newInput = ClientUtils.toSolrInputDocument((SolrDocument)solrDocument);
            solr.add(newInput);
        }
        solr.commit();
    }

    public static void query(String query, int max) throws SolrServerException {
        SolrLogger.query(query, null, null, 0, max, null, null, null, null, null, false);
    }

    public static ObjectCount[] queryFacetField(String query, String filterQuery, String facetField, int max, boolean showTotal, List<String> facetQueries) throws SolrServerException {
        QueryResponse queryResponse = SolrLogger.query(query, filterQuery, facetField, 0, max, null, null, null, facetQueries, null, false);
        if (queryResponse == null) {
            return new ObjectCount[0];
        }
        FacetField field = queryResponse.getFacetField(facetField);
        if (0 < field.getValueCount()) {
            ObjectCount[] result = new ObjectCount[field.getValueCount() + (showTotal ? 1 : 0)];
            for (int i = 0; i < field.getValues().size(); ++i) {
                FacetField.Count fieldCount = (FacetField.Count)field.getValues().get(i);
                result[i] = new ObjectCount();
                result[i].setCount(fieldCount.getCount());
                result[i].setValue(fieldCount.getName());
            }
            if (showTotal) {
                result[result.length - 1] = new ObjectCount();
                result[result.length - 1].setCount(queryResponse.getResults().getNumFound());
                result[result.length - 1].setValue("total");
            }
            return result;
        }
        return new ObjectCount[0];
    }

    public static ObjectCount[] queryFacetDate(String query, String filterQuery, int max, String dateType, String dateStart, String dateEnd, boolean showTotal) throws SolrServerException {
        QueryResponse queryResponse = SolrLogger.query(query, filterQuery, null, 0, max, dateType, dateStart, dateEnd, null, null, false);
        if (queryResponse == null) {
            return new ObjectCount[0];
        }
        FacetField dateFacet = queryResponse.getFacetDate("time");
        ObjectCount[] result = new ObjectCount[dateFacet.getValueCount() + (showTotal ? 1 : 0)];
        for (int i = 0; i < dateFacet.getValues().size(); ++i) {
            FacetField.Count dateCount = (FacetField.Count)dateFacet.getValues().get(i);
            result[i] = new ObjectCount();
            result[i].setCount(dateCount.getCount());
            result[i].setValue(SolrLogger.getDateView(dateCount.getName(), dateType));
        }
        if (showTotal) {
            result[result.length - 1] = new ObjectCount();
            result[result.length - 1].setCount(queryResponse.getResults().getNumFound());
            result[result.length - 1].setValue("total");
        }
        return result;
    }

    public static Map<String, Integer> queryFacetQuery(String query, String filterQuery, List<String> facetQueries) throws SolrServerException {
        QueryResponse response = SolrLogger.query(query, filterQuery, null, 0, 1, null, null, null, facetQueries, null, false);
        return response.getFacetQuery();
    }

    public static ObjectCount queryTotal(String query, String filterQuery) throws SolrServerException {
        QueryResponse queryResponse = SolrLogger.query(query, filterQuery, null, 0, -1, null, null, null, null, null, false);
        ObjectCount objCount = new ObjectCount();
        objCount.setCount(queryResponse.getResults().getNumFound());
        return objCount;
    }

    private static String getDateView(String name, String type) {
        if (name != null && name.matches("^[0-9]{4}\\-[0-9]{2}.*")) {
            Date date = null;
            try {
                SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT_8601);
                date = format.parse(name);
            }
            catch (ParseException e) {
                try {
                    SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT_DCDATE);
                    date = format.parse(name);
                }
                catch (ParseException e1) {
                    e1.printStackTrace();
                }
            }
            String dateformatString = "dd-MM-yyyy";
            if ("DAY".equals(type)) {
                dateformatString = "dd-MM-yyyy";
            } else if ("MONTH".equals(type)) {
                dateformatString = "MMMM yyyy";
            } else if ("YEAR".equals(type)) {
                dateformatString = "yyyy";
            }
            SimpleDateFormat simpleFormat = new SimpleDateFormat(dateformatString);
            if (date != null) {
                name = simpleFormat.format(date);
            }
        }
        return name;
    }

    public static QueryResponse query(String query, String filterQuery, String facetField, int rows, int max, String dateType, String dateStart, String dateEnd, List<String> facetQueries, String sort, boolean ascending) throws SolrServerException {
        QueryResponse response;
        String bundles;
        if (solr == null) {
            return null;
        }
        SolrQuery solrQuery = new SolrQuery().setRows(Integer.valueOf(rows)).setQuery(query).setFacetMinCount(1);
        SolrLogger.addAdditionalSolrYearCores(solrQuery);
        if (dateType != null) {
            solrQuery.setParam("facet.date", new String[]{"time"}).setParam("facet.date.end", new String[]{"NOW/" + dateType + dateEnd + dateType}).setParam("facet.date.gap", new String[]{"+1" + dateType}).setParam("facet.date.start", new String[]{"NOW/" + dateType + dateStart + dateType + "S"}).setFacet(true);
        }
        if (facetQueries != null) {
            for (int i = 0; i < facetQueries.size(); ++i) {
                String facetQuery = facetQueries.get(i);
                solrQuery.addFacetQuery(facetQuery);
            }
            if (0 < facetQueries.size()) {
                solrQuery.setFacet(true);
            }
        }
        if (facetField != null) {
            solrQuery.addFacetField(new String[]{facetField});
        }
        if (max != -1) {
            solrQuery.setFacetLimit(max);
        }
        if (ConfigurationManager.getBooleanProperty("solr-statistics", "query.filter.spiderIp", false)) {
            solrQuery.addFilterQuery(new String[]{SolrLogger.getIgnoreSpiderIPs()});
        }
        if (ConfigurationManager.getBooleanProperty("solr-statistics", "query.filter.isBot", true)) {
            solrQuery.addFilterQuery(new String[]{"-isBot:true"});
        }
        if (sort != null) {
            solrQuery.setSortField(sort, ascending ? SolrQuery.ORDER.asc : SolrQuery.ORDER.desc);
        }
        if ((bundles = ConfigurationManager.getProperty("solr-statistics", "query.filter.bundles")) != null && 0 < bundles.length()) {
            StringBuffer bundleQuery = new StringBuffer();
            bundleQuery.append("-(bundleName:[* TO *]");
            String[] split = bundles.split(",");
            for (int i = 0; i < split.length; ++i) {
                String bundle = split[i].trim();
                bundleQuery.append("-bundleName:").append(bundle);
                if (i == split.length - 1) continue;
                bundleQuery.append(" AND ");
            }
            bundleQuery.append(")");
            solrQuery.addFilterQuery(new String[]{bundleQuery.toString()});
        }
        if (filterQuery != null) {
            solrQuery.addFilterQuery(new String[]{filterQuery});
        }
        try {
            response = solr.query((SolrParams)solrQuery);
        }
        catch (SolrServerException e) {
            System.err.println("Error using query " + query);
            throw e;
        }
        return response;
    }

    public static String getIgnoreSpiderIPs() {
        if (filterQuery == null) {
            StringBuilder query = new StringBuilder();
            boolean first = true;
            for (String ip : SpiderDetector.getSpiderIpAddresses()) {
                if (first) {
                    query.append(" AND ");
                    first = false;
                }
                query.append(" NOT(ip: ").append(ip).append(")");
            }
            filterQuery = query.toString();
        }
        return filterQuery;
    }

    public static void optimizeSOLR() {
        try {
            long start = System.currentTimeMillis();
            System.out.println("SOLR Optimize -- Process Started:" + start);
            solr.optimize();
            long finish = System.currentTimeMillis();
            System.out.println("SOLR Optimize -- Process Finished:" + finish);
            System.out.println("SOLR Optimize -- Total time taken:" + (finish - start) + " (ms).");
        }
        catch (SolrServerException sse) {
            System.err.println(sse.getMessage());
        }
        catch (IOException ioe) {
            System.err.println(ioe.getMessage());
        }
    }

    public static void shardSolrIndex() throws IOException, SolrServerException {
        SolrQuery yearRangeQuery = new SolrQuery();
        yearRangeQuery.setQuery("*:*");
        yearRangeQuery.setRows(Integer.valueOf(0));
        yearRangeQuery.setFacet(true);
        yearRangeQuery.add("facet.range", new String[]{"time"});
        yearRangeQuery.add("facet.range.start", new String[]{"NOW/YEAR-" + (Calendar.getInstance().get(1) - 2000) + "YEARS"});
        yearRangeQuery.add("facet.range.end", new String[]{"NOW/YEAR+0YEARS"});
        yearRangeQuery.add("facet.range.gap", new String[]{"+1YEAR"});
        yearRangeQuery.add("facet.mincount", new String[]{String.valueOf(1)});
        File tempDirectory = new File(ConfigurationManager.getProperty("dspace.dir") + File.separator + "temp" + File.separator);
        tempDirectory.mkdirs();
        QueryResponse queryResponse = solr.query((SolrParams)yearRangeQuery);
        List yearResults = ((RangeFacet)queryResponse.getFacetRanges().get(0)).getCounts();
        for (RangeFacet.Count count : yearResults) {
            long totalRecords = count.getCount();
            DCDate dcStart = new DCDate(count.getValue());
            Calendar endDate = Calendar.getInstance();
            endDate.setTime(dcStart.toDate());
            endDate.add(1, 1);
            DCDate dcEndDate = new DCDate(endDate.getTime());
            StringBuilder filterQuery = new StringBuilder();
            filterQuery.append("time:([");
            filterQuery.append(ClientUtils.escapeQueryChars((String)dcStart.toString()));
            filterQuery.append(" TO ");
            filterQuery.append(ClientUtils.escapeQueryChars((String)dcEndDate.toString()));
            filterQuery.append("]");
            filterQuery.append(" NOT ").append(ClientUtils.escapeQueryChars((String)dcEndDate.toString()));
            filterQuery.append(")");
            HashMap<String, String> yearQueryParams = new HashMap<String, String>();
            yearQueryParams.put("q", "*:*");
            yearQueryParams.put("rows", String.valueOf(10000));
            yearQueryParams.put("fq", filterQuery.toString());
            yearQueryParams.put("wt", "csv");
            String coreName = "statistics-" + dcStart.getYear();
            CommonsHttpSolrServer statisticsYearServer = SolrLogger.createCore(solr, coreName);
            System.out.println("Moving: " + totalRecords + " into core " + coreName);
            log.info((Object)("Moving: " + totalRecords + " records into core " + coreName));
            ArrayList<File> filesToUpload = new ArrayList<File>();
            int i = 0;
            while ((long)i < totalRecords) {
                String solrRequestUrl = solr.getBaseURL() + "/select";
                solrRequestUrl = SolrLogger.generateURL(solrRequestUrl, yearQueryParams);
                GetMethod get = new GetMethod(solrRequestUrl);
                new HttpClient().executeMethod((HttpMethod)get);
                InputStream csvInputstream = get.getResponseBodyAsStream();
                File csvFile = new File(tempDirectory.getPath() + File.separatorChar + "temp." + dcStart.getYear() + "." + i + ".csv");
                FileUtils.copyInputStreamToFile((InputStream)csvInputstream, (File)csvFile);
                filesToUpload.add(csvFile);
                yearQueryParams.put("start", String.valueOf(i + 10000));
                i += 10000;
            }
            for (File tempCsv : filesToUpload) {
                ContentStreamUpdateRequest contentStreamUpdateRequest = new ContentStreamUpdateRequest("/update/csv");
                contentStreamUpdateRequest.setParam("stream.contentType", "text/plain;charset=utf-8");
                contentStreamUpdateRequest.setAction(AbstractUpdateRequest.ACTION.COMMIT, true, true);
                contentStreamUpdateRequest.addFile(tempCsv);
                statisticsYearServer.request((SolrRequest)contentStreamUpdateRequest);
            }
            statisticsYearServer.commit(true, true);
            solr.deleteByQuery(filterQuery.toString());
            solr.commit(true, true);
            log.info((Object)("Moved " + totalRecords + " records into core: " + coreName));
        }
        FileUtils.deleteDirectory((File)tempDirectory);
    }

    private static CommonsHttpSolrServer createCore(CommonsHttpSolrServer solr, String coreName) throws IOException, SolrServerException {
        String solrDir = ConfigurationManager.getProperty("dspace.dir") + File.separator + "solr" + File.separator;
        String baseSolrUrl = solr.getBaseURL().replace("statistics", "");
        CoreAdminRequest.Create create = new CoreAdminRequest.Create();
        create.setCoreName(coreName);
        create.setInstanceDir("statistics");
        create.setDataDir(solrDir + coreName + File.separator + "data");
        CommonsHttpSolrServer solrServer = new CommonsHttpSolrServer(baseSolrUrl);
        create.process((SolrServer)solrServer);
        log.info((Object)("Created core with name: " + coreName));
        return new CommonsHttpSolrServer(baseSolrUrl + "/" + coreName);
    }

    public static void reindexBitstreamHits(boolean removeDeletedBitstreams) throws Exception {
        Context context = new Context();
        try {
            SolrQuery query = new SolrQuery();
            query.setQuery("*:*");
            query.addFilterQuery(new String[]{"type:0"});
            query.addFilterQuery(new String[]{"-bundleName:[* TO *]"});
            query.setRows(Integer.valueOf(0));
            SolrLogger.addAdditionalSolrYearCores(query);
            long totalRecords = solr.query((SolrParams)query).getResults().getNumFound();
            File tempDirectory = new File(ConfigurationManager.getProperty("dspace.dir") + File.separator + "temp" + File.separator);
            tempDirectory.mkdirs();
            ArrayList<File> tempCsvFiles = new ArrayList<File>();
            int i = 0;
            while ((long)i < totalRecords) {
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("q", "*:*");
                params.put("fq", "-bundleName:[* TO *] AND type:0");
                params.put("wt", "csv");
                params.put("rows", String.valueOf(10000));
                params.put("start", String.valueOf(i));
                String solrRequestUrl = solr.getBaseURL() + "/select";
                solrRequestUrl = SolrLogger.generateURL(solrRequestUrl, params);
                GetMethod get = new GetMethod(solrRequestUrl);
                new HttpClient().executeMethod((HttpMethod)get);
                InputStream csvOutput = get.getResponseBodyAsStream();
                InputStreamReader csvReader = new InputStreamReader(csvOutput);
                String[][] csvParsed = CSVParser.parse((Reader)csvReader);
                String[] header = csvParsed[0];
                int idIndex = 0;
                for (int j = 0; j < header.length; ++j) {
                    if (!header[j].equals("id")) continue;
                    idIndex = j;
                }
                File tempCsv = new File(tempDirectory.getPath() + File.separatorChar + "temp." + i + ".csv");
                tempCsvFiles.add(tempCsv);
                FileOutputStream outputStream = new FileOutputStream(tempCsv);
                CSVPrinter csvp = new CSVPrinter((OutputStream)outputStream);
                csvp.setAlwaysQuote(false);
                csvp.write(header);
                csvp.write("bundleName");
                csvp.writeln();
                HashMap<Integer, String> bitBundleCache = new HashMap<Integer, String>();
                for (int j = 1; j < csvParsed.length; ++j) {
                    String[] csvLine = csvParsed[j];
                    int bitstreamId = Integer.parseInt(csvLine[idIndex]);
                    String bundleName = (String)bitBundleCache.get(bitstreamId);
                    if (bundleName == null) {
                        Bitstream bitstream = Bitstream.find(context, bitstreamId);
                        if (bitstream != null) {
                            Bundle[] bundles = bitstream.getBundles();
                            if (bundles != null && 0 < bundles.length) {
                                Bundle bundle = bundles[0];
                                bundleName = bundle.getName();
                                context.removeCached(bundle, bundle.getID());
                            } else {
                                DSpaceObject parentObject = bitstream.getParentObject();
                                if (parentObject instanceof org.dspace.content.Collection) {
                                    bundleName = "LOGO-COLLECTION";
                                } else if (parentObject instanceof Community) {
                                    bundleName = "LOGO-COMMUNITY";
                                }
                                if (parentObject != null) {
                                    context.removeCached(parentObject, parentObject.getID());
                                }
                            }
                            bitBundleCache.put(bitstream.getID(), bundleName);
                            context.removeCached(bitstream, bitstreamId);
                        }
                        if (bundleName == null && !removeDeletedBitstreams) {
                            bundleName = "BITSTREAM_DELETED";
                        }
                    }
                    csvp.write(csvLine);
                    csvp.write(bundleName);
                    csvp.writeln();
                }
                csvp.flush();
                csvp.close();
                i += 10000;
            }
            for (File tempCsv : tempCsvFiles) {
                ContentStreamUpdateRequest contentStreamUpdateRequest = new ContentStreamUpdateRequest("/update/csv");
                contentStreamUpdateRequest.setParam("stream.contentType", "text/plain;charset=utf-8");
                contentStreamUpdateRequest.setAction(AbstractUpdateRequest.ACTION.COMMIT, true, true);
                contentStreamUpdateRequest.addFile(tempCsv);
                solr.request((SolrRequest)contentStreamUpdateRequest);
            }
            solr.deleteByQuery("-bundleName:[* TO *] AND type:0");
            solr.commit(true, true);
            FileUtils.deleteDirectory((File)tempDirectory);
        }
        catch (Exception e) {
            log.error((Object)"Error while updating the bitstream statistics", (Throwable)e);
            throw e;
        }
        finally {
            context.abort();
        }
    }

    private static String generateURL(String baseURL, Map<String, String> parameters) throws UnsupportedEncodingException {
        boolean first = true;
        StringBuilder result = new StringBuilder(baseURL);
        for (String key : parameters.keySet()) {
            if (first) {
                result.append("?");
                first = false;
            } else {
                result.append("&");
            }
            result.append(key).append("=").append(URLEncoder.encode(parameters.get(key), "UTF-8"));
        }
        return result.toString();
    }

    private static void addAdditionalSolrYearCores(SolrQuery solrQuery) {
        if (0 < statisticYearCores.size()) {
            solrQuery.add("shards", new String[]{StringUtils.join(statisticYearCores.iterator(), (String)",")});
        }
    }

    static {
        String metadataVal;
        log = Logger.getLogger(SolrLogger.class);
        statisticYearCores = new ArrayList<String>();
        log.info((Object)("solr-statistics.spidersfile:" + ConfigurationManager.getProperty("solr-statistics", "spidersfile")));
        log.info((Object)("solr-statistics.server:" + ConfigurationManager.getProperty("solr-statistics", "server")));
        log.info((Object)("usage-statistics.dbfile:" + ConfigurationManager.getProperty("usage-statistics", "dbfile")));
        CommonsHttpSolrServer server = null;
        if (ConfigurationManager.getProperty("solr-statistics", "server") != null) {
            try {
                server = new CommonsHttpSolrServer(ConfigurationManager.getProperty("solr-statistics", "server"));
                SolrQuery solrQuery = new SolrQuery().setQuery("type:2 AND id:1");
                server.query((SolrParams)solrQuery);
                File solrDir = new File(ConfigurationManager.getProperty("dspace.dir") + "/solr/");
                File[] solrCoreFiles = solrDir.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        return file.getName().matches("statistics-\\d\\d\\d\\d");
                    }
                });
                String baseSolrUrl = server.getBaseURL().replace("statistics", "");
                for (File solrCoreFile : solrCoreFiles) {
                    log.info((Object)("Loading core with name: " + solrCoreFile.getName()));
                    SolrLogger.createCore(server, solrCoreFile.getName());
                    statisticYearCores.add(baseSolrUrl.replace("http://", "").replace("https://", "") + solrCoreFile.getName());
                }
                statisticYearCores.add(server.getBaseURL().replace("http://", "").replace("https://", ""));
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        solr = server;
        LookupService service = null;
        String dbfile = ConfigurationManager.getProperty("solr-statistics", "dbfile");
        if (dbfile != null) {
            try {
                service = new LookupService(dbfile, 0);
            }
            catch (FileNotFoundException fe) {
                log.error((Object)("The GeoLite Database file is missing (" + dbfile + ")! Solr Statistics cannot generate location based reports! Please see the DSpace installation instructions for instructions to install this file."), (Throwable)fe);
            }
            catch (IOException e) {
                log.error((Object)("Unable to load GeoLite Database file (" + dbfile + ")! You may need to reinstall it. See the DSpace installation instructions for more details."), (Throwable)e);
            }
        } else {
            log.error((Object)"The required 'dbfile' configuration is missing in solr-statistics.cfg!");
        }
        locationService = service;
        useProxies = "true".equals(ConfigurationManager.getProperty("useProxies"));
        log.info((Object)("useProxies=" + useProxies));
        metadataStorageInfo = new HashMap<String, String>();
        int count = 1;
        while ((metadataVal = ConfigurationManager.getProperty("solr-statistics", "metadata.item." + count)) != null) {
            String storeVal = metadataVal.split(":")[0];
            String metadataField = metadataVal.split(":")[1];
            metadataStorageInfo.put(storeVal, metadataField);
            log.info((Object)("solr-statistics.metadata.item." + count + "=" + metadataVal));
            ++count;
        }
        filterQuery = null;
    }

    public static class ResultProcessor {
        public void execute(String query) throws SolrServerException, IOException {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("q", query);
            params.put("rows", "10");
            if (0 < statisticYearCores.size()) {
                params.put("shards", StringUtils.join(statisticYearCores.iterator(), (char)','));
            }
            MapSolrParams solrParams = new MapSolrParams(params);
            QueryResponse response = solr.query((SolrParams)solrParams);
            long numbFound = response.getResults().getNumFound();
            this.process((List<SolrDocument>)response.getResults());
            int i = 10;
            while ((long)i < numbFound) {
                params.put("start", String.valueOf(i));
                solrParams = new MapSolrParams(params);
                response = solr.query((SolrParams)solrParams);
                this.process((List<SolrDocument>)response.getResults());
                i += 10;
            }
        }

        public void commit() throws IOException, SolrServerException {
            solr.commit();
        }

        public void process(List<SolrDocument> docs) throws IOException, SolrServerException {
            for (SolrDocument doc : docs) {
                this.process(doc);
            }
        }

        public void process(SolrDocument doc) throws IOException, SolrServerException {
        }
    }

    public static enum StatisticsType {
        VIEW("view"),
        SEARCH("search"),
        SEARCH_RESULT("search_result"),
        WORKFLOW("workflow");

        private final String text;

        private StatisticsType(String text) {
            this.text = text;
        }

        public String text() {
            return this.text;
        }
    }
}

