/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.statistics.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.dspace.core.ConfigurationManager;
import org.dspace.statistics.util.IPTable;

public class SpiderDetector {
    private static Logger log = Logger.getLogger(SpiderDetector.class);
    private static Boolean useProxies;
    private static IPTable table;

    public static Set<String> readIpAddresses(File spiderIpFile) throws IOException {
        String line;
        HashSet<String> ips = new HashSet<String>();
        if (!spiderIpFile.exists() || !spiderIpFile.isFile()) {
            return ips;
        }
        BufferedReader in = new BufferedReader(new FileReader(spiderIpFile));
        while ((line = in.readLine()) != null) {
            if (line.startsWith("#") || !(line = line.trim()).equals("") && !Character.isDigit(line.charAt(0)) || line.equals("")) continue;
            ips.add(line);
        }
        in.close();
        return ips;
    }

    public static Set<String> getSpiderIpAddresses() {
        SpiderDetector.loadSpiderIpAddresses();
        return table.toSet();
    }

    private static void loadSpiderIpAddresses() {
        if (table == null) {
            table = new IPTable();
            String filePath = ConfigurationManager.getProperty("dspace.dir");
            try {
                File spidersDir = new File(filePath, "config/spiders");
                if (spidersDir.exists() && spidersDir.isDirectory()) {
                    for (File file : spidersDir.listFiles()) {
                        for (String ip : SpiderDetector.readIpAddresses(file)) {
                            table.add(ip);
                        }
                        log.info((Object)("Loaded Spider IP file: " + file));
                    }
                } else {
                    log.info((Object)"No spider file loaded");
                }
            }
            catch (Exception e) {
                log.error((Object)("Error Loading Spiders:" + e.getMessage()), (Throwable)e);
            }
        }
    }

    public static boolean isSpider(HttpServletRequest request) {
        if (SpiderDetector.isUseProxies() && request.getHeader("X-Forwarded-For") != null) {
            for (String xfip : request.getHeader("X-Forwarded-For").split(",")) {
                if (!SpiderDetector.isSpider(xfip)) continue;
                return true;
            }
        }
        return SpiderDetector.isSpider(request.getRemoteAddr());
    }

    public static boolean isSpider(String ip) {
        if (table == null) {
            SpiderDetector.loadSpiderIpAddresses();
        }
        try {
            if (table.contains(ip)) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    private static boolean isUseProxies() {
        if (useProxies == null) {
            useProxies = "true".equals(ConfigurationManager.getProperty("useProxies")) ? Boolean.valueOf(true) : Boolean.valueOf(false);
        }
        return useProxies;
    }

    static {
        table = null;
    }
}

