/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.submit.step;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.time.DateUtils;
import org.apache.log4j.Logger;
import org.dspace.app.util.SubmissionInfo;
import org.dspace.app.util.Util;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.handle.HandleManager;
import org.dspace.submit.AbstractProcessingStep;

public class AccessStep
extends AbstractProcessingStep {
    public static final int STATUS_ERROR_FORMAT_DATE = 1;
    public static final int STATUS_ERROR_MISSING_DATE = 2;
    public static final int STATUS_ERROR_SELECT_GROUP = 3;
    public static final int STATUS_DUPLICATED_POLICY = 4;
    public static final int EDIT_POLICY_STATUS_DUPLICATED_POLICY = 5;
    public static final int STATUS_EDIT_POLICY = 10;
    public static final String SUB_INFO_SELECTED_RP = "SUB_INFO_SELECTED_RP";
    private static Logger log = Logger.getLogger(AccessStep.class);
    public static final String FORM_EDIT_BUTTON_CANCEL = "submit_edit_cancel";
    public static final String FORM_EDIT_BUTTON_SAVE = "submit_save";
    public static final String FORM_ACCESS_BUTTON_ADD = "submit_add_policy";

    @Override
    public int doProcessing(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo) throws ServletException, IOException, SQLException, AuthorizeException {
        String buttonPressed = Util.getSubmitButton(request, "submit_cancel");
        Item item = subInfo.getSubmissionItem().getItem();
        int groupID = 0;
        if (request.getParameter("group_id") != null) {
            try {
                groupID = Integer.parseInt(request.getParameter("group_id"));
            }
            catch (NumberFormatException nfe) {
                return 3;
            }
        }
        String name = request.getParameter("name");
        String reason = request.getParameter("reason");
        if (AccessStep.wasEditPolicyPressed(context, buttonPressed, subInfo)) {
            return 10;
        }
        if (AccessStep.wasRemovePolicyPressed(buttonPressed)) {
            AccessStep.removePolicy(context, buttonPressed);
            context.commit();
            return 0;
        }
        if (AccessStep.comeFromEditPolicy(request)) {
            return AccessStep.saveOrCancelEditPolicy(context, request, subInfo, buttonPressed, item, name, groupID, reason);
        }
        if (AccessStep.wasAddPolicyPressed(buttonPressed)) {
            int result = -1;
            result = AccessStep.checkForm(request);
            if (result != 0) {
                return result;
            }
            item.setDiscoverable(true);
            if (request.getParameter("private_option") != null) {
                item.setDiscoverable(false);
            }
            Date dateStartDate = AccessStep.getEmbargoUntil(request);
            ResourcePolicy rp = null;
            rp = AuthorizeManager.createOrModifyPolicy(null, context, name, groupID, null, dateStartDate, 0, reason, item);
            if (rp == null) {
                return 4;
            }
            rp.update();
            context.commit();
            return 0;
        }
        boolean isAdvancedFormEnabled = ConfigurationManager.getBooleanProperty("xmlui.submission.restrictstep.enableAdvancedForm", false);
        if (!isAdvancedFormEnabled) {
            AuthorizeManager.generateAutomaticPolicies(context, AccessStep.getEmbargoUntilDate(request), reason, item, (Collection)HandleManager.resolveToObject(context, subInfo.getCollectionHandle()));
        }
        item.setDiscoverable(true);
        if (request.getParameter("private_option") != null) {
            item.setDiscoverable(false);
        }
        item.update();
        context.commit();
        return 0;
    }

    public static boolean wasEditPolicyPressed(Context context, String buttonPressed, SubmissionInfo subInfo) throws SQLException {
        if (buttonPressed.startsWith("submit_edit_edit_policies_") && !buttonPressed.equals(FORM_EDIT_BUTTON_CANCEL)) {
            String idPolicy = buttonPressed.substring("submit_edit_edit_policies_".length());
            ResourcePolicy rp = ResourcePolicy.find(context, Integer.parseInt(idPolicy));
            subInfo.put(SUB_INFO_SELECTED_RP, rp);
            return true;
        }
        return false;
    }

    public static boolean wasAddPolicyPressed(String buttonPressed) throws SQLException {
        return buttonPressed.equalsIgnoreCase(FORM_ACCESS_BUTTON_ADD);
    }

    public static boolean wasRemovePolicyPressed(String buttonPressed) throws SQLException {
        return buttonPressed.startsWith("submit_delete_edit_policies_");
    }

    public static boolean comeFromEditPolicy(HttpServletRequest request) throws SQLException {
        return request.getParameter("policy_id") != null;
    }

    public static int saveOrCancelEditPolicy(Context context, HttpServletRequest request, SubmissionInfo subInfo, String buttonPressed, DSpaceObject dso, String name, int groupID, String reason) throws AuthorizeException, SQLException {
        if (buttonPressed.equals(FORM_EDIT_BUTTON_CANCEL)) {
            return 0;
        }
        if (buttonPressed.equals(FORM_EDIT_BUTTON_SAVE)) {
            String idPolicy = request.getParameter("policy_id");
            ResourcePolicy resourcePolicy = ResourcePolicy.find(context, Integer.parseInt(idPolicy));
            subInfo.put(SUB_INFO_SELECTED_RP, resourcePolicy);
            Date dateStartDate = AccessStep.getEmbargoUntil(request);
            resourcePolicy = AuthorizeManager.createOrModifyPolicy(resourcePolicy, context, name, groupID, null, dateStartDate, 0, reason, dso);
            if (resourcePolicy == null) {
                return 5;
            }
            resourcePolicy.update();
            context.commit();
        }
        return 0;
    }

    public static void removePolicy(Context context, String buttonPressed) throws SQLException {
        String idPolicy = buttonPressed.substring("submit_delete_edit_policies_".length());
        ResourcePolicy rp = ResourcePolicy.find(context, Integer.parseInt(idPolicy));
        rp.delete();
    }

    public static int checkForm(HttpServletRequest request) {
        Date startDate;
        String selectedRadio = null;
        String dateEmbargoUntil = request.getParameter("embargo_until_date");
        selectedRadio = request.getParameter("open_access_radios");
        if (selectedRadio != null && Integer.parseInt(selectedRadio) == 1 && (dateEmbargoUntil == null || dateEmbargoUntil.equals(""))) {
            return 2;
        }
        if (dateEmbargoUntil != null && !dateEmbargoUntil.equals("") && (startDate = AccessStep.getEmbargoUntilDate(request)) == null) {
            return 1;
        }
        return 0;
    }

    public static Date getEmbargoUntil(HttpServletRequest request) {
        Date startDate;
        Date dateStartDate = null;
        String selectedRadio = request.getParameter("open_access_radios");
        if (selectedRadio != null && Integer.parseInt(selectedRadio) == 1 && (startDate = AccessStep.getEmbargoUntilDate(request)) != null) {
            dateStartDate = startDate;
        }
        return dateStartDate;
    }

    private static Date getEmbargoUntilDate(HttpServletRequest request) {
        Date startDate = null;
        try {
            startDate = DateUtils.parseDate((String)request.getParameter("embargo_until_date"), (String[])new String[]{"yyyy-MM-dd", "yyyy-MM", "yyyy"});
        }
        catch (Exception exception) {
            // empty catch block
        }
        return startDate;
    }

    @Override
    public int getNumberOfPages(HttpServletRequest request, SubmissionInfo subInfo) throws ServletException {
        return 1;
    }
}

