/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.versioning;

import java.sql.SQLException;
import java.util.List;
import org.dspace.core.Context;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.TableRow;
import org.dspace.versioning.Version;
import org.dspace.versioning.VersionDAO;
import org.dspace.versioning.VersionHistoryImpl;
import org.dspace.versioning.VersionImpl;

public class VersionHistoryDAO {
    protected static final String TABLE_NAME = "versionhistory";
    protected static final String VERSION_HISTORY_ID = "versionhistory_id";

    public VersionHistoryImpl create(Context context) {
        try {
            TableRow row = DatabaseManager.create(context, TABLE_NAME);
            VersionHistoryImpl vh = new VersionHistoryImpl(context, row);
            return vh;
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public VersionHistoryImpl find(Context context, int itemID, VersionDAO versionDAO) {
        try {
            VersionImpl version = versionDAO.findByItemId(context, itemID);
            if (version == null) {
                return null;
            }
            VersionHistoryImpl fromCache = (VersionHistoryImpl)context.fromCache(VersionHistoryImpl.class, version.getVersionHistoryID());
            if (fromCache != null) {
                return fromCache;
            }
            TableRow row = DatabaseManager.find(context, TABLE_NAME, version.getVersionHistoryID());
            VersionHistoryImpl vh = new VersionHistoryImpl(context, row);
            List<Version> versions = versionDAO.findByVersionHistory(context, vh.getVersionHistoryId());
            vh.setVersions(versions);
            return vh;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public VersionHistoryImpl findById(Context context, int id, VersionDAO versionDAO) {
        try {
            TableRow row = DatabaseManager.find(context, TABLE_NAME, id);
            if (row == null) {
                return null;
            }
            VersionHistoryImpl fromCache = (VersionHistoryImpl)context.fromCache(VersionHistoryImpl.class, row.getIntColumn(VERSION_HISTORY_ID));
            if (fromCache != null) {
                return fromCache;
            }
            VersionHistoryImpl versionHistoryImpl = new VersionHistoryImpl(context, row);
            List<Version> versions = versionDAO.findByVersionHistory(context, versionHistoryImpl.getVersionHistoryId());
            versionHistoryImpl.setVersions(versions);
            return versionHistoryImpl;
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void delete(Context c, int versionHistoryID, VersionDAO versionDAO) {
        try {
            VersionHistoryImpl history = this.findById(c, versionHistoryID, versionDAO);
            DatabaseManager.delete(c, history.getMyRow());
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

