/*
 * Decompiled with CFR 0.152.
 */
package org.easyrules.spring;

import java.util.List;
import org.easyrules.api.RuleListener;
import org.easyrules.api.RulesEngine;
import org.easyrules.core.DefaultRulesEngine;
import org.easyrules.core.RulesEngineBuilder;
import org.springframework.beans.factory.FactoryBean;

public class RulesEngineFactoryBean
implements FactoryBean<RulesEngine> {
    private int rulePriorityThreshold = Integer.MAX_VALUE;
    private boolean skipOnFirstAppliedRule;
    private boolean skipOnFirstFailedRule;
    private boolean silentMode;
    private List<Object> rules;
    private List<RuleListener> ruleListeners;

    public RulesEngine getObject() {
        RulesEngineBuilder rulesEngineBuilder = RulesEngineBuilder.aNewRulesEngine().withSkipOnFirstAppliedRule(this.skipOnFirstAppliedRule).withSkipOnFirstFailedRule(this.skipOnFirstFailedRule).withRulePriorityThreshold(this.rulePriorityThreshold).withSilentMode(this.silentMode);
        this.registerRuleListeners(rulesEngineBuilder);
        DefaultRulesEngine rulesEngine = rulesEngineBuilder.build();
        this.registerRules(this.rules, (RulesEngine)rulesEngine);
        return rulesEngine;
    }

    public Class<RulesEngine> getObjectType() {
        return RulesEngine.class;
    }

    public boolean isSingleton() {
        return false;
    }

    private void registerRules(List<Object> rules, RulesEngine rulesEngine) {
        if (rules != null && !rules.isEmpty()) {
            for (Object rule : rules) {
                rulesEngine.registerRule(rule);
            }
        }
    }

    private void registerRuleListeners(RulesEngineBuilder rulesEngineBuilder) {
        if (this.ruleListeners != null && !this.ruleListeners.isEmpty()) {
            for (RuleListener ruleListener : this.ruleListeners) {
                rulesEngineBuilder.withRuleListener(ruleListener);
            }
        }
    }

    public void setRuleListeners(List<RuleListener> ruleListeners) {
        this.ruleListeners = ruleListeners;
    }

    public void setRules(List<Object> rules) {
        this.rules = rules;
    }

    public void setRulePriorityThreshold(int rulePriorityThreshold) {
        this.rulePriorityThreshold = rulePriorityThreshold;
    }

    public void setSilentMode(boolean silentMode) {
        this.silentMode = silentMode;
    }

    public void setSkipOnFirstAppliedRule(boolean skipOnFirstAppliedRule) {
        this.skipOnFirstAppliedRule = skipOnFirstAppliedRule;
    }

    public void setSkipOnFirstFailedRule(boolean skipOnFirstFailedRule) {
        this.skipOnFirstFailedRule = skipOnFirstFailedRule;
    }
}

