/*
 * Decompiled with CFR 0.152.
 */
package org.fest.reflect.field;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.fest.reflect.field.Invoker;
import org.fest.reflect.field.decorator.DecoratorInvocationHandler;
import org.fest.reflect.field.decorator.RuntimeExceptionShield;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DecoratedInvoker<T> {
    private final T target;
    private final T decorator;
    private final Invoker<T> invoker;
    private final Class<?> expectedType;
    private final DecoratorInvocationHandler<T> decoratorInvocationHandler;

    static <T> DecoratedInvoker<T> newInvoker(T target, T decorator, Class<?> expectedType, Invoker<T> invoker, DecoratorInvocationHandler<T> decoratorInvocationHandler) {
        return new DecoratedInvoker<T>(target, decorator, expectedType, invoker, decoratorInvocationHandler);
    }

    private DecoratedInvoker(T target, T decorator, Class<?> expectedType, Invoker<T> invoker, DecoratorInvocationHandler<T> decoratorInvocationHandler) {
        this.target = target;
        this.decorator = decorator;
        this.invoker = invoker;
        this.expectedType = expectedType;
        this.decoratorInvocationHandler = decoratorInvocationHandler;
    }

    public DecoratedInvoker<T> ignoringDecoratorExceptions() {
        return this.ignoringDecoratorExceptionsOfType(RuntimeException.class);
    }

    public DecoratedInvoker<T> ignoringDecoratorExceptionsOfType(Class<?> exceptionClass) {
        RuntimeExceptionShield runtimeExceptionShield = new RuntimeExceptionShield(this.decorator, exceptionClass);
        Object exceptionSafeDecorator = Proxy.newProxyInstance(this.decorator.getClass().getClassLoader(), new Class[]{this.expectedType}, (InvocationHandler)runtimeExceptionShield);
        this.decoratorInvocationHandler.setDecorator(exceptionSafeDecorator);
        return DecoratedInvoker.newInvoker(this.target, exceptionSafeDecorator, this.expectedType, this.invoker, this.decoratorInvocationHandler);
    }

    public DecoratedInvoker<T> returningDecoratorResult() {
        this.decoratorInvocationHandler.setReturnDecoratorResult(true);
        return DecoratedInvoker.newInvoker(this.target, this.decorator, this.expectedType, this.invoker, this.decoratorInvocationHandler);
    }

    public DecoratedInvoker<T> preDecorateWith(T decorator) {
        return this.invoker.preDecorateWith(decorator);
    }

    public DecoratedInvoker<T> postDecorateWith(T decorator) {
        return this.invoker.postDecorateWith(decorator);
    }
}

