/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cloud.aws;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.Protocol;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSCredentialsProviderChain;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.EnvironmentVariableCredentialsProvider;
import com.amazonaws.auth.InstanceProfileCredentialsProvider;
import com.amazonaws.auth.SystemPropertiesCredentialsProvider;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.AmazonEC2Client;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.cloud.aws.AwsSettingsFilter;
import org.elasticsearch.cloud.aws.AwsSigner;
import org.elasticsearch.cloud.aws.network.Ec2NameResolver;
import org.elasticsearch.cloud.aws.node.Ec2CustomNodeAttributes;
import org.elasticsearch.cluster.node.DiscoveryNodeService;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;

public class AwsEc2Service
extends AbstractLifecycleComponent<AwsEc2Service> {
    public static final String EC2_METADATA_URL = "http://169.254.169.254/latest/meta-data/";
    private AmazonEC2Client client;

    @Inject
    public AwsEc2Service(Settings settings, SettingsFilter settingsFilter, NetworkService networkService, DiscoveryNodeService discoveryNodeService) {
        super(settings);
        settingsFilter.addFilter((SettingsFilter.Filter)new AwsSettingsFilter());
        networkService.addCustomNameResolver((NetworkService.CustomNameResolver)new Ec2NameResolver(settings));
        discoveryNodeService.addCustomAttributeProvider((DiscoveryNodeService.CustomAttributesProvider)new Ec2CustomNodeAttributes(settings));
    }

    public synchronized AmazonEC2 client() {
        String awsSigner;
        if (this.client != null) {
            return this.client;
        }
        ClientConfiguration clientConfiguration = new ClientConfiguration();
        clientConfiguration.setResponseMetadataCacheSize(0);
        String protocol = this.componentSettings.get("protocol", "https").toLowerCase();
        protocol = this.componentSettings.get("ec2.protocol", protocol).toLowerCase();
        if ("http".equals(protocol)) {
            clientConfiguration.setProtocol(Protocol.HTTP);
        } else if ("https".equals(protocol)) {
            clientConfiguration.setProtocol(Protocol.HTTPS);
        } else {
            throw new ElasticsearchIllegalArgumentException("No protocol supported [" + protocol + "], can either be [http] or [https]");
        }
        String account = this.componentSettings.get("access_key", this.settings.get("cloud.account"));
        String key = this.componentSettings.get("secret_key", this.settings.get("cloud.key"));
        String proxyHost = this.settings.get("cloud.aws.proxy_host");
        proxyHost = this.settings.get("cloud.aws.ec2.proxy_host", proxyHost);
        if (proxyHost != null) {
            Integer proxyPort;
            String portString = this.settings.get("cloud.aws.proxy_port", "80");
            portString = this.settings.get("cloud.aws.ec2.proxy_port", portString);
            try {
                proxyPort = Integer.parseInt(portString, 10);
            }
            catch (NumberFormatException ex) {
                throw new ElasticsearchIllegalArgumentException("The configured proxy port value [" + portString + "] is invalid", (Throwable)ex);
            }
            clientConfiguration.withProxyHost(proxyHost).setProxyPort(proxyPort.intValue());
        }
        if ((awsSigner = this.settings.get("cloud.aws.ec2.signer", this.settings.get("cloud.aws.signer"))) != null) {
            this.logger.debug("using AWS API signer [{}]", new Object[]{awsSigner});
            try {
                AwsSigner.configureSigner(awsSigner, clientConfiguration);
            }
            catch (ElasticsearchIllegalArgumentException e) {
                this.logger.warn("wrong signer set for [cloud.aws.ec2.signer] or [cloud.aws.signer]: [{}]", new Object[]{awsSigner});
            }
        }
        AWSCredentialsProviderChain credentials = account == null && key == null ? new AWSCredentialsProviderChain(new AWSCredentialsProvider[]{new EnvironmentVariableCredentialsProvider(), new SystemPropertiesCredentialsProvider(), new InstanceProfileCredentialsProvider()}) : new AWSCredentialsProviderChain(new AWSCredentialsProvider[]{new StaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(account, key))});
        this.client = new AmazonEC2Client((AWSCredentialsProvider)credentials, clientConfiguration);
        if (this.componentSettings.get("ec2.endpoint") != null) {
            String endpoint = this.componentSettings.get("ec2.endpoint");
            this.logger.debug("using explicit ec2 endpoint [{}]", new Object[]{endpoint});
            this.client.setEndpoint(endpoint);
        } else if (this.componentSettings.get("region") != null) {
            String endpoint;
            String region = this.componentSettings.get("region").toLowerCase();
            if (region.equals("us-east-1") || region.equals("us-east")) {
                endpoint = "ec2.us-east-1.amazonaws.com";
            } else if (region.equals("us-west") || region.equals("us-west-1")) {
                endpoint = "ec2.us-west-1.amazonaws.com";
            } else if (region.equals("us-west-2")) {
                endpoint = "ec2.us-west-2.amazonaws.com";
            } else if (region.equals("ap-southeast") || region.equals("ap-southeast-1")) {
                endpoint = "ec2.ap-southeast-1.amazonaws.com";
            } else if (region.equals("ap-southeast-2")) {
                endpoint = "ec2.ap-southeast-2.amazonaws.com";
            } else if (region.equals("ap-northeast") || region.equals("ap-northeast-1")) {
                endpoint = "ec2.ap-northeast-1.amazonaws.com";
            } else if (region.equals("eu-west") || region.equals("eu-west-1")) {
                endpoint = "ec2.eu-west-1.amazonaws.com";
            } else if (region.equals("eu-central") || region.equals("eu-central-1")) {
                endpoint = "ec2.eu-central-1.amazonaws.com";
            } else if (region.equals("sa-east") || region.equals("sa-east-1")) {
                endpoint = "ec2.sa-east-1.amazonaws.com";
            } else if (region.equals("cn-north") || region.equals("cn-north-1")) {
                endpoint = "ec2.cn-north-1.amazonaws.com.cn";
            } else {
                throw new ElasticsearchIllegalArgumentException("No automatic endpoint could be derived from region [" + region + "]");
            }
            if (endpoint != null) {
                this.logger.debug("using ec2 region [{}], with endpoint [{}]", new Object[]{region, endpoint});
                this.client.setEndpoint(endpoint);
            }
        }
        return this.client;
    }

    protected void doStart() throws ElasticsearchException {
    }

    protected void doStop() throws ElasticsearchException {
    }

    protected void doClose() throws ElasticsearchException {
        if (this.client != null) {
            this.client.shutdown();
        }
    }
}

