/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cloud.aws.node;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.util.IOUtils;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.cluster.node.DiscoveryNodeService;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.Settings;

public class Ec2CustomNodeAttributes
extends AbstractComponent
implements DiscoveryNodeService.CustomAttributesProvider {
    public Ec2CustomNodeAttributes(Settings settings) {
        super(settings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> buildAttributes() {
        String metadataResult;
        InputStream in;
        HashMap ec2Attributes;
        block6: {
            if (!this.settings.getAsBoolean("cloud.node.auto_attributes", Boolean.valueOf(false)).booleanValue()) {
                return null;
            }
            ec2Attributes = Maps.newHashMap();
            in = null;
            URL url = new URL("http://169.254.169.254/latest/meta-data/placement/availability-zone");
            this.logger.debug("obtaining ec2 [placement/availability-zone] from ec2 meta-data url {}", new Object[]{url});
            URLConnection urlConnection = url.openConnection();
            urlConnection.setConnectTimeout(2000);
            in = urlConnection.getInputStream();
            BufferedReader urlReader = new BufferedReader(new InputStreamReader(in));
            metadataResult = urlReader.readLine();
            if (metadataResult != null && metadataResult.length() != 0) break block6;
            this.logger.error("no ec2 metadata returned from {}", new Object[]{url});
            Map<String, String> map = null;
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{in});
            return map;
        }
        try {
            ec2Attributes.put("aws_availability_zone", metadataResult);
        }
        catch (IOException e) {
            try {
                this.logger.debug("failed to get metadata for [placement/availability-zone]: " + ExceptionsHelper.detailedMessage((Throwable)e), new Object[0]);
            }
            catch (Throwable throwable) {
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{in});
                throw throwable;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{in});
        }
        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{in});
        return ec2Attributes;
    }
}

