/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.jdk;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class JavaVersion
implements Comparable<JavaVersion> {
    private final List<Integer> version;
    private final String prePart;
    private static final JavaVersion CURRENT = JavaVersion.parse(System.getProperty("java.specification.version"));

    public List<Integer> getVersion() {
        return this.version;
    }

    private JavaVersion(List<Integer> version, String prePart) {
        this.prePart = prePart;
        if (version.size() >= 2 && version.get(0) == 1 && version.get(1) == 8) {
            version = new ArrayList<Integer>(version.subList(1, version.size()));
        }
        this.version = Collections.unmodifiableList(version);
    }

    public static JavaVersion parse(String value) {
        String[] numericComponents;
        Objects.requireNonNull(value);
        String prePart = null;
        if (!JavaVersion.isValid(value)) {
            throw new IllegalArgumentException("Java version string [" + value + "] could not be parsed.");
        }
        ArrayList<Integer> version = new ArrayList<Integer>();
        String[] parts = value.split("-");
        if (parts.length == 1) {
            numericComponents = value.split("\\.");
        } else if (parts.length == 2) {
            numericComponents = parts[0].split("\\.");
            prePart = parts[1];
        } else {
            throw new IllegalArgumentException("Java version string [" + value + "] could not be parsed.");
        }
        for (String component : numericComponents) {
            version.add(Integer.valueOf(component));
        }
        return new JavaVersion(version, prePart);
    }

    public static boolean isValid(String value) {
        return value.matches("^0*[0-9]+(\\.[0-9]+)*(-[a-zA-Z0-9]+)?$");
    }

    public static JavaVersion current() {
        return CURRENT;
    }

    @Override
    public int compareTo(JavaVersion o) {
        int len = Math.max(this.version.size(), o.version.size());
        for (int i = 0; i < len; ++i) {
            int s;
            int d = i < this.version.size() ? this.version.get(i) : 0;
            int n = s = i < o.version.size() ? o.version.get(i) : 0;
            if (s < d) {
                return 1;
            }
            if (s <= d) continue;
            return -1;
        }
        if (this.prePart != null && o.prePart == null) {
            return -1;
        }
        if (this.prePart == null && o.prePart != null) {
            return 1;
        }
        if (this.prePart != null && o.prePart != null) {
            return this.comparePrePart(this.prePart, o.prePart);
        }
        return 0;
    }

    private int comparePrePart(String prePart, String otherPrePart) {
        if (prePart.matches("\\d+")) {
            return otherPrePart.matches("\\d+") ? new BigInteger(prePart).compareTo(new BigInteger(otherPrePart)) : -1;
        }
        return otherPrePart.matches("\\d+") ? 1 : prePart.compareTo(otherPrePart);
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        return this.compareTo((JavaVersion)o) == 0;
    }

    public int hashCode() {
        return this.version.hashCode();
    }

    public String toString() {
        String versionString = this.version.stream().map(v -> Integer.toString(v)).collect(Collectors.joining("."));
        return this.prePart != null ? versionString + "-" + this.prePart : versionString;
    }
}

