/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.blobstore.hdfs;

import java.io.IOException;
import java.util.concurrent.Executor;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.BlobStore;
import org.elasticsearch.common.blobstore.ImmutableBlobContainer;
import org.elasticsearch.common.blobstore.hdfs.HdfsImmutableBlobContainer;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;

public class HdfsBlobStore
implements BlobStore {
    private final FileSystem fileSystem;
    private final Path path;
    private final Executor executor;
    private final int bufferSizeInBytes;

    public HdfsBlobStore(Settings settings, FileSystem fileSystem, Executor executor, Path path) throws IOException {
        this.fileSystem = fileSystem;
        this.path = path;
        if (!fileSystem.exists(path)) {
            fileSystem.mkdirs(path);
        }
        this.bufferSizeInBytes = (int)settings.getAsBytesSize("buffer_size", new ByteSizeValue(100L, ByteSizeUnit.KB)).bytes();
        this.executor = executor;
    }

    public String toString() {
        return this.path.toString();
    }

    public int bufferSizeInBytes() {
        return this.bufferSizeInBytes;
    }

    public FileSystem fileSystem() {
        return this.fileSystem;
    }

    public Path path() {
        return this.path;
    }

    public Executor executor() {
        return this.executor;
    }

    public ImmutableBlobContainer immutableBlobContainer(BlobPath path) {
        return new HdfsImmutableBlobContainer(this, path, this.buildAndCreate(path));
    }

    public void delete(BlobPath path) {
        try {
            this.fileSystem.delete(this.buildPath(path), true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void close() {
    }

    private Path buildAndCreate(BlobPath blobPath) {
        Path path = this.buildPath(blobPath);
        try {
            this.fileSystem.mkdirs(path);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return path;
    }

    private Path buildPath(BlobPath blobPath) {
        Path path = this.path;
        for (String p : blobPath) {
            path = new Path(path, p);
        }
        return path;
    }
}

