/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.blobstore.hdfs;

import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.ImmutableBlobContainer;
import org.elasticsearch.common.blobstore.hdfs.AbstractHdfsBlobContainer;
import org.elasticsearch.common.blobstore.hdfs.HdfsBlobStore;
import org.elasticsearch.common.blobstore.support.BlobStores;

public class HdfsImmutableBlobContainer
extends AbstractHdfsBlobContainer
implements ImmutableBlobContainer {
    public HdfsImmutableBlobContainer(HdfsBlobStore blobStore, BlobPath blobPath, Path path) {
        super(blobStore, blobPath, path);
    }

    public void writeBlob(final String blobName, final InputStream is, long sizeInBytes, final ImmutableBlobContainer.WriterListener listener) {
        this.blobStore.executor().execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                FSDataOutputStream fileStream;
                Path file = new Path(HdfsImmutableBlobContainer.this.path, blobName);
                try {
                    fileStream = HdfsImmutableBlobContainer.this.blobStore.fileSystem().create(file, true);
                }
                catch (IOException e) {
                    listener.onFailure((Throwable)e);
                    return;
                }
                try {
                    try {
                        int bytesRead;
                        byte[] buffer = new byte[HdfsImmutableBlobContainer.this.blobStore.bufferSizeInBytes()];
                        while ((bytesRead = is.read(buffer)) != -1) {
                            fileStream.write(buffer, 0, bytesRead);
                        }
                    }
                    finally {
                        try {
                            is.close();
                        }
                        catch (IOException ex) {}
                        try {
                            fileStream.close();
                        }
                        catch (IOException ex) {}
                    }
                    listener.onCompleted();
                }
                catch (Exception e) {
                    try {
                        if (HdfsImmutableBlobContainer.this.blobStore.fileSystem().exists(file)) {
                            HdfsImmutableBlobContainer.this.blobStore.fileSystem().delete(file, true);
                        }
                    }
                    catch (Exception e1) {
                        // empty catch block
                    }
                    listener.onFailure((Throwable)e);
                }
            }
        });
    }

    public void writeBlob(String blobName, InputStream is, long sizeInBytes) throws IOException {
        BlobStores.syncWriteBlob((ImmutableBlobContainer)this, (String)blobName, (InputStream)is, (long)sizeInBytes);
    }
}

