/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.serialization.field;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.hadoop.io.Text;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.serialization.field.ConstantFieldExtractor;
import org.elasticsearch.hadoop.serialization.field.FieldExplainer;

public class MapWritableFieldExtractor
extends ConstantFieldExtractor
implements FieldExplainer {
    private Text fieldName;

    @Override
    protected Object extractField(Object target) {
        Map map;
        if (target instanceof Map && (map = (Map)target).containsKey(this.fieldName)) {
            return map.get(this.fieldName);
        }
        return NOT_FOUND;
    }

    @Override
    public void setSettings(Settings settings) {
        super.setSettings(settings);
        this.fieldName = new Text(this.getFieldName());
    }

    @Override
    public String toString(Object field) {
        if (field instanceof Map) {
            return new LinkedHashMap((Map)field).toString();
        }
        return field.toString();
    }
}

