/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.cascading;

import cascading.scheme.SinkCall;
import cascading.tuple.Tuple;
import java.util.List;
import org.apache.hadoop.io.Writable;
import org.elasticsearch.hadoop.cascading.CascadingUtils;
import org.elasticsearch.hadoop.mr.WritableValueWriter;
import org.elasticsearch.hadoop.serialization.Generator;
import org.elasticsearch.hadoop.serialization.builder.JdkValueWriter;
import org.elasticsearch.hadoop.serialization.builder.ValueWriter;

public class CascadingValueWriter
implements ValueWriter<SinkCall<Object[], ?>> {
    private final ValueWriter<Object> jdkWriter;
    private final ValueWriter<Writable> writableWriter;

    public CascadingValueWriter() {
        this(false);
    }

    public CascadingValueWriter(boolean writeUnknownTypes) {
        this.jdkWriter = new JdkValueWriter(writeUnknownTypes);
        this.writableWriter = new WritableValueWriter(writeUnknownTypes);
    }

    @Override
    public boolean write(SinkCall<Object[], ?> sinkCall, Generator generator) {
        Tuple tuple = CascadingUtils.coerceToString(sinkCall);
        List names = (List)((Object[])sinkCall.getContext())[0];
        generator.writeBeginObject();
        for (int i = 0; i < tuple.size(); ++i) {
            String name = i < names.size() ? (String)names.get(i) : "tuple" + i;
            generator.writeFieldName(name);
            Object object = tuple.getObject(i);
            if (this.jdkWriter.write(object, generator) || object instanceof Writable && this.writableWriter.write((Writable)object, generator)) continue;
            return false;
        }
        generator.writeEndObject();
        return true;
    }
}

