/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.hive;

import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.HiveMetaHook;
import org.apache.hadoop.hive.ql.metadata.DefaultStorageHandler;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.OutputFormat;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.cfg.SettingsManager;
import org.elasticsearch.hadoop.hive.EsHiveInputFormat;
import org.elasticsearch.hadoop.hive.EsHiveOutputFormat;
import org.elasticsearch.hadoop.hive.EsSerDe;
import org.elasticsearch.hadoop.mr.EsOutputFormat;
import org.elasticsearch.hadoop.mr.HadoopCfgUtils;
import org.elasticsearch.hadoop.util.Assert;

public class EsStorageHandler
extends DefaultStorageHandler {
    private static Log log = LogFactory.getLog(EsStorageHandler.class);

    public Class<? extends InputFormat> getInputFormatClass() {
        return EsHiveInputFormat.class;
    }

    public Class<? extends OutputFormat> getOutputFormatClass() {
        return EsHiveOutputFormat.class;
    }

    public Class<? extends SerDe> getSerDeClass() {
        return EsSerDe.class;
    }

    public HiveMetaHook getMetaHook() {
        return null;
    }

    public void configureInputJobProperties(TableDesc tableDesc, Map<String, String> jobProperties) {
        this.init(tableDesc, true);
        this.copyToJobProperties(jobProperties, tableDesc.getProperties());
    }

    public void configureOutputJobProperties(TableDesc tableDesc, Map<String, String> jobProperties) {
        this.init(tableDesc, false);
        this.copyToJobProperties(jobProperties, tableDesc.getProperties());
    }

    private void init(TableDesc tableDesc, boolean read) {
        Configuration cfg = this.getConf();
        Settings settings = SettingsManager.loadFrom(cfg);
        if (!read) {
            HadoopCfgUtils.setOutputCommitterClass(cfg, EsOutputFormat.EsOutputCommitter.class.getName());
        }
        Assert.hasText(tableDesc.getProperties().getProperty("location"), String.format("no table location [%s] declared by Hive resulting in abnormal execution;", "location"));
    }

    private void copyToJobProperties(Map<String, String> jobProperties, Properties properties) {
        for (String key : properties.stringPropertyNames()) {
            jobProperties.put(key, properties.getProperty(key));
        }
    }

    @Deprecated
    public void configureTableJobProperties(TableDesc tableDesc, Map<String, String> jobProperties) {
        throw new UnsupportedOperationException();
    }
}

