/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.rest;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.elasticsearch.hadoop.EsHadoopIllegalStateException;
import org.elasticsearch.hadoop.rest.RestRepository;
import org.elasticsearch.hadoop.rest.stats.Stats;
import org.elasticsearch.hadoop.rest.stats.StatsAware;
import org.elasticsearch.hadoop.serialization.ScrollReader;

public class ScrollQuery
implements Iterator<Object>,
Closeable,
StatsAware {
    private RestRepository repository;
    private String scrollId;
    private List<Object[]> batch = Collections.emptyList();
    private boolean finished = false;
    private int batchIndex = 0;
    private long read = 0L;
    private long size;
    private final ScrollReader reader;
    private final Stats stats = new Stats();

    ScrollQuery(RestRepository client, String scrollId, long size, ScrollReader reader) {
        this.repository = client;
        this.scrollId = scrollId;
        this.size = size;
        this.reader = reader;
    }

    @Override
    public void close() throws IOException {
        this.finished = true;
        this.batch = Collections.emptyList();
    }

    @Override
    public boolean hasNext() {
        if (this.finished) {
            return false;
        }
        if (this.batch.isEmpty() || this.batchIndex >= this.batch.size()) {
            if (this.read >= this.size) {
                this.finished = true;
                return false;
            }
            try {
                this.batch = this.repository.scroll(this.scrollId, this.reader);
            }
            catch (IOException ex) {
                throw new EsHadoopIllegalStateException("Cannot retrieve scroll [" + this.scrollId + "]", ex);
            }
            this.read += (long)this.batch.size();
            this.stats.docsReceived += (long)this.batch.size();
            if (this.batch.isEmpty()) {
                this.finished = true;
                return false;
            }
            this.batchIndex = 0;
        }
        return true;
    }

    public long getSize() {
        return this.size;
    }

    public long getRead() {
        return this.read;
    }

    @Override
    public Object[] next() {
        return this.batch.get(this.batchIndex++);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("read-only operator");
    }

    @Override
    public Stats stats() {
        return new Stats(this.stats);
    }

    public RestRepository repository() {
        return this.repository;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ScrollQuery [scrollId=").append(this.scrollId).append("]");
        return builder.toString();
    }
}

