/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.serialization.field;

import java.util.Collection;
import java.util.Collections;
import org.elasticsearch.hadoop.util.regex.Regex;

public abstract class FieldFilter {
    public static boolean filter(String path, Collection<String> includes, Collection<String> excludes, boolean allowPartialMatches) {
        includes = includes == null ? Collections.emptyList() : includes;
        Collection<Object> collection = excludes = excludes == null ? Collections.emptyList() : excludes;
        if (includes.isEmpty() && excludes.isEmpty()) {
            return true;
        }
        if (Regex.simpleMatch(excludes, path)) {
            return false;
        }
        boolean exactIncludeMatch = false;
        boolean pathIsPrefixOfAnInclude = false;
        if (includes.isEmpty()) {
            exactIncludeMatch = true;
        } else {
            for (String include : includes) {
                if (include.charAt(0) == '*' && Regex.simpleMatch(include, path)) {
                    exactIncludeMatch = true;
                    break;
                }
                if (include.startsWith(path)) {
                    if (include.length() == path.length()) {
                        exactIncludeMatch = true;
                        break;
                    }
                    if (include.length() > path.length() && include.charAt(path.length()) == '.') {
                        pathIsPrefixOfAnInclude = true;
                        continue;
                    }
                }
                if (!Regex.simpleMatch(include, path)) continue;
                exactIncludeMatch = true;
                break;
            }
        }
        return exactIncludeMatch || allowPartialMatches && pathIsPrefixOfAnInclude;
    }

    public static boolean filter(String path, Collection<String> includes, Collection<String> excludes) {
        return FieldFilter.filter(path, includes, excludes, true);
    }
}

