/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.cfg;

import java.io.InputStream;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.mr.HadoopCfgUtils;
import org.elasticsearch.hadoop.mr.HadoopIOUtils;
import org.elasticsearch.hadoop.util.Assert;

public class HadoopSettings
extends Settings {
    private final Configuration cfg;

    public HadoopSettings(Configuration cfg) {
        Assert.notNull(cfg, "Non-null properties expected");
        this.cfg = cfg;
    }

    @Override
    public String getProperty(String name) {
        return this.cfg.get(name);
    }

    @Override
    public void setProperty(String name, String value) {
        this.cfg.set(name, value);
    }

    @Override
    public Settings copy() {
        this.cfg.size();
        return new HadoopSettings(new Configuration(this.cfg));
    }

    @Override
    public InputStream loadResource(String location) {
        return HadoopIOUtils.open(location, this.cfg);
    }

    @Override
    protected Properties asProperties() {
        return HadoopCfgUtils.asProperties(this.cfg);
    }
}

